/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import net.claribole.zvtm.glyphs.projection.ProjectedCoords;

public class VPath
extends Glyph {
    public AffineTransform at;
    public ProjectedCoords[] pc;
    public GeneralPath path;
    LongPoint lp;
    public LongPoint realHotSpot;
    float drawingRadius;
    float drawingFactor = 1.2f;
    boolean forcedDrawing = false;

    public static VPath duplicateVPath(VPath p, long x, long y) {
        if (p != null) {
            VPath res = new VPath(0L, 0L, 0, p.getColor());
            PathIterator pi = p.getJava2DPathIterator();
            double[] cds = new double[6];
            while (!pi.isDone()) {
                int type = pi.currentSegment(cds);
                switch (type) {
                    case 3: {
                        res.addCbCurve((long)cds[4] + x, (long)(-cds[5]) + y, (long)cds[0] + x, (long)(-cds[1]) + y, (long)cds[2] + x, (long)(-cds[3]) + y, true);
                        break;
                    }
                    case 2: {
                        res.addQdCurve((long)cds[2] + x, (long)(-cds[3]) + y, (long)cds[0] + x, (long)(-cds[1]) + y, true);
                        break;
                    }
                    case 1: {
                        res.addSegment((long)cds[0] + x, (long)(-cds[1]) + y, true);
                        break;
                    }
                    case 0: {
                        res.jump((long)cds[0] + x, (long)(-cds[1]) + y, true);
                    }
                }
                pi.next();
            }
            return res;
        }
        return null;
    }

    public VPath() {
        this.vx = 0L;
        this.vy = 0L;
        this.vz = 0;
        this.setColor(Color.black);
        this.sensit = false;
        this.resetPath();
    }

    public VPath(long x, long y, int z, Color c) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.sensit = false;
        this.setColor(c);
        this.path = new GeneralPath();
        this.lp = new LongPoint(this.vx, this.vy);
        this.realHotSpot = new LongPoint(this.vx, this.vy);
        this.path.moveTo(this.vx, -this.vy);
        this.computeSize();
    }

    public VPath(PathIterator pi, int z, Color c) {
        this.vz = z;
        double[] cds = new double[6];
        if (pi.currentSegment(cds) == 0) {
            this.vx = (long)cds[0];
            this.vy = (long)cds[1];
            pi.next();
        } else {
            this.vx = 0L;
            this.vy = 0L;
        }
        this.path = new GeneralPath();
        this.lp = new LongPoint(this.vx, this.vy);
        this.realHotSpot = new LongPoint(this.vx, this.vy);
        this.path.moveTo(this.vx, -this.vy);
        while (!pi.isDone()) {
            int type = pi.currentSegment(cds);
            switch (type) {
                case 3: {
                    this.addCbCurve((long)cds[4], (long)cds[5], (long)cds[0], (long)cds[1], (long)cds[2], (long)cds[3], true);
                    break;
                }
                case 2: {
                    this.addQdCurve((long)cds[2], (long)cds[3], (long)cds[0], (long)cds[1], true);
                    break;
                }
                case 1: {
                    this.addSegment((long)cds[0], (long)cds[1], true);
                    break;
                }
                case 0: {
                    this.jump((long)cds[0], (long)cds[1], true);
                }
            }
            pi.next();
        }
        this.sensit = false;
        this.setColor(c);
    }

    public void resetPath() {
        this.path = new GeneralPath();
        this.lp = new LongPoint(0L, 0L);
        this.realHotSpot = new LongPoint(0L, 0L);
        this.path.moveTo(0.0f, 0.0f);
        this.computeSize();
    }

    public void addSegment(long x, long y, boolean abs) {
        if (abs) {
            this.lp.setLocation(x, y);
        } else {
            this.lp.translate(x, y);
        }
        this.path.lineTo(this.lp.x, -this.lp.y);
        this.realHotSpot.setLocation((this.vx + this.lp.x) / 2L, (this.vy + this.lp.y) / 2L);
        this.computeSize();
    }

    public void addQdCurve(long x, long y, long x1, long y1, boolean abs) {
        if (abs) {
            this.path.quadTo(x1, -y1, x, -y);
            this.lp.setLocation(x, y);
        } else {
            this.path.quadTo(this.lp.x + x1, -(this.lp.y + y1), this.lp.x + x, -(this.lp.y + y));
            this.lp.translate(x, y);
        }
        this.realHotSpot.setLocation((this.vx + this.lp.x) / 2L, (this.vy + this.lp.y) / 2L);
        this.computeSize();
    }

    public void addCbCurve(long x, long y, long x1, long y1, long x2, long y2, boolean abs) {
        if (abs) {
            this.path.curveTo(x1, -y1, x2, -y2, x, -y);
            this.lp.setLocation(x, y);
        } else {
            this.path.curveTo(this.lp.x + x1, -(this.lp.y + y1), this.lp.x + x2, -(this.lp.y + y2), this.lp.x + x, -(this.lp.y + y));
            this.lp.translate(x, y);
        }
        this.realHotSpot.setLocation((this.vx + this.lp.x) / 2L, (this.vy + this.lp.y) / 2L);
        this.computeSize();
    }

    public void jump(long x, long y, boolean abs) {
        if (abs) {
            this.lp.setLocation(x, y);
        } else {
            this.lp.translate(x, y);
        }
        this.path.moveTo(this.lp.x, -this.lp.y);
        if (this.getPathLength() == 1) {
            this.vx = this.lp.x;
            this.vy = this.lp.y;
        }
        this.realHotSpot.setLocation((this.vx + this.lp.x) / 2L, (this.vy + this.lp.y) / 2L);
        this.computeSize();
    }

    int getPathLength() {
        int res = 0;
        PathIterator pi = this.path.getPathIterator(null);
        while (!pi.isDone()) {
            ++res;
            pi.next();
        }
        return res;
    }

    void computeSize() {
        this.size = (float)Math.sqrt(Math.pow((this.lp.x - this.vx) / 2L, 2.0) + Math.pow((this.lp.y - this.vy) / 2L, 2.0));
        this.drawingRadius = this.size * this.drawingFactor;
    }

    public void initCams(int nbCam) {
        this.pc = new ProjectedCoords[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjectedCoords();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjectedCoords[] ta = this.pc;
                this.pc = new ProjectedCoords[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjectedCoords();
            } else {
                System.err.println("VPath:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjectedCoords[1];
            this.pc[0] = new ProjectedCoords();
        } else {
            System.err.println("VPath:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
    }

    public void sizeTo(float factor) {
    }

    public void reSize(float factor) {
    }

    public void orientTo(float angle) {
    }

    public float getSize() {
        return this.size;
    }

    public float getOrient() {
        return this.orient;
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return false;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return false;
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(-c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(-c.posy) * this.coef);
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(-lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(-lensy) * this.coef);
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx, dy + this.pc[i].cy);
        this.at.preConcatenate(stdT);
        this.at.concatenate(AffineTransform.getScaleInstance(this.coef, this.coef));
        g.setTransform(this.at);
        if (this.stroke != null) {
            g.setStroke(this.stroke);
            g.draw(this.path);
            g.setStroke(stdS);
        } else {
            g.draw(this.path);
        }
        g.setTransform(stdT);
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx, dy + this.pc[i].lcy);
        this.at.concatenate(AffineTransform.getScaleInstance(this.coef, this.coef));
        g.setTransform(this.at);
        if (this.stroke != null) {
            g.setStroke(this.stroke);
            g.draw(this.path);
            g.setStroke(stdS);
        } else {
            g.draw(this.path);
        }
        g.setTransform(stdT);
    }

    public boolean visibleInRegion(long wb, long nb, long eb, long sb, int i) {
        if (this.forcedDrawing) {
            return true;
        }
        if (this.realHotSpot.x >= wb && this.realHotSpot.x <= eb && this.realHotSpot.y >= sb && this.realHotSpot.y <= nb) {
            return true;
        }
        return (float)this.realHotSpot.x - this.drawingRadius <= (float)eb && (float)this.realHotSpot.x + this.drawingRadius >= (float)wb && (float)this.realHotSpot.y - this.drawingRadius <= (float)nb && (float)this.realHotSpot.y + this.drawingRadius >= (float)sb;
    }

    public boolean containedInRegion(long wb, long nb, long eb, long sb, int i) {
        if (this.forcedDrawing) {
            return true;
        }
        return this.realHotSpot.x >= wb && this.realHotSpot.x <= eb && this.realHotSpot.y >= sb && this.realHotSpot.y <= nb && (float)this.realHotSpot.x + this.drawingRadius <= (float)eb && (float)this.realHotSpot.x - this.drawingRadius >= (float)wb && (float)this.realHotSpot.y + this.drawingRadius <= (float)nb && (float)this.realHotSpot.y - this.drawingRadius >= (float)sb;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.path.intersects(dvx - dvr, -dvy - dvr, 2L * dvr, 2L * dvr) && !this.path.contains(dvx - dvr, -dvy - dvr, 2L * dvr, 2L * dvr);
    }

    public void setDrawingFactor(float f) {
        this.drawingFactor = f;
    }

    public float getDrawingFactor() {
        return this.drawingFactor;
    }

    public void setForcedDrawing(boolean b) {
        this.forcedDrawing = b;
    }

    public boolean getForcedDrawing() {
        return this.forcedDrawing;
    }

    public PathIterator getJava2DPathIterator() {
        return this.path.getPathIterator(null);
    }

    public GeneralPath getJava2DGeneralPath() {
        return this.path;
    }

    public Object clone() {
        VPath res = new VPath();
        res.mouseInsideColor = this.mouseInsideColor;
        return res;
    }

    public void highlight(boolean b, Color selectedColor) {
    }
}

