# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2018-07-02 04:44
from __future__ import unicode_literals

from django.db import migrations, models


# flake8: noqa

class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('postorius', '0003_drop_addressconfirmationprofile'),
    ]

    operations = [
        migrations.CreateModel(
            name='EmailTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(choices=[('list:admin:action:post', 'Sent to the list administrators when moderator approval for a posting is required.'), ('list:admin:action:subscribe', 'Sent to the list administrators when moderator approval for a subscription request is required.'), ('list:admin:action:unsubscribe', 'Sent to the list administrators when moderator approval for an unsubscription request is required.'), ('list:admin:notice:subscribe', 'Sent to the list administrators to notify them when a new member has been subscribed.'), ('list:admin:notice:unrecognized', 'Sent to the list administrators when a bounce message in an unrecognized format has been received.'), ('list:admin:notice:unsubscribe', 'Sent to the list administrators to notify them when a member has been unsubscribed.'), ('list:member:digest:footer', 'The footer for a digest message.'), ('list:member:digest:header', 'The header for a digest message.'), ('list:member:digest:masthead', 'The digest “masthead”; i.e. a common introduction for all digest messages.'), ('list:member:regular:footer', 'The footer for a regular (non-digest) message.'), ('list:member:regular:header', 'The header for a regular (non-digest) message.'), ('list:user:action:subscribe', 'The message sent to subscribers when a subscription confirmation is required.'), ('list:user:action:unsubscribe', 'The message sent to subscribers when an unsubscription confirmation is required.'), ('list:user:notice:goodbye', 'The notice sent to a member when they unsubscribe from a mailing list.'), ('list:user:notice:hold', 'The notice sent to a poster when their message is being held or moderator approval.'), ('list:user:notice:no-more-today', 'Sent to a user when the maximum number of autoresponses has been reached for that day.'), ('list:user:notice:post', 'Notice sent to a poster when their message has been received by the mailing list.'), ('list:user:notice:probe', 'A bounce probe sent to a member when their subscription has been disabled due to bounces.'), ('list:user:notice:refuse', 'Notice sent to a poster when their message has been rejected by the list’s moderator.'), ('list:user:notice:welcome', 'The notice sent to a member when they are subscribed to the mailing list.')], help_text='Choose the template you want to customize.', max_length=100)),
                ('data', models.TextField(help_text="You can use these variables in the templates. \n$hyperkitty_url: Permalink to archived message in Hyperkitty\n$listname: Name of the Mailing List e.g. ant@example.com \n$list_id: The List-ID header e.g. ant.example.com \n$display_name: Display name of the mailing list e.g. Ant \n$short_listname: Local part of the listname e.g. ant \n$domain: The domain part of the listname e.g. example.com \n$info: The mailing list's longer descriptive text \n$request_email: The email address for -request address \n$owner_email: The email address for -owner address \n$site_email: The email address to reach the owners of the site \n$language: The two letter language code for list's preferred language e.g. fr, en, de \n")),
                ('language', models.CharField(blank=True, choices=[('af', 'Afrikaans'), ('ar', 'Arabic'), ('ast', 'Asturian'), ('az', 'Azerbaijani'), ('bg', 'Bulgarian'), ('be', 'Belarusian'), ('bn', 'Bengali'), ('br', 'Breton'), ('bs', 'Bosnian'), ('ca', 'Catalan'), ('cs', 'Czech'), ('cy', 'Welsh'), ('da', 'Danish'), ('de', 'German'), ('dsb', 'Lower Sorbian'), ('el', 'Greek'), ('en', 'English'), ('en-au', 'Australian English'), ('en-gb', 'British English'), ('eo', 'Esperanto'), ('es', 'Spanish'), ('es-ar', 'Argentinian Spanish'), ('es-co', 'Colombian Spanish'), ('es-mx', 'Mexican Spanish'), ('es-ni', 'Nicaraguan Spanish'), ('es-ve', 'Venezuelan Spanish'), ('et', 'Estonian'), ('eu', 'Basque'), ('fa', 'Persian'), ('fi', 'Finnish'), ('fr', 'French'), ('fy', 'Frisian'), ('ga', 'Irish'), ('gd', 'Scottish Gaelic'), ('gl', 'Galician'), ('he', 'Hebrew'), ('hi', 'Hindi'), ('hr', 'Croatian'), ('hsb', 'Upper Sorbian'), ('hu', 'Hungarian'), ('ia', 'Interlingua'), ('id', 'Indonesian'), ('io', 'Ido'), ('is', 'Icelandic'), ('it', 'Italian'), ('ja', 'Japanese'), ('ka', 'Georgian'), ('kk', 'Kazakh'), ('km', 'Khmer'), ('kn', 'Kannada'), ('ko', 'Korean'), ('lb', 'Luxembourgish'), ('lt', 'Lithuanian'), ('lv', 'Latvian'), ('mk', 'Macedonian'), ('ml', 'Malayalam'), ('mn', 'Mongolian'), ('mr', 'Marathi'), ('my', 'Burmese'), ('nb', 'Norwegian Bokmål'), ('ne', 'Nepali'), ('nl', 'Dutch'), ('nn', 'Norwegian Nynorsk'), ('os', 'Ossetic'), ('pa', 'Punjabi'), ('pl', 'Polish'), ('pt', 'Portuguese'), ('pt-br', 'Brazilian Portuguese'), ('ro', 'Romanian'), ('ru', 'Russian'), ('sk', 'Slovak'), ('sl', 'Slovenian'), ('sq', 'Albanian'), ('sr', 'Serbian'), ('sr-latn', 'Serbian Latin'), ('sv', 'Swedish'), ('sw', 'Swahili'), ('ta', 'Tamil'), ('te', 'Telugu'), ('th', 'Thai'), ('tr', 'Turkish'), ('tt', 'Tatar'), ('udm', 'Udmurt'), ('uk', 'Ukrainian'), ('ur', 'Urdu'), ('vi', 'Vietnamese'), ('zh-hans', 'Simplified Chinese'), ('zh-hant', 'Traditional Chinese')], help_text="Language for the template, this should be the list's preferred language.", max_length=5)),
                ('craeted_at', models.DateTimeField(auto_now_add=True)),
                ('modified_at', models.DateTimeField(auto_now=True)),
                ('context', models.CharField(choices=[('site', 'Site Wide'), ('domain', 'Domain Wide'), ('list', 'MailingList Wide')], max_length=50)),
                ('identifier', models.CharField(blank=True, max_length=100)),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='emailtemplate',
            unique_together=set([('name', 'identifier', 'language')]),
        ),
    ]
