/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.Random;
import primitive.collection.DoubleFunction;
import primitive.collection.DoubleList;
import primitive.collection.IntStatList;

public class DoubleStatList
extends DoubleList {
    public void each(DoubleFunction doubleFunction) {
        for (int i = 0; i != this.size(); ++i) {
            doubleFunction.apply(this.get(i));
        }
    }

    public double reduce(double d, DoubleFunction doubleFunction) {
        double d2 = d;
        for (int i = 0; i != this.size(); ++i) {
            d2 = doubleFunction.accumulate(d2, this.get(i));
        }
        return d2;
    }

    public double sum() {
        DoubleFunction doubleFunction = new DoubleFunction(){

            @Override
            public double accumulate(double d, double d2) {
                return d + d2;
            }
        };
        return this.reduce(0.0, doubleFunction);
    }

    public DoubleStats stats() {
        final DoubleStats doubleStats = new DoubleStats();
        DoubleFunction doubleFunction = new DoubleFunction(){

            @Override
            public void apply(double d) {
                if (d < doubleStats.min) {
                    doubleStats.min = d;
                }
                if (d > doubleStats.max) {
                    doubleStats.max = d;
                }
                doubleStats.sum += d;
            }
        };
        this.each(doubleFunction);
        doubleStats.n = this.size();
        doubleStats.avg = doubleStats.sum / (double)doubleStats.n;
        doubleFunction = new DoubleFunction(){

            @Override
            public void apply(double d) {
                doubleStats.var += Math.pow(doubleStats.avg - d, 2.0);
            }
        };
        this.each(doubleFunction);
        doubleStats.var /= (double)doubleStats.n;
        doubleStats.stdd = Math.pow(doubleStats.var, 0.5);
        return doubleStats;
    }

    static DoubleStatList random(int n) {
        Random random = new Random(0L);
        DoubleStatList doubleStatList = new DoubleStatList();
        for (int i = 0; i != n; ++i) {
            double d = random.nextDouble();
            doubleStatList.add(d);
        }
        return doubleStatList;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        DoubleStatList doubleStatList = DoubleStatList.random(10);
        doubleStatList.each(new DoubleFunction(){

            @Override
            public void apply(double d) {
                DoubleStatList.p(d);
            }
        });
        DoubleStatList.p(doubleStatList.stats());
        DoubleStatList.p(doubleStatList.sum());
        IntStatList intStatList = new IntStatList();
        for (int i = 1; i < 101; ++i) {
            intStatList.add(i);
        }
        DoubleStatList.p(intStatList.stats());
        DoubleStatList.p(intStatList.sum());
    }

    class DoubleStats {
        public int n;
        public double min = Double.MAX_VALUE;
        public double max = Double.MIN_VALUE;
        public double sum;
        public double avg;
        public double stdd;
        public double var;

        DoubleStats() {
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("n    = ");
            stringBuilder.append(this.n);
            stringBuilder.append("\n");
            stringBuilder.append("min  = ");
            stringBuilder.append(this.min);
            stringBuilder.append("\n");
            stringBuilder.append("max  = ");
            stringBuilder.append(this.max);
            stringBuilder.append("\n");
            stringBuilder.append("sum  = ");
            stringBuilder.append(this.sum);
            stringBuilder.append("\n");
            stringBuilder.append("avg  = ");
            stringBuilder.append(this.avg);
            stringBuilder.append("\n");
            stringBuilder.append("stdd = ");
            stringBuilder.append(this.stdd);
            stringBuilder.append("\n");
            stringBuilder.append("var  = ");
            stringBuilder.append(this.var);
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }
    }
}

