package TDS::Customizer::CGI;
# $Id: CGI.pm,v 1.17 2001/01/03 08:20:53 tom Exp $
################################################################

use strict qw(vars);
use vars qw(@ISA @EXPORT
	    $Enable);
use Exporter;

use CGI::QueryString;
#use CGI::Tools;
use Customizer::CGI;

use TDS;
use TDS::System;
use TDS::DirInfo;
use TDS::Admin::Authorize;
use TDS::Admin::FTP;
use TDS::Admin::Skelton;
use TDS::Admin::WriteServer::Selector;

@ISA = qw(Customizer::CGI TDS::Admin::WriteServer::Selector);
@EXPORT = qw(attributes);

attributes qw();

$Enable = 0 unless defined $Enable;

################################################################
sub initialize($)
{
    my $self = shift;

    $self->input_skelton(new TDS::Admin::Skelton);

    $self->Customizer::CGI::initialize;
    $self->TDS::Admin::WriteServer::initialize;
}
sub WriteToFile($$)
{
    my ($self, $code) = @_;

    $self->SUPER::Write($code);
}
sub Input($)
{
    my $self = shift;
    my $auth = new TDS::Admin::Authorize;
    
    $auth->CheckAuthorized();
    $self->SUPER::Input;
}
sub Do($)
{
    my $self = shift;

    if ($TDS::Status->is_cgi){
	unless ($Enable){
	    my $cusdir = GetCustomizeDir();
	    die "customizing is NOT permitted in CGI. \$TDS::Customizer::CGI::Enable = 1; in $cusdir/customize.ph.";
	}
    }
    $self->SUPER::Do;
}
sub PrintHTTPHeader
{
  TDS::Admin::Authorize->PrintHTTPHeader();
}
################################################################
sub GetBaseType($)
{
    return 'customize_dir';
}
sub GetOutputFilename($)
{
    return 'customize.ph';
}
1;

