/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import com.gokgs.client.KClient;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import org.igoweb.go.Go;
import org.igoweb.go.Rules;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.Errout;
import org.igoweb.util.swing.GCLayout;
import org.igoweb.util.swing.Spinner;
import org.igoweb.util.swing.TBlock;

public class KAutomatchWindow
extends DFrame
implements ActionListener {
    private static final int HUMAN_OK = 256;
    private static final int ROBOT_OK = 128;
    private static final int UNRANKED_OK = 2048;
    private static final int MEDIUM_OK = 1024;
    private static final int FAST_OK = 4096;
    private static final int BLITZ_OK = 512;
    private static final int FREE_OK = 32;
    private static final int RANKED_OK = 64;
    private static final int HC_MASK = 31;
    private JButton cancelBut;
    private KClient client;
    private final JCheckBox humanOk = new JCheckBox(Defs.getString(-809883767));
    private final JCheckBox robotOk = new JCheckBox(Defs.getString(-809883766));
    private final JCheckBox unrankedOk = new JCheckBox(Defs.getString(-809883751));
    private final Spinner maxRankDiff;
    private final JCheckBox rankedOk = new JCheckBox(Defs.getString(-809883765));
    private final JCheckBox freeOk = new JCheckBox(Defs.getString(-809883764));
    private final JCheckBox mediumOk = new JCheckBox(Defs.getString(-809883762));
    private final JCheckBox fastOk = new JCheckBox(Defs.getString(-809883750));
    private final JCheckBox blitzOk = new JCheckBox(Defs.getString(-809883763));
    private JComboBox estRankSelector;
    private boolean startWhenDone;

    public KAutomatchWindow(Client client, JComponent parent, boolean startWhenDone) {
        super(Defs.getString(-903340678), parent);
        this.client = (KClient)client;
        this.startWhenDone = startWhenDone;
        int prefs = client.getAutomatchPrefs();
        this.getRootPane().setDefaultButton(this.addButton(Defs.getString(1436228518), this));
        this.cancelBut = this.addButton(Defs.getString(1436228510), this);
        JComponent mainPanel = this.getMainPanel();
        JLabel label = new JLabel(Defs.getString(-809883769), 0);
        label.setFont(label.getFont().deriveFont(1));
        mainPanel.add(label);
        User me = client.getMe();
        if (me.getRank() == 0 && me.isRankWanted()) {
            TBlock tb = new TBlock(Defs.getString(me.isGuest() ? -809883756 : -809883755), 40);
            mainPanel.add("x=0,xGrow=t", tb);
            tb.setMinimumSize(new Dimension(10, 10));
        }
        JPanel panel = new JPanel(new GCLayout());
        mainPanel.add("x=0,xGrow=t", panel);
        LineBorder lineBorder = new LineBorder(Color.gray);
        panel.setBorder(new TitledBorder(lineBorder, Defs.getString(-809883768), 0, 0, null, Color.gray));
        panel.add("x=0,xSpan=2,xGrow=f", this.humanOk);
        panel.add("x=0,xSpan=2,xGrow=f", this.robotOk);
        panel.add("x=0,xSpan=2,xGrow=f", this.unrankedOk);
        this.maxRankDiff = new Spinner(new Spinner.DefaultModel(Defs.getString(-809883758), 0, 9), Integer.toString(Math.max(Math.min(prefs & 0x1F, 9), 0)), 2, this);
        this.maxRankDiff.test(false);
        panel.add("x=0,xSpan=1", this.maxRankDiff);
        panel.add("xGrow=t", new JLabel(Defs.getString(-809883761)));
        if (me.getRank() == 0) {
            String[] items = new String[30];
            for (int i = 0; i < 30; ++i) {
                items[i] = Go.formatRank(i + 1);
            }
            this.estRankSelector = new JComboBox<String>(items);
            this.estRankSelector.setSelectedIndex(Math.max(Math.min(prefs >> 26 & 0x3F, 30), 1) - 1);
            panel.add("x=0,xGrow=f", this.estRankSelector);
            panel.add(new JLabel(Defs.getString(-809883757)));
        }
        panel = new JPanel(new GridLayout(2, 1));
        panel.setBorder(new TitledBorder(lineBorder, Defs.getString(-809883760), 0, 0, null, Color.gray));
        mainPanel.add("x=0", panel);
        panel.add("x=0", this.rankedOk);
        panel.add("x=0", this.freeOk);
        panel = new JPanel(new GridLayout(3, 1));
        panel.setBorder(new TitledBorder(lineBorder, Defs.getString(-809883759), 0, 0, null, Color.gray));
        mainPanel.add("x=0", panel);
        Rules rules = new Rules();
        panel.add("x=0", this.mediumOk);
        rules.setMainTime(1500);
        rules.setByoYomiTime(30);
        rules.setByoYomiPeriods(5);
        this.mediumOk.setToolTipText(rules.getTimeDescription());
        panel.add("x=0", this.fastOk);
        rules.setMainTime(600);
        rules.setByoYomiTime(20);
        rules.setByoYomiPeriods(5);
        this.fastOk.setToolTipText(rules.getTimeDescription());
        panel.add("x=0", this.blitzOk);
        rules.setTimeSystem(2);
        rules.setMainTime(60);
        rules.setByoYomiTime(10);
        rules.setByoYomiPeriods(3);
        this.blitzOk.setToolTipText(rules.getTimeDescription());
        this.humanOk.setSelected((prefs & 0x100) != 0);
        this.robotOk.setSelected((prefs & 0x80) != 0);
        this.unrankedOk.setSelected((prefs & 0x800) != 0);
        this.mediumOk.setSelected((prefs & 0x400) != 0);
        this.fastOk.setSelected((prefs & 0x1000) != 0);
        this.blitzOk.setSelected((prefs & 0x200) != 0);
        this.freeOk.setSelected((prefs & 0x20) != 0);
        this.rankedOk.setSelected((prefs & 0x40) != 0);
        if (me.getRank() == 0) {
            this.unrankedOk.setSelected(true);
            this.unrankedOk.setEnabled(false);
        }
        if (!me.isRankWanted() || me.isGuest() || me.getRank() > 39) {
            this.rankedOk.setSelected(false);
            this.rankedOk.setEnabled(false);
            this.freeOk.setSelected(true);
            this.freeOk.setEnabled(false);
        }
        mainPanel.add("x=0,yGrow=t", new JLabel());
        this.pack();
        this.setVisible(true);
        GuiClientUtil.get((Client)client).windowList.add(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelBut) {
            this.dispose();
            return;
        }
        if (e.getSource() == this.maxRankDiff) {
            new Errout(e.getActionCommand());
            return;
        }
        if (!this.maxRankDiff.test(true)) {
            return;
        }
        int prefs = 0;
        if (this.humanOk.isSelected()) {
            prefs |= 0x100;
        }
        if (this.robotOk.isSelected()) {
            prefs |= 0x80;
        }
        if ((prefs & 0x180) == 0) {
            new Errout(Defs.getString(-809883753));
            return;
        }
        if (this.unrankedOk.isSelected()) {
            prefs |= 0x800;
        }
        if (this.mediumOk.isSelected()) {
            prefs |= 0x400;
        }
        if (this.fastOk.isSelected()) {
            prefs |= 0x1000;
        }
        if (this.blitzOk.isSelected()) {
            prefs |= 0x200;
        }
        if ((prefs & 0x1600) == 0) {
            new Errout(Defs.getString(-809883754));
            return;
        }
        if (this.freeOk.isSelected()) {
            prefs |= 0x20;
        }
        if (this.rankedOk.isSelected()) {
            prefs |= 0x40;
        }
        if ((prefs & 0x60) == 0) {
            new Errout(Defs.getString(-809883752));
            return;
        }
        if (!this.maxRankDiff.test(true)) {
            return;
        }
        try {
            prefs |= (short)((Spinner.DefaultModel)this.maxRankDiff.getModel()).getVal(this.maxRankDiff);
        }
        catch (Spinner.BadInputException excep) {
            throw new RuntimeException(excep);
        }
        if (this.estRankSelector != null) {
            prefs = prefs & 0x3FFFFFF | this.estRankSelector.getSelectedIndex() + 1 << 26;
        }
        if (!this.rankedOk.isEnabled()) {
            prefs = prefs & 0xFFFFFF9F | this.client.getAutomatchPrefs() & 0x60;
        }
        if (this.startWhenDone) {
            this.client.sendAutomatchCreate(prefs);
        } else {
            this.client.sendSetAutomatchPrefs(prefs);
        }
        this.dispose();
    }

    @Override
    protected String getSavePositionPref() {
        return "Z1lMqztz";
    }
}

