/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;

public class ImageViewer
extends JComponent
implements EventListener {
    private Image originalImage;
    private Image paintableImage = null;
    int width;
    int height;

    public ImageViewer(Image image) {
        this(image, -1, -1);
    }

    public ImageViewer(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public ImageViewer(Image image, int w, int h) {
        if (image != null) {
            this.setImage(image);
        }
        this.width = w;
        this.height = h;
    }

    public ImageViewer(URL imgUrl, int width, int height) {
        this.width = width;
        this.height = height;
        this.originalImage = this.paintableImage = Toolkit.getDefaultToolkit().getImage(imgUrl);
    }

    public void setImage(Image image, int newWidth, int newHeight) {
        this.width = newWidth;
        this.height = newHeight;
        this.setImage(image);
    }

    public void setImage(Image image) {
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(image, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.originalImage = image;
        this.paintableImage = image;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.originalImage == null) {
            return;
        }
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        size.width -= insets.left + insets.right;
        size.height -= insets.top + insets.bottom;
        if (this.width == -1 && (this.paintableImage == null || size.width != this.paintableImage.getWidth(null) || size.height != this.paintableImage.getHeight(null))) {
            if (this.paintableImage != null && this.paintableImage != this.originalImage) {
                this.paintableImage.flush();
            }
            if (size.width == this.originalImage.getWidth(null) && size.height == this.originalImage.getHeight(null)) {
                this.paintableImage = this.originalImage;
            } else {
                this.paintableImage = this.createImage(size.width, size.height);
                Graphics2D g2d = (Graphics2D)this.paintableImage.getGraphics();
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                g2d.drawImage(this.originalImage, 0, 0, size.width, size.height, this);
            }
        }
        if (this.paintableImage != null) {
            g.drawImage(this.paintableImage, insets.left + (size.width - this.paintableImage.getWidth(this)) / 2, insets.top + (size.height - this.paintableImage.getHeight(this)) / 2, this);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        if (this.width == -1) {
            return new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        }
        return new Dimension(insets.left + this.width + insets.right, insets.top + this.height + insets.bottom);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public boolean imageUpdate(Image img, int infoFlags, int x, int y, int newWidth, int newHeight) {
        if (img == this.paintableImage) {
            if ((infoFlags & 0xC0) != 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ImageViewer.this.paintableImage = null;
                    }
                });
                return false;
            }
            this.repaint();
            return (infoFlags & 0x20) == 0;
        }
        return false;
    }

    @Override
    public void handleEvent(Event event) {
        this.setImage((Image)event.arg);
    }

    public Image getImage() {
        return this.originalImage;
    }
}

