/*
 * Decompiled with CFR 0.152.
 */
package tokyocabinet;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Random;
import tokyocabinet.ADB;
import tokyocabinet.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class ADBTest {
    private static final PrintStream STDOUT = System.out;
    private static final PrintStream STDERR = System.err;
    private static final Random RND = new Random();
    static /* synthetic */ Class class$tokyocabinet$ADBTest;

    public static void main(String[] stringArray) {
        int n = 0;
        if (stringArray.length < 1) {
            ADBTest.usage();
        }
        if (stringArray[0].equals("write")) {
            n = ADBTest.runwrite(stringArray);
        } else if (stringArray[0].equals("read")) {
            n = ADBTest.runread(stringArray);
        } else if (stringArray[0].equals("remove")) {
            n = ADBTest.runremove(stringArray);
        } else if (stringArray[0].equals("misc")) {
            n = ADBTest.runmisc(stringArray);
        } else {
            ADBTest.usage();
        }
        System.gc();
        System.exit(n);
    }

    private static final void usage() {
        STDERR.println("test cases of the abstract database API");
        STDERR.println("");
        STDERR.println("synopsis:");
        StringBuffer stringBuffer = new StringBuffer("  java ");
        Class clazz = class$tokyocabinet$ADBTest;
        if (clazz == null) {
            clazz = class$tokyocabinet$ADBTest = ADBTest.class("[Ltokyocabinet.ADBTest;", false);
        }
        STDERR.println(stringBuffer.append(clazz.getName()).append(" arguments...").toString());
        STDERR.println("");
        STDERR.println("arguments:");
        STDERR.println("  tcatest.rb write name rnum");
        STDERR.println("  tcatest.rb read name");
        STDERR.println("  tcatest.rb remove name");
        STDERR.println("  tcatest.rb misc name rnum");
        STDERR.println("");
        System.exit(1);
    }

    private static final void eprint(ADB aDB, String string) {
        String string2 = aDB.path();
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$tokyocabinet$ADBTest;
        if (clazz == null) {
            clazz = class$tokyocabinet$ADBTest = ADBTest.class("[Ltokyocabinet.ADBTest;", false);
        }
        STDERR.println(stringBuffer.append(clazz.getName()).append(": ").append(string2).append(": ").append(string).append(": error").toString());
    }

    private static final int runwrite(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 1;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (string == null && string3.startsWith("-")) {
                ADBTest.usage();
            } else if (string == null) {
                string = string3;
            } else if (string2 == null) {
                string2 = string3;
            } else {
                ADBTest.usage();
            }
            ++n;
        }
        if (string == null || string2 == null) {
            ADBTest.usage();
        }
        if ((n = Util.atoi(string2)) < 1) {
            ADBTest.usage();
        }
        int n2 = ADBTest.procwrite(string, n);
        return n2;
    }

    private static final int runread(String[] stringArray) {
        String string = null;
        int n = 1;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                ADBTest.usage();
            } else if (string == null) {
                string = string2;
            } else {
                ADBTest.usage();
            }
            ++n;
        }
        if (string == null) {
            ADBTest.usage();
        }
        n = ADBTest.procread(string);
        return n;
    }

    private static final int runremove(String[] stringArray) {
        String string = null;
        int n = 1;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (string == null && string2.startsWith("-")) {
                ADBTest.usage();
            } else if (string == null) {
                string = string2;
            } else {
                ADBTest.usage();
            }
            ++n;
        }
        if (string == null) {
            ADBTest.usage();
        }
        n = ADBTest.procremove(string);
        return n;
    }

    private static final int runmisc(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 1;
        while (n < stringArray.length) {
            String string3 = stringArray[n];
            if (string == null && string3.startsWith("-")) {
                ADBTest.usage();
            } else if (string == null) {
                string = string3;
            } else if (string2 == null) {
                string2 = string3;
            } else {
                ADBTest.usage();
            }
            ++n;
        }
        if (string == null || string2 == null) {
            ADBTest.usage();
        }
        if ((n = Util.atoi(string2)) < 1) {
            ADBTest.usage();
        }
        int n2 = ADBTest.procmisc(string, n);
        return n2;
    }

    private static final int procwrite(String string, int n) {
        STDOUT.println("<Writing Test>");
        STDOUT.println("  name=" + string + "  rnum=" + n);
        STDOUT.println("");
        int n2 = 0;
        double d = Util.time();
        ADB aDB = new ADB();
        if (!aDB.open(string)) {
            ADBTest.eprint(aDB, "open");
            n2 = 1;
        }
        int n3 = 1;
        while (n3 <= n) {
            String string2 = Util.itoa(n3, 8, '0');
            if (!aDB.put(string2, string2)) {
                ADBTest.eprint(aDB, "put");
                n2 = 1;
                break;
            }
            if (n > 250 && n3 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n3 == n || n3 % (n / 10) == 0) {
                    STDOUT.println(" (" + string2 + ')');
                }
            }
            ++n3;
        }
        STDOUT.println("record number: " + aDB.rnum());
        STDOUT.println("size: " + aDB.size());
        if (!aDB.close()) {
            ADBTest.eprint(aDB, "close");
            n2 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n2 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n2;
    }

    private static final int procread(String string) {
        STDOUT.println("<Reading Test>");
        STDOUT.println("  name=" + string);
        STDOUT.println("");
        int n = 0;
        double d = Util.time();
        ADB aDB = new ADB();
        if (!aDB.open(string)) {
            ADBTest.eprint(aDB, "open");
            n = 1;
        }
        int n2 = (int)aDB.rnum();
        int n3 = 1;
        while (n3 <= n2) {
            String string2 = Util.itoa(n3, 8, '0');
            if (aDB.get(string2) == null) {
                ADBTest.eprint(aDB, "get");
                n = 1;
                break;
            }
            if (n2 > 250 && n3 % (n2 / 250) == 0) {
                STDOUT.print('.');
                if (n3 == n2 || n3 % (n2 / 10) == 0) {
                    STDOUT.println(" (" + string2 + ')');
                }
            }
            ++n3;
        }
        STDOUT.println("record number: " + aDB.rnum());
        STDOUT.println("size: " + aDB.size());
        if (!aDB.close()) {
            ADBTest.eprint(aDB, "close");
            n = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n != 0 ? "error" : "ok");
        STDOUT.println("");
        return n;
    }

    private static final int procremove(String string) {
        STDOUT.println("<Removing Test>");
        STDOUT.println("  name=" + string);
        STDOUT.println("");
        int n = 0;
        double d = Util.time();
        ADB aDB = new ADB();
        if (!aDB.open(string)) {
            ADBTest.eprint(aDB, "open");
            n = 1;
        }
        int n2 = (int)aDB.rnum();
        int n3 = 1;
        while (n3 <= n2) {
            String string2 = Util.itoa(n3, 8, '0');
            if (!aDB.out(string2)) {
                ADBTest.eprint(aDB, "out");
                n = 1;
                break;
            }
            if (n2 > 250 && n3 % (n2 / 250) == 0) {
                STDOUT.print('.');
                if (n3 == n2 || n3 % (n2 / 10) == 0) {
                    STDOUT.println(" (" + string2 + ')');
                }
            }
            ++n3;
        }
        STDOUT.println("record number: " + aDB.rnum());
        STDOUT.println("size: " + aDB.size());
        if (!aDB.close()) {
            ADBTest.eprint(aDB, "close");
            n = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n != 0 ? "error" : "ok");
        STDOUT.println("");
        return n;
    }

    private static final int procmisc(String string, int n) {
        String string2;
        String string3;
        Object object;
        String string4;
        STDOUT.println("<Miscellaneous Test>");
        STDOUT.println("  name=" + string + "  rnum=" + n);
        STDOUT.println("");
        int n2 = 0;
        double d = Util.time();
        ADB aDB = new ADB();
        if (!aDB.open(string)) {
            ADBTest.eprint(aDB, "open");
            n2 = 1;
        }
        STDOUT.println("writing:");
        int n3 = 1;
        while (n3 <= n) {
            string4 = Util.itoa(n3, 8, '0');
            if (!aDB.put(string4, string4)) {
                ADBTest.eprint(aDB, "put");
                n2 = 1;
                break;
            }
            if (n > 250 && n3 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n3 == n || n3 % (n / 10) == 0) {
                    STDOUT.println(" (" + string4 + ')');
                }
            }
            ++n3;
        }
        STDOUT.println("reading:");
        n3 = 1;
        while (n3 <= n) {
            string4 = Util.itoa(n3, 8, '0');
            if (aDB.get(string4) == null) {
                ADBTest.eprint(aDB, "get");
                n2 = 1;
                break;
            }
            if (n > 250 && n3 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n3 == n || n3 % (n / 10) == 0) {
                    STDOUT.println(" (" + string4 + ')');
                }
            }
            ++n3;
        }
        STDOUT.println("removing:");
        n3 = 1;
        while (n3 <= n) {
            string4 = Util.itoa(n3, 8, '0');
            if (RND.nextInt(2) == 0 && !aDB.out(string4)) {
                ADBTest.eprint(aDB, "out");
                n2 = 1;
                break;
            }
            if (n > 250 && n3 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n3 == n || n3 % (n / 10) == 0) {
                    STDOUT.println(" (" + string4 + ')');
                }
            }
            ++n3;
        }
        STDOUT.println("checking iterator:");
        if (!aDB.iterinit()) {
            ADBTest.eprint(aDB, "iterinit");
            n2 = 1;
        }
        n3 = 0;
        while ((string4 = aDB.iternext2()) != null) {
            object = aDB.get(string4);
            if (object == null) {
                ADBTest.eprint(aDB, "get");
                n2 = 1;
            }
            if (n3 > 0 && n > 250 && n3 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n3 == n || n3 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n3, 8, '0') + ')');
                }
            }
            ++n3;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n3, 8, '0') + ')');
        }
        if ((long)n3 != aDB.rnum()) {
            ADBTest.eprint(aDB, "(validation)");
            n2 = 1;
        }
        object = aDB.fwmkeys("0", 10);
        if (aDB.rnum() >= 10L && object.size() != 10) {
            ADBTest.eprint(aDB, "fwmkeys");
            n2 = 1;
        }
        STDOUT.println("checking counting:");
        int n4 = 1;
        while (n4 <= n) {
            String string5 = "[" + RND.nextInt(n) + ']';
            if (RND.nextInt(2) == 0) {
                aDB.addint(string5, 1);
            } else {
                aDB.adddouble(string5, 1.0);
            }
            if (n > 250 && n4 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n || n4 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n4, 8, '0') + ')');
                }
            }
            ++n4;
        }
        STDOUT.println("checking versatile functions:");
        n4 = 1;
        while (n4 <= n) {
            int n5 = RND.nextInt(3);
            string3 = n5 == 0 ? "putlist" : (n5 == 1 ? "outlist" : "getlist");
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(new Integer(RND.nextInt(n)));
            arrayList.add(new Integer(RND.nextInt(n)));
            if (aDB.misc(string3, arrayList) == null) {
                ADBTest.eprint(aDB, "(validation)");
                n2 = 1;
                break;
            }
            if (n > 250 && n4 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n4 == n || n4 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n4, 8, '0') + ')');
                }
            }
            ++n4;
        }
        if (!aDB.sync()) {
            ADBTest.eprint(aDB, "sync");
            n2 = 1;
        }
        if (!aDB.optimize()) {
            ADBTest.eprint(aDB, "optimize");
            n2 = 1;
        }
        if (!aDB.copy(string2 = aDB.path() + "-tmp")) {
            ADBTest.eprint(aDB, "copy");
            n2 = 1;
        }
        new File(string2).delete();
        if (!aDB.vanish()) {
            ADBTest.eprint(aDB, "vanish");
            n2 = 1;
        }
        STDOUT.println("checking transaction commit:");
        if (!aDB.tranbegin()) {
            ADBTest.eprint(aDB, "tranbegin");
            n2 = 1;
        }
        int n6 = 1;
        while (n6 <= n) {
            string3 = "" + n6;
            if (RND.nextInt(2) == 0) {
                if (!aDB.putcat(string3, string3)) {
                    ADBTest.eprint(aDB, "putcat");
                    n2 = 1;
                    break;
                }
            } else {
                aDB.out(string3);
            }
            if (n > 250 && n6 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n6 == n || n6 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n6, 8, '0') + ')');
                }
            }
            ++n6;
        }
        if (!aDB.trancommit()) {
            ADBTest.eprint(aDB, "trancommit");
            n2 = 1;
        }
        STDOUT.println("checking transaction abort:");
        long l = aDB.rnum();
        long l2 = aDB.fsiz();
        if (!aDB.tranbegin()) {
            ADBTest.eprint(aDB, "tranbegin");
            n2 = 1;
        }
        int n7 = 1;
        while (n7 <= n) {
            String string6 = "" + n7;
            if (RND.nextInt(2) == 0) {
                if (!aDB.putcat(string6, string6)) {
                    ADBTest.eprint(aDB, "putcat");
                    n2 = 1;
                    break;
                }
            } else {
                aDB.out(string6);
            }
            if (n > 250 && n7 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n7 == n || n7 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n7, 8, '0') + ')');
                }
            }
            ++n7;
        }
        if (!aDB.tranabort()) {
            ADBTest.eprint(aDB, "trancommit");
            n2 = 1;
        }
        if (aDB.rnum() != l || aDB.fsiz() != l2) {
            ADBTest.eprint(aDB, "(validation)");
            n2 = 1;
        }
        STDOUT.println("checking common interface:");
        ADB aDB2 = aDB;
        int n8 = 1;
        while (n8 <= n) {
            String string7 = "[" + Util.itoa(RND.nextInt(n), 8, '0') + ']';
            int n9 = RND.nextInt(3);
            if (n9 == 0) {
                aDB2.put(string7, string7);
            } else if (n9 == 1) {
                aDB2.get(string7);
            } else {
                aDB2.out(string7);
            }
            if (n > 250 && n8 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n8 == n || n8 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n8, 8, '0') + ')');
                }
            }
            ++n8;
        }
        STDOUT.println("checking iterator:");
        n3 = 0;
        if (!aDB2.iterinit()) {
            ADBTest.eprint(aDB, "iterinit");
            n2 = 1;
        }
        while ((string4 = aDB2.iternext2()) != null) {
            String string8 = aDB2.get(string4);
            if (string8 == null) {
                ADBTest.eprint(aDB, "get");
                n2 = 1;
            }
            if (n3 > 0 && n > 250 && n3 % (n / 250) == 0) {
                STDOUT.print('.');
                if (n3 == n || n3 % (n / 10) == 0) {
                    STDOUT.println(" (" + Util.itoa(n3, 8, '0') + ')');
                }
            }
            ++n3;
        }
        if (n > 250) {
            STDOUT.println(" (" + Util.itoa(n3, 8, '0') + ')');
        }
        STDOUT.println("record number: " + aDB.rnum());
        STDOUT.println("size: " + aDB.size());
        if (!aDB.close()) {
            ADBTest.eprint(aDB, "close");
            n2 = 1;
        }
        STDOUT.println("time: " + (Util.time() - d));
        STDOUT.println(n2 != 0 ? "error" : "ok");
        STDOUT.println("");
        return n2;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private ADBTest() throws NoSuchMethodException {
        throw new NoSuchMethodException();
    }
}

