/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.TabSet;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ParagraphView
extends FlowView
implements TabExpander {
    protected int firstLineIndent;
    private int justification;
    private float lineSpacing;
    private TabSet tabSet;

    public float nextTabStop(float f, int n) {
        throw new InternalError("Not implemented yet");
    }

    protected View createRow() {
        return new Row(this.getElement());
    }

    public float getAlignment(int n) {
        float f;
        if (n == 0) {
            f = super.getAlignment(n);
        } else if (this.getViewCount() > 0) {
            float f2 = this.getPreferredSpan(1);
            float f3 = this.getView(0).getPreferredSpan(1);
            f = f3 / 2.0f / f2;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.setPropertiesFromAttributes();
    }

    protected void setPropertiesFromAttributes() {
        Element element = this.getElement();
        AttributeSet attributeSet = element.getAttributes();
        this.setFirstLineIndent(StyleConstants.getFirstLineIndent(attributeSet));
        this.setLineSpacing(StyleConstants.getLineSpacing(attributeSet));
        this.setJustification(StyleConstants.getAlignment(attributeSet));
        this.tabSet = StyleConstants.getTabSet(attributeSet);
    }

    protected void setFirstLineIndent(float f) {
        this.firstLineIndent = (int)f;
    }

    protected void setJustification(int n) {
        this.justification = n;
    }

    protected void setLineSpacing(float f) {
        this.lineSpacing = f;
    }

    protected View getLayoutView(int n) {
        return this.layoutPool.getView(n);
    }

    protected int getLayoutViewCount() {
        return this.layoutPool.getViewCount();
    }

    protected TabSet getTabSet() {
        return this.tabSet;
    }

    protected int findOffsetToCharactersInString(char[] cArray, int n) {
        int n2;
        block5: {
            n2 = -1;
            Document document = this.getDocument();
            Segment segment = new Segment();
            try {
                char c;
                document.getText(n, document.getLength() - n, segment);
                int n3 = n;
                while ((c = segment.next()) != (char)-1) {
                    int n4 = 0;
                    while (n4 < cArray.length) {
                        if (cArray[n4] == c) {
                            n2 = n3;
                            break block5;
                        }
                        ++n4;
                    }
                    ++n3;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return n2;
    }

    protected int getClosestPositionTo(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray, int n3, int n4) throws BadLocationException {
        return n;
    }

    protected float getPartialSize(int n, int n2) {
        float f;
        int n3;
        int n4 = this.getViewIndex(n, Position.Bias.Backward);
        if (n4 == (n3 = this.getViewIndex(n2, Position.Bias.Forward))) {
            View view = this.getView(n4);
            if (view instanceof TabableView) {
                TabableView tabableView = (TabableView)((Object)view);
                f = tabableView.getPartialSpan(n, n2);
            } else {
                f = view.getPreferredSpan(0);
            }
        } else if (n3 - n4 == 1) {
            Object object;
            View view = this.getView(n4);
            if (view instanceof TabableView) {
                object = (TabableView)((Object)view);
                f = object.getPartialSpan(n, view.getEndOffset());
            } else {
                f = view.getPreferredSpan(0);
            }
            object = this.getView(n3);
            if (object instanceof TabableView) {
                TabableView tabableView = (TabableView)object;
                f += tabableView.getPartialSpan(((View)object).getStartOffset(), n2);
            } else {
                f += ((View)object).getPreferredSpan(0);
            }
        } else {
            Object object;
            View view = this.getView(n4);
            if (view instanceof TabableView) {
                TabableView tabableView = (TabableView)((Object)view);
                f = tabableView.getPartialSpan(n, view.getEndOffset());
            } else {
                f = view.getPreferredSpan(0);
            }
            int n5 = n4 + 1;
            while (n5 < n3) {
                object = this.getView(n5);
                f += ((View)object).getPreferredSpan(0);
                ++n5;
            }
            View view2 = this.getView(n3);
            if (view2 instanceof TabableView) {
                object = (TabableView)((Object)view2);
                f += object.getPartialSpan(view2.getStartOffset(), n2);
            } else {
                f += view2.getPreferredSpan(0);
            }
        }
        return f;
    }

    protected float getTabBase() {
        return 0.0f;
    }

    protected void adjustRow(Row row, int n, int n2) {
    }

    public View breakView(int n, float f, Shape shape) {
        return null;
    }

    public int getBreakWeight(int n, float f) {
        return 0;
    }

    public ParagraphView(Element element) {
        super(element, 1);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Row
    extends BoxView {
        public float getAlignment(int n) {
            float f = n == 0 ? 0.0f : super.getAlignment(n);
            return f;
        }

        protected void loadChildren(ViewFactory viewFactory) {
        }

        Row(Element element) {
            super(element, 0);
        }
    }
}

