<?php
/**
 * @entity asp.DownloadLog
 */
abstract class DownloadLogDAO extends ASPSOY2DAO{

	abstract function insert(DownloadLog $bean);
	abstract function update(DownloadLog $bean);

	abstract function get();

	/**
	 * @columns download_file as file, count(id) as download
	 * @group download_file
	 * @query ip_address <> :ipAddress
	 * @return array
	 */
	abstract function getTotalStatistics($ipAddress);

	/**
	 * @columns download_file as file, count(id) as download
	 * @group download_file
	 * @query ip_address <> :ipAddress AND download_date >= :start AND download_date <= :end
	 * @return array
	 */
	abstract function getStatistics($ipAddress,$start,$end);

	/**
	 * @query analyzed = 0 or analyzed is null
	 * @order id asc
	 */
	abstract function getUnanalyzedData();

	/**
	 * @return column_c
	 * @columns count(id) as c
	 * @query analyzed = 1
	 */
	abstract function countAnalyzed();

	/**
	 * @return column_c
	 * @columns count(id) as c
	 * @query analyzed = 0 or analyzed is null
	 */
	abstract function countUnanalyzed();
}
?>