#!/usr/bin/env python
# -*- coding: utf-8 -*-

# CAVEAT UTILITOR
#
# This file was automatically generated by Grako.
#
#    https://pypi.python.org/pypi/grako/
#
# Any changes you make to it will be overwritten the next time
# the file is generated.


from __future__ import print_function, division, absolute_import, unicode_literals

from grako.parsing import graken, Parser
from grako.util import re, RE_FLAGS, generic_main  # noqa


__version__ = (2016, 7, 2, 5, 43, 33, 5)

__all__ = [
    'ExpressionParser',
    'ExpressionSemantics',
    'main'
]

KEYWORDS = set([])


class ExpressionParser(Parser):
    def __init__(self,
                 whitespace=None,
                 nameguard=None,
                 comments_re=None,
                 eol_comments_re=None,
                 ignorecase=None,
                 left_recursion=True,
                 keywords=KEYWORDS,
                 namechars='',
                 **kwargs):
        super(ExpressionParser, self).__init__(
            whitespace=whitespace,
            nameguard=nameguard,
            comments_re=comments_re,
            eol_comments_re=eol_comments_re,
            ignorecase=ignorecase,
            left_recursion=left_recursion,
            keywords=keywords,
            namechars=namechars,
            **kwargs
        )

    @graken()
    def _arithmetic_expression_(self):
        self._test_()
        self._check_eof()

    @graken()
    def _test_(self):
        self._or_test_()

    @graken('binary')
    def _or_test_(self):
        self._and_test_()

        def block0():
            self._token('or')
            self._and_test_()
        self._closure(block0)

    @graken('binary')
    def _and_test_(self):
        self._not_test_()

        def block0():
            self._token('and')
            self._not_test_()
        self._closure(block0)

    @graken('unary')
    def _not_test_(self):
        with self._choice():
            with self._option():
                self._token('not')
                self._not_test_()
            with self._option():
                self._comparison_()
            self._error('no available options')

    @graken('binary')
    def _comparison_(self):
        self._or_expr_()

        def block0():
            self._comparison_operator_()
            self._or_expr_()
        self._closure(block0)

    @graken('binary')
    def _or_expr_(self):
        self._and_expr_()

        def block0():
            self._token('|')
            self._and_expr_()
        self._closure(block0)

    @graken('binary')
    def _and_expr_(self):
        self._shift_expr_()

        def block0():
            self._token('&')
            self._shift_expr_()
        self._closure(block0)

    @graken('binary')
    def _shift_expr_(self):
        self._arith_expr_()

        def block0():
            with self._group():
                with self._choice():
                    with self._option():
                        self._token('<<')
                    with self._option():
                        self._token('>>')
                    self._error('expecting one of: << >>')
            self._arith_expr_()
        self._closure(block0)

    @graken('binary')
    def _arith_expr_(self):
        self._term_()

        def block0():
            with self._group():
                with self._choice():
                    with self._option():
                        self._token('+')
                    with self._option():
                        self._token('-')
                    self._error('expecting one of: + -')
            self._term_()
        self._closure(block0)

    @graken('binary')
    def _term_(self):
        self._factor_()

        def block0():
            with self._group():
                with self._choice():
                    with self._option():
                        self._token('*')
                    with self._option():
                        self._token('/')
                    with self._option():
                        self._token('%')
                    self._error('expecting one of: % * /')
            self._factor_()
        self._closure(block0)

    @graken('unary')
    def _factor_(self):
        with self._choice():
            with self._option():
                with self._group():
                    with self._choice():
                        with self._option():
                            self._token('+')
                        with self._option():
                            self._token('-')
                        with self._option():
                            self._token('~')
                        self._error('expecting one of: + - ~')
                self._factor_()
            with self._option():
                self._power_()
            self._error('no available options')

    @graken()
    def _power_(self):
        self._atom_()
        with self._optional():
            self._token('^')
            self._factor_()

    @graken()
    def _atom_(self):
        with self._choice():
            with self._option():
                self._NUMBER_()
            with self._option():
                self._STRING_()
            with self._option():
                self._function_()
            with self._option():
                self._variable_()
            with self._option():
                with self._group():
                    self._token('(')
                    self._test_()
                    self.name_last_node('@')
                    self._token(')')
            self._error('no available options')

    @graken()
    def _variable_(self):
        self._reference_()

    @graken()
    def _function_(self):
        self._reference_()
        self.name_last_node('ref')
        self._token('(')
        with self._optional():
            self._arglist_()
            self.name_last_node('args')
        self._token(')')

        self.ast._define(
            ['ref', 'args'],
            []
        )

    @graken()
    def _arglist_(self):

        def block0():
            self._argument_()
            self.add_last_node_to_name('@')
            self._token(',')
        self._closure(block0)
        self._argument_()
        self.add_last_node_to_name('@')

    @graken()
    def _argument_(self):
        self._test_()

    @graken()
    def _reference_(self):

        def block0():
            self._NAME_()
            self.add_last_node_to_name('@')
            self._token('.')
        self._closure(block0)
        self._NAME_()
        self.add_last_node_to_name('@')

    @graken()
    def _NUMBER_(self):
        self._pattern(r'[-+]?[0-9]*\.?[0-9]+([eE][-+]?[0-9]+)?')

    @graken()
    def _STRING_(self):
        self._pattern(r"'[^'\\\r\n]*(?:\\.[^'\\\r\n]*)*'")

    @graken()
    def _comparison_operator_(self):
        with self._group():
            with self._choice():
                with self._option():
                    self._token('=')
                with self._option():
                    self._token('!=')
                with self._option():
                    self._token('<')
                with self._option():
                    self._token('<=')
                with self._option():
                    self._token('>')
                with self._option():
                    self._token('>=')
                with self._option():
                    self._token('in')
                with self._option():
                    self._token('is')
                self._error('expecting one of: != < <= = > >= in is')

    @graken()
    def _NAME_(self):
        self._pattern(r'\w+')


class ExpressionSemantics(object):
    def arithmetic_expression(self, ast):
        return ast

    def test(self, ast):
        return ast

    def or_test(self, ast):
        return ast

    def and_test(self, ast):
        return ast

    def not_test(self, ast):
        return ast

    def comparison(self, ast):
        return ast

    def or_expr(self, ast):
        return ast

    def and_expr(self, ast):
        return ast

    def shift_expr(self, ast):
        return ast

    def arith_expr(self, ast):
        return ast

    def term(self, ast):
        return ast

    def factor(self, ast):
        return ast

    def power(self, ast):
        return ast

    def atom(self, ast):
        return ast

    def variable(self, ast):
        return ast

    def function(self, ast):
        return ast

    def arglist(self, ast):
        return ast

    def argument(self, ast):
        return ast

    def reference(self, ast):
        return ast

    def NUMBER(self, ast):
        return ast

    def STRING(self, ast):
        return ast

    def comparison_operator(self, ast):
        return ast

    def NAME(self, ast):
        return ast


def main(
        filename,
        startrule,
        trace=False,
        whitespace=None,
        nameguard=None,
        comments_re=None,
        eol_comments_re=None,
        ignorecase=None,
        left_recursion=True,
        **kwargs):

    with open(filename) as f:
        text = f.read()
    whitespace = whitespace or None
    parser = ExpressionParser(parseinfo=False)
    ast = parser.parse(
        text,
        startrule,
        filename=filename,
        trace=trace,
        whitespace=whitespace,
        nameguard=nameguard,
        ignorecase=ignorecase,
        **kwargs)
    return ast

if __name__ == '__main__':
    import json
    ast = generic_main(main, ExpressionParser, name='Expression')
    print('AST:')
    print(ast)
    print()
    print('JSON:')
    print(json.dumps(ast, indent=2))
    print()
