##
# Borges::RenderingContext is used by Borges::HtmlRenderer to
# hold the document being rendered, the URL of the next page in
# the control flow, and all of the callbacks for this page.

class Borges::RenderingContext

  ##
  # The document being rendered

  attr_accessor :document

  ##
  # The URL for the next page in the control flow

  attr_accessor :action_url

  ##
  # A Borges::CallbackStore for Borges::HtmlRenderer to register
  # callbacks into

  attr_accessor :callbacks

  ##
  # Create a new rendering context 

  def initialize(document, action_url, callbacks)
    @document = document
    @action_url = action_url
    @callbacks = callbacks
  end

end # class Borges::RenderingContext

