require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MIPS_PMAP_H_)) {
    eval 'sub _MIPS_PMAP_H_ () {1;}' unless defined(&_MIPS_PMAP_H_);
    if(defined(&_KERNEL_OPT)) {
	require './mips/opt_multiprocessor.ph';
	require './mips/opt_uvmhist.ph';
	require './mips/opt_cputype.ph';
    }
    require 'sys/evcnt.ph';
    require 'sys/kcpuset.ph';
    require 'sys/kernhist.ph';
    unless(defined(&__BSD_PTENTRY_T__)) {
	eval 'sub __BSD_PTENTRY_T__ () {1;}' unless defined(&__BSD_PTENTRY_T__);
	eval 'sub PRIxPTE () { &PRIx32;}' unless defined(&PRIxPTE);
    }
    eval 'sub KERNEL_PID () {0;}' unless defined(&KERNEL_PID);
    if(defined(&__PMAP_PRIVATE)) {
	require 'mips/locore.ph';
	require 'mips/cache.ph';
	eval 'sub PMAP_VIRTUAL_CACHE_ALIASES () {1;}' unless defined(&PMAP_VIRTUAL_CACHE_ALIASES);
	eval 'sub PMAP_INVALID_SEGTAB_ADDRESS () {(( &pmap_segtab_t *) &NULL);}' unless defined(&PMAP_INVALID_SEGTAB_ADDRESS);
	eval 'sub PMAP_TLB_NEED_SHOOTDOWN () {1;}' unless defined(&PMAP_TLB_NEED_SHOOTDOWN);
	eval 'sub PMAP_TLB_FLUSH_ASID_ON_RESET () { &false;}' unless defined(&PMAP_TLB_FLUSH_ASID_ON_RESET);
	if((defined(&UPAGES) ? &UPAGES : undef) > 1) {
	    eval 'sub PMAP_TLB_WIRED_UPAGES () { &MIPS3_TLB_WIRED_UPAGES;}' unless defined(&PMAP_TLB_WIRED_UPAGES);
	}
	eval 'sub pmap_md_tlb_asid_max () {
	    eval q(( &MIPS_TLB_NUM_PIDS - 1));
	}' unless defined(&pmap_md_tlb_asid_max);
	if(defined(&MULTIPROCESSOR)) {
	    eval 'sub PMAP_NO_PV_UNCACHED () {1;}' unless defined(&PMAP_NO_PV_UNCACHED);
	}
	if(((defined(&MIPS32R2) ? &MIPS32R2 : undef) + (defined(&MIPS64R2) ? &MIPS64R2 : undef) + (defined(&MIPS64R2_RMIXL) ? &MIPS64R2_RMIXL : undef)) > 0) {
	    eval 'sub PMAP_SEGTAB_ALIGN () { &__aligned($sizeof{ &void }* &NSEGPG)  &__section(".data1");}' unless defined(&PMAP_SEGTAB_ALIGN);
	}
	require 'uvm/uvm_physseg.ph';
	eval 'sub pmap_md_virtual_cache_aliasing_p {
	    my($void) = @_;
    	    eval q({  &MIPS_CACHE_VIRTUAL_ALIAS; });
	}' unless defined(&pmap_md_virtual_cache_aliasing_p);
	eval 'sub pmap_md_cache_prefer_mask {
	    my($void) = @_;
    	    eval q({  &MIPS_HAS_R4K_MMU ?  ($mips_cache_info->{mci_cache_prefer_mask}) : 0; });
	}' unless defined(&pmap_md_cache_prefer_mask);
    }
    eval 'sub POOL_VTOPHYS {
        my($va) = @_;
	    eval q( &pmap_md_pool_vtophys(( &vaddr_t)$va));
    }' unless defined(&POOL_VTOPHYS);
    eval 'sub POOL_PHYSTOV {
        my($pa) = @_;
	    eval q( &pmap_md_pool_phystov(( &paddr_t)$pa));
    }' unless defined(&POOL_PHYSTOV);
    eval 'sub pmap_md_direct_map_paddr {
        my($pa) = @_;
	    eval q( &pmap_md_pool_phystov(( &paddr_t)$pa));
    }' unless defined(&pmap_md_direct_map_paddr);
    if(defined(&__mips_o32)) {
    } else {
    }
    if(defined(&_LP64)) {
	eval 'sub PMAP_SEGTABSIZE () { &NSEGPG;}' unless defined(&PMAP_SEGTABSIZE);
    } else {
	eval 'sub PMAP_SEGTABSIZE () {(1<< (31-  &SEGSHIFT));}' unless defined(&PMAP_SEGTABSIZE);
    }
    require 'uvm/uvm_pmap.ph';
    require 'uvm/pmap/vmpagemd.ph';
    require 'uvm/pmap/pmap.ph';
    require 'uvm/pmap/pmap_pvt.ph';
    require 'uvm/pmap/pmap_tlb.ph';
    require 'uvm/pmap/pmap_synci.ph';
    if(defined(&_KERNEL)) {
	eval 'sub PMAP_CCA_FOR_PA {
	    my($pa) = @_;
    	    eval q( &CCA_UNCACHED);
	}' unless defined(&PMAP_CCA_FOR_PA);
	if(defined(&_MIPS_PADDR_T_64BIT) || defined(&_LP64)) {
	    eval 'sub PGC_NOCACHE () {4.61168601842739e+18;}' unless defined(&PGC_NOCACHE);
	    eval 'sub PGC_PREFETCH () {2.30584300921369e+18;}' unless defined(&PGC_PREFETCH);
	}
	if(defined(&__PMAP_PRIVATE)) {
	    require 'mips/pte.ph';
	}
	eval 'sub pmap_phys_address {
	    my($x) = @_;
    	    eval q( &mips_ptob($x));
	}' unless defined(&pmap_phys_address);
	eval 'sub PMAP_NEED_PROCWR () {1;}' unless defined(&PMAP_NEED_PROCWR);
	if(defined(&MIPS3_PLUS)) {
	    eval 'sub PMAP_PREFER {
	        my($pa, $va, $sz, $td) = @_;
    		eval q( &pmap_prefer(($pa), ($va), ($sz), ($td)));
	    }' unless defined(&PMAP_PREFER);
	}
	eval 'sub PMAP_ENABLE_PMAP_KMPAGE () {1;}' unless defined(&PMAP_ENABLE_PMAP_KMPAGE);
	if(defined(&MIPS64_SB1)) {
	    undef(&PMAP_PAGEIDLEZERO) if defined(&PMAP_PAGEIDLEZERO);
	    eval 'sub PMAP_PAGEIDLEZERO {
	        my($pa) = @_;
    		eval q(( &pmap_zero_page($pa),  &true));
	    }' unless defined(&PMAP_PAGEIDLEZERO);
	    undef(&PMAP_CCA_FOR_PA) if defined(&PMAP_CCA_FOR_PA);
	    eval 'sub PMAP_CCA_FOR_PA {
	        my($pa) = @_;
    		eval q( &sbmips_cca_for_pa($pa));
	    }' unless defined(&PMAP_CCA_FOR_PA);
	}
	if(defined(&__HAVE_PMAP_PV_TRACK)) {
	    eval 'sub PMAP_PAGE_TO_MD {
	        my($ppage) = @_;
    		eval q(((($ppage)-> &pp_md)));
	    }' unless defined(&PMAP_PAGE_TO_MD);
	}
    }
}
1;
