/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import org.broad.igv.renderer.AbstractColorScale;

public class MonocolorScale
extends AbstractColorScale {
    static int nSteps = 10;
    float maxAlpha = 1.0f;
    float minAlpha = 0.1f;
    float minValue;
    float maxValue;
    Color[] colorTable = new Color[nSteps];
    private final float range;

    public MonocolorScale(float x1, float x2, Color baseColor) {
        this.minValue = Math.min(x1, x2);
        this.maxValue = Math.max(x1, x2);
        this.range = this.maxValue - this.minValue;
        if (x1 == x2) {
            for (int i = 0; i < this.colorTable.length; ++i) {
                this.colorTable[i] = baseColor;
            }
        } else {
            float alphaStep = (this.maxAlpha - this.minAlpha) / (float)(nSteps - 1);
            float[] baseComponents = baseColor.getComponents(null);
            for (int i = 0; i < nSteps; ++i) {
                float alpha = Math.min(1.0f, 0.1f + this.minAlpha + (float)i * alphaStep);
                this.colorTable[i] = new Color(baseComponents[0], baseComponents[1], baseComponents[2], alpha);
            }
        }
    }

    @Override
    public Color getColor(float value) {
        if (this.range == 0.0f) {
            return this.colorTable[0];
        }
        int idx = (int)Math.min((float)(nSteps - 1), Math.max(0.0f, (float)nSteps * (value - this.minValue) / this.range));
        return this.colorTable[idx];
    }

    @Override
    public String asString() {
        return null;
    }

    @Override
    public boolean isDefault() {
        return false;
    }
}

