package TDS::LastModified;
# $Id: LastModified.pm,v 1.11 2001/02/06 05:02:08 tom Exp $
################################################################

use strict;
use vars qw(@ISA
	    $ReflectPimData
	    $ReflectCommentData
	    );

use LastModified;

use TDS::DirInfo;

@ISA = qw(LastModified);

$ReflectPimData = 0 unless defined $ReflectPimData;
$ReflectCommentData = 0 unless defined $ReflectCommentData;

attributes qw();

################################################################
sub initialize($)
{
    my $self = shift;

    require TDS::AccessLog::DirInfo;
    $self->lm_file(TDS::AccessLog::DirInfo::GetLogDir() . "/LastModified");

    $self->SUPER::initialize;
}
# not overriedn
# must NOT call by functions in  LastModified
# because of self-reference and loop
sub GetRealLastModified ($)
{
    my $self = shift;

    # get real last modified
#    warn times, " get l-m of log/LastModified";
    unless ($self->lm){
	# get initial last-modified by log file
	$self->GetLastModified;
    }

#    warn " get real l-m";
    ## get real last-modified using *.tdf
    # consider of (1)todo.dat, schedule.dat and (2)comment.dat ??
    # (0) *.tdf
    require TDS::Collection;
    my $col = new TDS::Collection;
    $col->collect_files;
    my $lm = $col->last_modified;

#    die $self->lm, ", $lm";
    
    # (1) pim data
    if ($ReflectPimData){
	my %files;
	my $data_dir = TDS::DirInfo::GetDataDir();
	my $diary_dir = TDS::DirInfo::GetDiaryDir();
	
	$files{todo} = "$data_dir/todo.dat";
	$files{sche_gen} = "$data_dir/schedule.dat";
	my $year = $TDS::Status->start_time->year;
	$files{sche_this}= "$diary_dir/$year/schedule.dat";
	$year++;
	$files{sche_next} = "$diary_dir/$year/schedule.dat";

	for (values %files){
	    my $file = $_;
	    my $tmp_lm = LastModified::GetLastModified($file);
	    $lm = ($tmp_lm > $lm) ? $tmp_lm : $lm;
	}
    }
    # (2) comment datafile
    if ($ReflectCommentData){
	require TDS::AccessLog::DirInfo;
	my $logdir = TDS::AccessLog::DirInfo::GetLogDir();
	my $comment_data = "$logdir/comment.dat";
	my $comment_lm = LastModified::GetLastModified($comment_data);
	$lm = ($comment_lm > $lm) ? $comment_lm : $lm;
    }
	
    $self->SetLastModified($lm);
    return $lm;
}
1;
