/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectUtil;
import java.util.Arrays;

public final class Constructor
extends AccessibleObject
implements Member {
    private Class clazz;
    private int slot;
    private Class declaringClass;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    byte[] vmData;
    private char[] paramTypes;

    public final Class getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = Constructor.nativeGetDeclaringClass(this.vmData);
        }
        return this.declaringClass;
    }

    public static final native Class nativeGetDeclaringClass(byte[] var0);

    public final String getName() {
        String qualifiedName = this.getDeclaringClass().getName();
        return qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
    }

    public final int getModifiers() {
        return this.nativeGetModifiers(this.vmData);
    }

    public final native int nativeGetModifiers(byte[] var1);

    public final Class[] getParameterTypes() {
        if (this.parameterTypes == null) {
            this.parameterTypes = ReflectUtil.getParameterTypes(Constructor.nativeGetDescriptor(this.vmData), this.getDeclaringClass().getClassLoader());
        }
        return this.parameterTypes;
    }

    public final Class[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            this.exceptionTypes = Constructor.nativeGetExceptionTypes(this.vmData);
        }
        return this.exceptionTypes;
    }

    public static final native Class[] nativeGetExceptionTypes(byte[] var0);

    public final boolean equals(Object o) {
        if (!(o instanceof Constructor)) {
            return false;
        }
        Constructor that = (Constructor)o;
        if (this.getDeclaringClass() != that.getDeclaringClass()) {
            return false;
        }
        return Arrays.equals(this.getParameterTypes(), that.getParameterTypes());
    }

    public final int hashCode() {
        return this.getDeclaringClass().getName().hashCode();
    }

    public final String toString() {
        int i;
        StringBuffer sb = new StringBuffer(128);
        Modifier.toString(this.getModifiers(), sb).append(' ');
        sb.append(this.getDeclaringClass().getName()).append('(');
        Class[] c = this.getParameterTypes();
        if (c.length > 0) {
            sb.append(c[0].getName());
            i = 1;
            while (i < c.length) {
                sb.append(',').append(c[i].getName());
                ++i;
            }
        }
        sb.append(')');
        c = this.getExceptionTypes();
        if (c.length > 0) {
            sb.append(" throws ").append(c[0].getName());
            i = 1;
            while (i < c.length) {
                sb.append(',').append(c[i].getName());
                ++i;
            }
        }
        return sb.toString();
    }

    public final Object newInstance(Object[] args) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (args == null) {
            args = new Object[]{};
        }
        char[] paramTypes = this.getParamTypes();
        int count = paramTypes.length;
        int i = 0;
        while (i < count) {
            switch (paramTypes[i]) {
                case 'Z': {
                    Object[] wrapper = new boolean[]{(Boolean)args[i]};
                    args[i] = wrapper;
                    break;
                }
                case 'B': {
                    Object[] wrapper = new byte[1];
                    wrapper[0] = (Byte)args[i];
                    args[i] = wrapper;
                    break;
                }
                case 'S': {
                    Object[] wrapper = new short[1];
                    wrapper[0] = (Short)args[i];
                    args[i] = wrapper;
                    break;
                }
                case 'C': {
                    Object[] wrapper = new char[1];
                    wrapper[0] = ((Character)args[i]).charValue();
                    args[i] = wrapper;
                    break;
                }
                case 'I': {
                    Object[] wrapper = new int[1];
                    wrapper[0] = (Integer)args[i];
                    args[i] = wrapper;
                    break;
                }
                case 'J': {
                    Object[] wrapper = new long[1];
                    wrapper[0] = ((Long)args[i]).longValue();
                    args[i] = wrapper;
                    break;
                }
                case 'F': {
                    Object[] wrapper = new float[1];
                    wrapper[0] = ((Float)args[i]).floatValue();
                    args[i] = wrapper;
                    break;
                }
                case 'D': {
                    Object[] wrapper = new double[1];
                    wrapper[0] = ((Double)args[i]).doubleValue();
                    args[i] = wrapper;
                    break;
                }
                case 'L': {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            ++i;
        }
        return Constructor.constructNative(this.vmData, paramTypes, args);
    }

    private static final native Object constructNative(byte[] var0, char[] var1, Object[] var2) throws InstantiationException, IllegalAccessException, InvocationTargetException;

    private static final native String nativeGetDescriptor(byte[] var0);

    private final char[] getParamTypes() {
        if (this.paramTypes == null) {
            char c;
            char[] array = Constructor.nativeGetDescriptor(this.vmData).toCharArray();
            int count = 0;
            int i = 0;
            block5: while ((c = array[++i]) != ')') {
                switch (c) {
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'Z': {
                        array[count++] = c;
                        break;
                    }
                    case 'L': {
                        array[count++] = 76;
                        while (array[++i] != ';') {
                        }
                        break;
                    }
                    case '[': {
                        array[count++] = 76;
                        while (array[++i] == '[') {
                        }
                        if (array[i] != 'L') continue block5;
                        while (array[++i] != ';') {
                        }
                        break;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
            char[] types = new char[count];
            System.arraycopy(array, 0, types, 0, count);
            this.paramTypes = types;
        }
        return this.paramTypes;
    }

    private Constructor(byte[] vmData) {
        this.vmData = vmData;
    }
}

