package TDS::ID;

use strict;
use vars qw(@ISA);

use ObjectTemplate;

@ISA = qw(ObjectTemplate);

attributes qw(remote_host user_agent
	      id times is_first_visit);


################################################################

sub initialize($)
{
    my $self = shift;

    my $remote_host = $self->remote_host || $ENV{'REMOTE_HOST'} || $ENV{'REMOTE_ADDR'} || '';
    my $user_agent = $self->user_agent || $ENV{'HTTP_USER_AGENT'} || '';

    # id
    require CGI::CookieTool;    
    my $id = CGI::CookieTool::GetCookie('id');
    unless ($id){    # in first visit, get uniq ID
	$self->is_first_visit(1);
	# set ID by REMOTE_IDENT, REMOTE_HOSTHTTP_USER_AGENT,now time
	# for anchi-deprecation, add two columns of process ID
	my $ident = $ENV{'REMOTE_IDENT'} || '';
	$ident = '' if $ident eq 'unknown';

	require DateTime::Format;
	my $date_str = DateTime::Format::time2str("%Y/%m/%d_%H:%M:%S", time());
	my $pid = $$ || 0;
	$id = sprintf("%s_%s_%s_%s_%02d",
		      $ident,
		      $remote_host,
		      $user_agent,
		      $date_str,
		      $pid%100);
    }
    $self->id($id);
    # times
    my $times = CGI::CookieTool::GetCookie('times') || 0;
    $self->times($times+1);

    $self->SUPER::initialize;
}

sub GetID
{
    return shift->id();
}

sub GetTimes
{
    return shift->times();
}

1;
