
#import <objc/Object.h>
#import <expat.h>

#define XML_PARSE_STARTELEM 0x0001
#define XML_PARSE_ENDELEM 0x0002
#define XML_PARSE_CHARACTERS 0x0004
#define XML_PARSE_PROCINSTR 0x0008
#define XML_PARSE_COMMENT 0x0010
#define XML_PARSE_CDATA 0x0020
#define XML_PARSE_EXTERNAL_ENTITY 0x0040
#define XML_PARSE_UNPARSED_ENTITY 0x0080
#define XML_PARSE_NAMESPACE_DECL 0x0100
#define XML_PARSE_DEFAULT 0x0200
#define XML_PARSE_DISABLE_NS 0x8000

#define XML_PARSE_ALL 0x3ff

@interface XMLParser : Object {
  XML_Parser parser;
  int bufsize;
}

/* The following methods should be overriden by the caller */

/* Start and and element notification methods */
- startElement:(const XML_Char *)qname:(const XML_Char **)atts;
- endElement:(const XML_Char *)qname;

/* Character data notification */
- characters:(const XML_Char *)s:(int)len;

/* Processing instruction notification */
- processingInstruction:(const XML_Char *)target:(const XML_Char *)data;

/* Comment notification */
- comment:(const XML_Char *)data;

/* CDATA section notification */
- startCdata;
- endCdata;

/* External entity notification */
- (int)externalEntity:(const XML_Char *)context:(const XML_Char *)base
:(const XML_Char *)publicID:(const XML_Char *)systemID;
- unparsedEntityDecl:(const XML_Char *)name:(const XML_Char *)base
:(const XML_Char *)publicID:(const XML_Char *)systemID
:(const XML_Char *)notationName;

/* Namespace prefix notification */
- startPrefixMapping:(const XML_Char *)uri:(const XML_Char *)localName;
- endPrefixMapping:(const XML_Char *)prefix;

/* default handler */
- defaultHandler:(const XML_Char *)s:(int)len;

/* Data reader method */
- (int)dataRead:(char *)buff:(int)buflen;

/* is passed the Expat error code if an error occurs */
- errorHandler:(int)errcode;

/* The following methods should probably not be overriden */
- init:(const XML_Char *)encoding:(XML_Char)sep:(int)bs:(unsigned int)parsemask;
- start;
- free;

@end
