<?php

/**
 * BaseEmpDependent
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int           $emp_number                      Type: integer(4), primary key
 * @property float         $seqno                           Type: decimal(2), primary key
 * @property string        $name                            Type: string(100)
 * @property string        $relationship_type               Type: enum, Possible values (CHILD, OTHER)
 * @property string        $relationship                    Type: string(100)
 * @property string        $date_of_birth                   Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @property Employee      $Employee                        
 *  
 * @method int             getEmpNumber()                   Type: integer(4), primary key
 * @method float           getSeqno()                       Type: decimal(2), primary key
 * @method string          getName()                        Type: string(100)
 * @method string          getRelationshipType()            Type: enum, Possible values (CHILD, OTHER)
 * @method string          getRelationship()                Type: string(100)
 * @method string          getDateOfBirth()                 Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method Employee        getEmployee()                    
 *  
 * @method EmpDependent    setEmpNumber(int $val)           Type: integer(4), primary key
 * @method EmpDependent    setSeqno(float $val)             Type: decimal(2), primary key
 * @method EmpDependent    setName(string $val)             Type: string(100)
 * @method EmpDependent    setRelationshipType(string $val) Type: enum, Possible values (CHILD, OTHER)
 * @method EmpDependent    setRelationship(string $val)     Type: string(100)
 * @method EmpDependent    setDateOfBirth(string $val)      Type: date(25), Date in ISO-8601 format (YYYY-MM-DD)
 * @method EmpDependent    setEmployee(Employee $val)       
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseEmpDependent extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('hs_hr_emp_dependents');
        $this->hasColumn('emp_number', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 4,
             ));
        $this->hasColumn('ed_seqno as seqno', 'decimal', 2, array(
             'type' => 'decimal',
             'primary' => true,
             'length' => 2,
             ));
        $this->hasColumn('ed_name as name', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('ed_relationship_type as relationship_type', 'enum', null, array(
             'type' => 'enum',
             'values' => 
             array(
              0 => 'child',
              1 => 'other',
             ),
             ));
        $this->hasColumn('ed_relationship as relationship', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'length' => 100,
             ));
        $this->hasColumn('ed_date_of_birth as date_of_birth', 'date', 25, array(
             'type' => 'date',
             'length' => 25,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Employee', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));
    }
}