<?php

/**
 * PluginBuzzNotificationMetadata
 *
 * This class has been auto-generated by the Doctrine ORM Framework
 *
 *
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class PluginBuzzNotificationMetadata extends BaseBuzzNotificationMetadata
{
    /**
     * @var BuzzTimezoneUtility|null
     */
    protected $buzzTimeZoneUtility = null;

    /**
     * @inheritDoc
     */
    public function getUserLastNotificationViewTime()
    {
        return $this->getTimeForUser($this->getLastNotificationViewTime());
    }

    /**
     * @inheritDoc
     */
    public function getUserLastClearNotifications()
    {
        return $this->getTimeForUser($this->getLastClearNotifications());
    }

    /**
     * @inheritDoc
     */
    public function getUserLastBuzzViewTime()
    {
        return $this->getTimeForUser($this->getLastBuzzViewTime());
    }

    /**
     * @param string|null $datetime
     * @return string
     * @throws sfException
     */
    public function getTimeForUser($datetime)
    {
        $offset = sfContext::getInstance()->getUser()->getUserTimeZoneOffsetForBuzz();
        if (is_null($datetime) || !isset($offset) || is_null($offset)) {
            return $datetime;
        }
        $date = new DateTime($datetime);
        $date->setTimezone(new DateTimeZone($this->getBuzzTimezoneUtility()->getTimeZoneFromClientOffset($offset)));
        return $date->format('Y-m-d H:i:s');
    }

    /**
     * @return BuzzTimezoneUtility
     */
    public function getBuzzTimezoneUtility()
    {
        if (!$this->buzzTimeZoneUtility instanceof BuzzTimezoneUtility) {
            $this->buzzTimeZoneUtility = new BuzzTimezoneUtility();
        }
        return $this->buzzTimeZoneUtility;
    }

}
