package TDS::Comment;
# $Id: Comment.pm,v 1.24 2001/01/03 08:20:38 tom Exp $
################################################################
use strict;

use vars qw(@ISA @EXPORT
	    $DefaultComment
	    $DateTemplate
	    $CommentItemTemplate $CommentShowTemplate);

use ObjectTemplate;
use CGI::QueryString;
use CGI::Tools;
use CGI::CookieTool;
use Template;

use TDS::System;
use TDS::Status;

@ISA = qw(ObjectTemplate);
@EXPORT = qw(attributes);

attributes qw(logfile
	      content);

$DefaultComment = "ɤ" unless defined $DefaultComment;
$DateTemplate = "%0m/%0d %hh:%mm" unless defined $DateTemplate;
$CommentItemTemplate = qq(<tr><th>%date</th><th>%name</th><td>%comment</td></tr>\n) unless defined $CommentItemTemplate;
$CommentShowTemplate = qq(<table summary="comment" border=1>%content</table>\n) unless defined $CommentShowTemplate;

################################################################
sub initialize($)
{
    my $self = shift;
    
    require TDS::AccessLog::DirInfo;
    my $logdir = TDS::AccessLog::DirInfo::GetLogDir();
    $self->logfile("$logdir/comment.dat") unless $self->logfile;
    
    $self->content([]);
    
    $self->SUPER::initialize;
}

################################################################
sub Read ($)
{
    my $self = shift;

    my $time = new DateTime::Time;
    
    open(F, $self->logfile) || return;
    while (<F>){
	chomp;
	my ($name, $id, $tm, $comment) = split(/\t/, Escape($_));
	my $date;
	unless ($comment){                # for old format (w/o $date)
	    $comment = $tm;
	    $tm = 0;
	} else {
	    $time->SetTime($tm);
	    $date = Expand($DateTemplate, $time->GetParams);
	}
	push(@{$self->content},
	     {'name'=>$name, 'tm'=>$tm, 'date'=>$date, 'comment'=>$comment});
    }
    close (F);
}
################################################################

# ǿ $num ʬɽ
# $num < 0 ʤ

sub AsHTML ($;$)
{
    my ($self, $num) = @_;

    $num ||= 5;

    $self->Read;
    my @html;

    my $item;
    for $item (@{$self->content}){
	push(@html, Expand($CommentItemTemplate, $item));
    }
    my $last = $#html;
    my $first;
    if ($num < 0){    # 
	$first = 0;
    } else {
	$first = $#html-$num+1;
    }
    $first = 0 if $first < 0;
    
    return Expand($CommentShowTemplate,
		  {content=>join("\n", reverse (@html[$first..$last]))});
}
################################################################
sub Add($$$)
{
    my ($self, $name, $comment) = @_;

    # param() ͳʤΤǡǤ internal ѴƤʤϤ

    # ȥ˽񤭹
    open(F, ">>" . $self->logfile) || die $self->logfile;
    printf(F "%s\t%s\t%s\t%s\n",
	   $name, $TDS::Status->id->GetID(), time(), $comment);
    close F;
    
    # ID Map 򹹿
    require TDS::ID_Map;
    my $map = new TDS::ID_Map;
    $map->Map($TDS::Status->id->GetID(), $name);

    $self->AddedHook;
}
sub AddedHook {}
sub ShowAccept($$$)
{
    my ($self, $name, $comment) = @_;
    
    print "content-type: text/html\n";
    my $s_name = $name;

    #&jcode::convert(\$s_name, 'sjis');
    if (param('cookie_ok')){
	require TDS::Cookie;	
	print AsCookieHeader('name', $s_name, $TDS::Cookie::Expires);
    }
    print "\n";
    
    # åɽ
    my $template = 
	qq(<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html><head>
<title>Comment Accepted</title></head>
<body>
<h1>Thanks for your comment</h1>
<p>%name: %comment</p>
<hr>
<a href="%diary_url">back</a>
	   </body></html>);

    require TDS::IdentInfo;
    my $params = {'name'=>Escape($name),
		 'comment'=>Escape($comment),
		  'diary_url'=>TDS::IdentInfo->Get('url')
		  };

    print Expand($template, $params);
}    
1;
