/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslServer;

public class SaslOutputStream
extends OutputStream {
    private static final String NAME = "SaslOutputStream";
    private static final String TRACE = "DEBUG";
    private static final boolean DEBUG = true;
    private static final int debuglevel = 3;
    private static final PrintWriter err = new PrintWriter(System.out, true);
    private SaslClient client;
    private SaslServer server;
    private int maxRawSendSize;
    private OutputStream dest;

    private static final void debug(String string, Object object) {
        err.println("[" + string + "] SaslOutputStream: " + String.valueOf(object));
    }

    public void close() throws IOException {
        this.dest.flush();
        this.dest.close();
    }

    public void flush() throws IOException {
        this.dest.flush();
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("b");
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException("off=" + String.valueOf(n) + ", len=" + String.valueOf(n2) + ", b.length=" + String.valueOf(byArray.length));
        }
        if (n2 == 0) {
            return;
        }
        int n3 = 1;
        byte[] byArray2 = null;
        while (n2 > 0) {
            int n4 = n2 > this.maxRawSendSize ? this.maxRawSendSize : n2;
            byArray2 = this.client != null ? this.client.wrap(byArray, n, n4) : this.server.wrap(byArray, n, n4);
            int n5 = byArray2.length;
            byte[] byArray3 = new byte[n5 + 4];
            byArray3[0] = (byte)(n5 >>> 24);
            byArray3[1] = (byte)(n5 >>> 16);
            byArray3[2] = (byte)(n5 >>> 8);
            byArray3[3] = (byte)n5;
            System.arraycopy(byArray2, 0, byArray3, 4, n5);
            this.dest.write(byArray3);
            n += n4;
            n2 -= n4;
            ++n3;
        }
        this.dest.flush();
    }

    public SaslOutputStream(SaslClient saslClient, OutputStream outputStream) throws IOException {
        this.client = saslClient;
        this.maxRawSendSize = Integer.parseInt((String)saslClient.getNegotiatedProperty("javax.security.sasl.rawsendsize"));
        this.server = null;
        this.dest = outputStream;
    }

    public SaslOutputStream(SaslServer saslServer, OutputStream outputStream) throws IOException {
        this.server = saslServer;
        this.maxRawSendSize = Integer.parseInt((String)saslServer.getNegotiatedProperty("javax.security.sasl.rawsendsize"));
        this.client = null;
        this.dest = outputStream;
    }
}

