/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom.ls;

import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.ls.DomLSException;
import gnu.xml.dom.ls.DomLSOutput;
import gnu.xml.transform.StreamSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMStringList;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

public class DomLSSerializer
extends StreamSerializer
implements LSSerializer,
DOMConfiguration,
DOMStringList {
    private static final List SUPPORTED_PARAMETERS = Arrays.asList(new String[]{"discard-default-content", "xml-declaration"});
    private LSSerializerFilter filter;
    private StreamSerializer serializer;

    public DOMConfiguration getDomConfig() {
        return this;
    }

    public String getNewLine() {
        return this.eol;
    }

    public void setNewLine(String string) {
        if (string == null) {
            string = System.getProperty("line.separator");
        }
        this.eol = string;
    }

    public LSSerializerFilter getFilter() {
        return this.filter;
    }

    public void setFilter(LSSerializerFilter lSSerializerFilter) {
        this.filter = lSSerializerFilter;
    }

    public boolean write(Node node2, LSOutput lSOutput) throws LSException {
        OutputStream outputStream = lSOutput.getByteStream();
        try {
            if (outputStream == null) {
                String string = lSOutput.getSystemId();
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setDoOutput(true);
                    if (uRLConnection instanceof HttpURLConnection) {
                        ((HttpURLConnection)uRLConnection).setRequestMethod("PUT");
                    }
                    outputStream = uRLConnection.getOutputStream();
                }
                catch (MalformedURLException malformedURLException) {
                    File file = new File(string);
                    outputStream = new FileOutputStream(file);
                }
            }
            this.serialize(node2, outputStream);
            outputStream.flush();
            return true;
        }
        catch (IOException iOException) {
            throw new DomLSException(82, iOException);
        }
    }

    public boolean writeToURI(Node node2, String string) throws LSException {
        DomLSOutput domLSOutput = new DomLSOutput();
        domLSOutput.setSystemId(string);
        return this.write(node2, domLSOutput);
    }

    public String writeToString(Node node2) throws DOMException, LSException {
        StringWriter stringWriter = new StringWriter();
        DomLSOutput domLSOutput = new DomLSOutput();
        domLSOutput.setCharacterStream(stringWriter);
        this.write(node2, domLSOutput);
        return ((Object)stringWriter).toString();
    }

    public void serialize(Node node2, OutputStream outputStream) throws IOException {
        if (this.filter == null) {
            super.serialize(node2, outputStream);
        } else {
            int n = this.filter.getWhatToShow();
            if (n != -1) {
                switch (node2.getNodeType()) {
                    case 2: {
                        if ((n & 2) != 0) break;
                        super.serialize(node2, outputStream);
                        return;
                    }
                    case 3: {
                        if ((n & 4) != 0) break;
                        super.serialize(node2, outputStream);
                        return;
                    }
                    case 1: {
                        if ((n & 1) != 0) break;
                        super.serialize(node2, outputStream);
                        return;
                    }
                    case 4: {
                        if ((n & 8) != 0) break;
                        super.serialize(node2, outputStream);
                        return;
                    }
                    case 8: {
                        if ((n & 0x80) != 0) break;
                        super.serialize(node2, outputStream);
                        return;
                    }
                    case 9: {
                        if ((n & 0x100) != 0) break;
                        super.serialize(node2, outputStream);
                        return;
                    }
                    case 10: {
                        if ((n & 0x200) != 0) break;
                        super.serialize(node2, outputStream);
                        return;
                    }
                    case 7: {
                        if ((n & 0x40) != 0) break;
                        super.serialize(node2, outputStream);
                        return;
                    }
                    case 11: {
                        if ((n & 0x400) != 0) break;
                        super.serialize(node2, outputStream);
                        return;
                    }
                    case 6: {
                        if ((n & 0x20) != 0) break;
                        super.serialize(node2, outputStream);
                        return;
                    }
                    case 5: {
                        if ((n & 0x10) != 0) break;
                        super.serialize(node2, outputStream);
                        return;
                    }
                    case 12: {
                        if ((n & 0x800) != 0) break;
                        super.serialize(node2, outputStream);
                        return;
                    }
                }
            }
            switch (this.filter.acceptNode(node2)) {
                case 1: {
                    super.serialize(node2, outputStream);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    Node node3 = node2.getFirstChild();
                    if (node3 == null) break;
                    this.serialize(node3, outputStream);
                    break;
                }
            }
        }
    }

    public void setParameter(String string, Object object) throws DOMException {
        if ("discard-default-content".equals(string)) {
            this.discardDefaultContent = "true".equals(object.toString());
        } else if ("xml-declaration".equals(string)) {
            this.xmlDeclaration = "false".equals(object.toString());
        } else {
            throw new DomDOMException(9);
        }
    }

    public Object getParameter(String string) throws DOMException {
        if ("discard-default-content".equals(string)) {
            return this.discardDefaultContent ? "true" : "false";
        }
        if ("xml-declaration".equals(string)) {
            return this.xmlDeclaration ? "true" : "false";
        }
        throw new DomDOMException(9);
    }

    public boolean canSetParameter(String string, Object object) {
        return this.contains(string);
    }

    public DOMStringList getParameterNames() {
        return this;
    }

    public String item(int n) {
        return (String)SUPPORTED_PARAMETERS.get(n);
    }

    public int getLength() {
        return SUPPORTED_PARAMETERS.size();
    }

    public boolean contains(String string) {
        return SUPPORTED_PARAMETERS.contains(string);
    }

    public DomLSSerializer() {
        this.discardDefaultContent = true;
    }
}

