/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.Locator;
import CH.ifa.draw.standard.AbstractConnector;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;

public class LocatorConnector
extends AbstractConnector {
    public static final int SIZE = 8;
    private Locator fLocator;
    private static final long serialVersionUID = 5062833203337604181L;
    private int locatorConnectorSerializedDataVersion = 1;

    public LocatorConnector() {
        this.fLocator = null;
    }

    public LocatorConnector(Figure figure, Locator locator) {
        super(figure);
        this.fLocator = locator;
    }

    protected Point locate(ConnectionFigure connectionFigure) {
        return this.fLocator.locate(this.owner());
    }

    public boolean containsPoint(int n, int n2) {
        return this.displayBox().contains(n, n2);
    }

    public Rectangle displayBox() {
        Point point = this.fLocator.locate(this.owner());
        return new Rectangle(point.x - 4, point.y - 4, 8, 8);
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = this.displayBox();
        graphics.setColor(Color.blue);
        graphics.fillOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void write(StorableOutput storableOutput) {
        super.write(storableOutput);
        storableOutput.writeStorable(this.fLocator);
    }

    public void read(StorableInput storableInput) throws IOException {
        super.read(storableInput);
        this.fLocator = (Locator)storableInput.readStorable();
    }
}

