/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicPanelUI;
import javax.swing.text.View;

public class BasicTabbedPaneUI
extends TabbedPaneUI
implements SwingConstants {
    transient ScrollingButton incrButton;
    transient ScrollingButton decrButton;
    transient ScrollingViewport viewport;
    transient ScrollingPanel panel;
    transient int currentScrollLocation;
    protected Rectangle calcRect;
    protected Rectangle[] rects;
    protected Insets contentBorderInsets;
    protected Insets selectedTabPadInsets;
    protected Insets tabAreaInsets;
    protected Insets tabInsets;
    protected Color darkShadow;
    protected Color focus;
    protected Color highlight;
    protected Color lightHighlight;
    protected Color shadow;
    protected int maxTabHeight;
    protected int maxTabWidth;
    protected int runCount;
    protected int selectedRun;
    protected int tabRunOverlay;
    protected int textIconGap;
    protected int[] tabRuns;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke upKey;
    protected FocusListener focusListener;
    protected MouseListener mouseListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ChangeListener tabChangeListener;
    protected JTabbedPane tabPane;
    transient LayoutManager layoutManager;
    transient Rectangle tabAreaRect;
    transient Rectangle contentRect;

    ScrollingButton createIncreaseButton() {
        if (this.incrButton == null) {
            this.incrButton = new ScrollingButton(1);
        }
        if (this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3) {
            this.incrButton.setDirection(3);
        } else {
            this.incrButton.setDirection(5);
        }
        return this.incrButton;
    }

    ScrollingButton createDecreaseButton() {
        if (this.decrButton == null) {
            this.decrButton = new ScrollingButton(5);
        }
        if (this.tabPane.getTabPlacement() == 1 || this.tabPane.getTabPlacement() == 3) {
            this.decrButton.setDirection(7);
        } else {
            this.decrButton.setDirection(1);
        }
        return this.decrButton;
    }

    Point findPointForIndex(int index) {
        int tabPlacement = this.tabPane.getTabPlacement();
        int selectedIndex = this.tabPane.getSelectedIndex();
        Insets insets = this.getSelectedTabPadInsets(tabPlacement);
        int w = 0;
        int h = 0;
        if (tabPlacement == 1 || tabPlacement == 3) {
            if (index > 0) {
                w += this.rects[index - 1].x + this.rects[index - 1].width;
                if (index > selectedIndex) {
                    w -= insets.left + insets.right;
                }
            }
        } else if (index > 0) {
            h += this.rects[index - 1].y + this.rects[index - 1].height;
            if (index > selectedIndex) {
                h -= insets.top + insets.bottom;
            }
        }
        Point p = new Point(w, h);
        return p;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicTabbedPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JTabbedPane) {
            this.tabPane = (JTabbedPane)c;
            this.installComponents();
            this.installDefaults();
            this.installListeners();
            this.installKeyboardActions();
            this.layoutManager = this.createLayoutManager();
            this.tabPane.setLayout(this.layoutManager);
            this.tabPane.layout();
        }
    }

    public void uninstallUI(JComponent c) {
        this.layoutManager = null;
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.tabPane = null;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            return new TabbedPaneLayout();
        }
        this.incrButton = this.createIncreaseButton();
        this.decrButton = this.createDecreaseButton();
        this.viewport = new ScrollingViewport();
        this.viewport.setLayout(null);
        this.panel = new ScrollingPanel();
        this.viewport.setView(this.panel);
        this.tabPane.add(this.incrButton);
        this.tabPane.add(this.decrButton);
        this.tabPane.add(this.viewport);
        this.currentScrollLocation = 0;
        this.decrButton.setEnabled(false);
        this.panel.addMouseListener(this.mouseListener);
        this.incrButton.addMouseListener(this.mouseListener);
        this.decrButton.addMouseListener(this.mouseListener);
        this.viewport.setBackground(Color.LIGHT_GRAY);
        return new TabbedPaneScrollLayout();
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tabPane, "TabbedPane.background", "TabbedPane.foreground", "TabbedPane.font");
        this.tabPane.setOpaque(false);
        this.highlight = UIManager.getColor("TabbedPane.highlight");
        this.lightHighlight = UIManager.getColor("TabbedPane.lightHighlight");
        this.shadow = UIManager.getColor("TabbedPane.shadow");
        this.darkShadow = UIManager.getColor("TabbedPane.darkShadow");
        this.focus = UIManager.getColor("TabbedPane.focus");
        this.textIconGap = UIManager.getInt("TabbedPane.textIconGap");
        this.tabRunOverlay = UIManager.getInt("TabbedPane.tabRunOverlay");
        this.tabInsets = UIManager.getInsets("TabbedPane.tabbedPaneTabInsets");
        this.selectedTabPadInsets = UIManager.getInsets("TabbedPane.tabbedPaneTabPadInsets");
        this.tabAreaInsets = UIManager.getInsets("TabbedPane.tabbedPaneTabAreaInsets");
        this.contentBorderInsets = UIManager.getInsets("TabbedPane.tabbedPaneContentBorderInsets");
        this.calcRect = new Rectangle();
        this.tabRuns = new int[10];
        this.tabAreaRect = new Rectangle();
        this.contentRect = new Rectangle();
    }

    protected void uninstallDefaults() {
        this.calcRect = null;
        this.tabAreaRect = null;
        this.contentRect = null;
        this.tabRuns = null;
        this.contentBorderInsets = null;
        this.tabAreaInsets = null;
        this.selectedTabPadInsets = null;
        this.tabInsets = null;
        this.focus = null;
        this.darkShadow = null;
        this.shadow = null;
        this.lightHighlight = null;
        this.highlight = null;
        this.tabPane.setBackground(null);
        this.tabPane.setForeground(null);
        this.tabPane.setFont(null);
    }

    protected void installListeners() {
        this.mouseListener = this.createMouseListener();
        this.tabChangeListener = this.createChangeListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.focusListener = this.createFocusListener();
        this.tabPane.addMouseListener(this.mouseListener);
        this.tabPane.addChangeListener(this.tabChangeListener);
        this.tabPane.addPropertyChangeListener(this.propertyChangeListener);
        this.tabPane.addFocusListener(this.focusListener);
    }

    protected void uninstallListeners() {
        this.tabPane.removeFocusListener(this.focusListener);
        this.tabPane.removePropertyChangeListener(this.propertyChangeListener);
        this.tabPane.removeChangeListener(this.tabChangeListener);
        this.tabPane.removeMouseListener(this.mouseListener);
        this.focusListener = null;
        this.propertyChangeListener = null;
        this.tabChangeListener = null;
        this.mouseListener = null;
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ChangeListener createChangeListener() {
        return new TabSelectionHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.layoutManager.minimumLayoutSize(this.tabPane);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public void paint(Graphics g, JComponent c) {
        if (this.tabPane.getTabCount() == 0) {
            return;
        }
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            this.paintTabArea(g, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex());
        }
        this.paintContentBorder(g, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex());
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        Rectangle ir = new Rectangle();
        Rectangle tr = new Rectangle();
        boolean bl = false;
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            bl = true;
        }
        boolean isScroll = bl;
        int tabCount = this.tabPane.getTabCount();
        int currRun = 1;
        if (tabCount > this.runCount) {
            this.runCount = tabCount;
        }
        if (tabCount < 1) {
            return;
        }
        if (this.runCount > 1) {
            currRun = 0;
        }
        int i = 0;
        while (i < this.runCount) {
            int first = this.lastTabInRun(tabCount, this.getPreviousTabRun(currRun)) + 1;
            if (isScroll) {
                first = this.currentScrollLocation;
            } else if (first == tabCount) {
                first = 0;
            }
            int last = this.lastTabInRun(tabCount, currRun);
            if (isScroll) {
                int k = first;
                while (k < tabCount) {
                    if (this.rects[k].x + this.rects[k].width - this.rects[first].x > this.viewport.getWidth()) {
                        last = k;
                        break;
                    }
                    ++k;
                }
            }
            int j = first;
            while (j <= last) {
                if (j != selectedIndex || isScroll) {
                    this.paintTab(g, tabPlacement, this.rects, j, ir, tr);
                }
                ++j;
            }
            currRun = this.getPreviousTabRun(currRun);
            ++i;
        }
        if (!isScroll) {
            this.paintTab(g, tabPlacement, this.rects, selectedIndex, ir, tr);
        }
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        FontMetrics fm = this.getFontMetrics();
        Icon icon = this.getIconForTab(tabIndex);
        String title = this.tabPane.getTitleAt(tabIndex);
        boolean bl = false;
        if (tabIndex == this.tabPane.getSelectedIndex()) {
            bl = true;
        }
        boolean isSelected = bl;
        this.calcRect = this.getTabBounds(this.tabPane, tabIndex);
        int x = this.calcRect.x;
        int y = this.calcRect.y;
        int w = this.calcRect.width;
        int h = this.calcRect.height;
        if (this.getRunForTab(this.tabPane.getTabCount(), tabIndex) == 1) {
            Insets insets = this.getTabAreaInsets(tabPlacement);
            switch (tabPlacement) {
                case 1: {
                    h += insets.bottom;
                    break;
                }
                case 2: {
                    w += insets.right;
                    break;
                }
                case 3: {
                    y -= insets.top;
                    h += insets.top;
                    break;
                }
                case 4: {
                    x -= insets.left;
                    w += insets.left;
                    break;
                }
            }
        }
        this.layoutLabel(tabPlacement, fm, tabIndex, title, icon, this.calcRect, iconRect, textRect, isSelected);
        this.paintTabBackground(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        this.paintTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        if (icon != null) {
            this.paintIcon(g, tabPlacement, tabIndex, icon, iconRect, isSelected);
        }
        if (title != null && !title.equals("")) {
            this.paintText(g, tabPlacement, this.tabPane.getFont(), fm, tabIndex, title, textRect, isSelected);
        }
    }

    protected void layoutLabel(int tabPlacement, FontMetrics metrics, int tabIndex, String title, Icon icon, Rectangle tabRect, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        SwingUtilities.layoutCompoundLabel(metrics, title, icon, 0, 0, 0, 4, tabRect, iconRect, textRect, this.textIconGap);
        int shiftX = this.getTabLabelShiftX(tabPlacement, tabIndex, isSelected);
        int shiftY = this.getTabLabelShiftY(tabPlacement, tabIndex, isSelected);
        iconRect.x += shiftX;
        iconRect.y += shiftY;
        textRect.x += shiftX;
        textRect.y += shiftY;
    }

    protected void paintIcon(Graphics g, int tabPlacement, int tabIndex, Icon icon, Rectangle iconRect, boolean isSelected) {
        icon.paintIcon(this.tabPane, g, iconRect.x, iconRect.y);
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Color bg;
        View textView = this.getTextViewForTab(tabIndex);
        if (textView != null) {
            textView.paint(g, textRect);
            return;
        }
        Color fg = this.tabPane.getForegroundAt(tabIndex);
        if (fg == null) {
            fg = this.tabPane.getForeground();
        }
        if ((bg = this.tabPane.getBackgroundAt(tabIndex)) == null) {
            bg = this.tabPane.getBackground();
        }
        Color saved_color = g.getColor();
        Font f = g.getFont();
        g.setFont(font);
        if (this.tabPane.isEnabledAt(tabIndex)) {
            g.setColor(fg);
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (mnemIndex != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g.drawString(title, textRect.x, textRect.y + metrics.getAscent());
            }
        } else {
            g.setColor(bg.brighter());
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (mnemIndex != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y);
            } else {
                g.drawString(title, textRect.x, textRect.y);
            }
            g.setColor(bg.darker());
            if (mnemIndex != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x + 1, textRect.y + 1);
            } else {
                g.drawString(title, textRect.x + 1, textRect.y + 1);
            }
        }
        g.setColor(saved_color);
        g.setFont(f);
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        Color saved = g.getColor();
        this.calcRect = iconRect.union(textRect);
        g.setColor(this.focus);
        g.drawRect(this.calcRect.x, this.calcRect.y, this.calcRect.width, this.calcRect.height);
        g.setColor(saved);
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Color saved = g.getColor();
        if (!isSelected || tabPlacement != 1) {
            g.setColor(this.shadow);
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h, x + w, y + h);
        }
        if (!isSelected || tabPlacement != 2) {
            g.setColor(this.darkShadow);
            g.drawLine(x + w, y, x + w, y + h);
            g.setColor(this.shadow);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
        }
        if (!isSelected || tabPlacement != 4) {
            g.setColor(this.lightHighlight);
            g.drawLine(x, y, x, y + h);
        }
        if (!isSelected || tabPlacement != 3) {
            g.setColor(this.lightHighlight);
            g.drawLine(x, y, x + w, y);
        }
        g.setColor(saved);
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        Color saved = g.getColor();
        if (isSelected) {
            g.setColor(Color.LIGHT_GRAY);
        } else {
            Color bg = this.tabPane.getBackgroundAt(tabIndex);
            if (bg == null) {
                bg = Color.GRAY;
            }
            g.setColor(bg);
        }
        g.fillRect(x, y, w, h);
        g.setColor(saved);
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        Insets insets = this.getContentBorderInsets(tabPlacement);
        int x = this.contentRect.x;
        int y = this.contentRect.y;
        int w = this.contentRect.width;
        int h = this.contentRect.height;
        this.paintContentBorderTopEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderLeftEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderBottomEdge(g, tabPlacement, selectedIndex, x, y, w, h);
        this.paintContentBorderRightEdge(g, tabPlacement, selectedIndex, x, y, w, h);
    }

    protected void paintContentBorderTopEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Color saved = g.getColor();
        g.setColor(this.lightHighlight);
        int startgap = this.rects[selectedIndex].x;
        int endgap = this.rects[selectedIndex].x + this.rects[selectedIndex].width;
        int diff = 0;
        if (tabPlacement == 1) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                Point p = this.findPointForIndex(this.currentScrollLocation);
                diff = p.x;
            }
            g.drawLine(x, y, startgap - diff, y);
            g.drawLine(endgap - diff, y, x + w, y);
        } else {
            g.drawLine(x, y, x + w, y);
        }
        g.setColor(saved);
    }

    protected void paintContentBorderLeftEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Color saved = g.getColor();
        g.setColor(this.lightHighlight);
        int startgap = this.rects[selectedIndex].y;
        int endgap = this.rects[selectedIndex].y + this.rects[selectedIndex].height;
        int diff = 0;
        if (tabPlacement == 2) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                Point p = this.findPointForIndex(this.currentScrollLocation);
                diff = p.y;
            }
            g.drawLine(x, y, x, startgap - diff);
            g.drawLine(x, endgap - diff, x, y + h);
        } else {
            g.drawLine(x, y, x, y + h);
        }
        g.setColor(saved);
    }

    protected void paintContentBorderBottomEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Color saved = g.getColor();
        int startgap = this.rects[selectedIndex].x;
        int endgap = this.rects[selectedIndex].x + this.rects[selectedIndex].width;
        int diff = 0;
        if (tabPlacement == 3) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                Point p = this.findPointForIndex(this.currentScrollLocation);
                diff = p.x;
            }
            g.setColor(this.shadow);
            g.drawLine(x + 1, y + h - 1, startgap - diff, y + h - 1);
            g.drawLine(endgap - diff, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h, startgap - diff, y + h);
            g.drawLine(endgap - diff, y + h, x + w, y + h);
        } else {
            g.setColor(this.shadow);
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(this.darkShadow);
            g.drawLine(x, y + h, x + w, y + h);
        }
        g.setColor(saved);
    }

    protected void paintContentBorderRightEdge(Graphics g, int tabPlacement, int selectedIndex, int x, int y, int w, int h) {
        Color saved = g.getColor();
        int startgap = this.rects[selectedIndex].y;
        int endgap = this.rects[selectedIndex].y + this.rects[selectedIndex].height;
        int diff = 0;
        if (tabPlacement == 4) {
            if (this.tabPane.getTabLayoutPolicy() == 1) {
                Point p = this.findPointForIndex(this.currentScrollLocation);
                diff = p.y;
            }
            g.setColor(this.shadow);
            g.drawLine(x + w - 1, y + 1, x + w - 1, startgap - diff);
            g.drawLine(x + w - 1, endgap - diff, x + w - 1, y + h - 1);
            g.setColor(this.darkShadow);
            g.drawLine(x + w, y, x + w, startgap - diff);
            g.drawLine(x + w, endgap - diff, x + w, y + h);
        } else {
            g.setColor(this.shadow);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
            g.setColor(this.darkShadow);
            g.drawLine(x + w, y, x + w, y + h);
        }
        g.setColor(saved);
    }

    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        return this.rects[i];
    }

    public int getTabRunCount(JTabbedPane pane) {
        return this.runCount;
    }

    public int tabForCoordinate(JTabbedPane pane, int x, int y) {
        Point p = new Point(x, y);
        int tabCount = this.tabPane.getTabCount();
        int currRun = 1;
        int i = 0;
        while (i < this.runCount) {
            int first = this.lastTabInRun(tabCount, this.getPreviousTabRun(currRun)) + 1;
            if (first == tabCount) {
                first = 0;
            }
            int last = this.lastTabInRun(tabCount, currRun);
            int j = first;
            while (j <= last) {
                if (this.getTabBounds(pane, j).contains(p)) {
                    return j;
                }
                ++j;
            }
            currRun = this.getNextTabRun(currRun);
            ++i;
        }
        return -1;
    }

    protected Rectangle getTabBounds(int tabIndex, Rectangle dest) {
        dest.setBounds(this.getTabBounds(this.tabPane, tabIndex));
        return dest;
    }

    protected Component getVisibleComponent() {
        return this.tabPane.getComponentAt(this.tabPane.getSelectedIndex());
    }

    protected void setVisibleComponent(Component component) {
        component.setVisible(true);
        this.tabPane.setSelectedComponent(component);
    }

    protected void assureRectsCreated(int tabCount) {
        if (this.rects == null) {
            this.rects = new Rectangle[tabCount];
        }
        if (tabCount == this.rects.length) {
            return;
        }
        int numToCopy = Math.min(tabCount, this.rects.length);
        Rectangle[] tmp = new Rectangle[tabCount];
        System.arraycopy(this.rects, 0, tmp, 0, numToCopy);
        this.rects = tmp;
    }

    protected void expandTabRunsArray() {
        if (this.tabRuns == null) {
            this.tabRuns = new int[10];
        } else {
            int[] newRuns = new int[this.tabRuns.length + 10];
            System.arraycopy(this.tabRuns, 0, newRuns, 0, this.tabRuns.length);
            this.tabRuns = newRuns;
        }
    }

    protected int getRunForTab(int tabCount, int tabIndex) {
        if (this.runCount == 1 && tabIndex < tabCount && tabIndex >= 0) {
            return 1;
        }
        int i = 0;
        while (i < this.runCount) {
            int last;
            int first = this.lastTabInRun(tabCount, this.getPreviousTabRun(i)) + 1;
            if (first == tabCount) {
                first = 0;
            }
            if ((last = this.lastTabInRun(tabCount, i)) >= tabIndex && first <= tabIndex) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int lastTabInRun(int tabCount, int run) {
        if (this.tabRuns[run] == 0) {
            return tabCount - 1;
        }
        return this.tabRuns[run] - 1;
    }

    protected int getTabRunOverlay(int tabPlacement) {
        return this.tabRunOverlay;
    }

    protected int getTabRunIndent(int tabPlacement, int run) {
        return 0;
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return true;
    }

    protected boolean shouldRotateTabRuns(int tabPlacement) {
        return true;
    }

    protected Icon getIconForTab(int tabIndex) {
        if (this.tabPane.isEnabledAt(tabIndex)) {
            return this.tabPane.getIconAt(tabIndex);
        }
        return this.tabPane.getDisabledIconAt(tabIndex);
    }

    protected View getTextViewForTab(int tabIndex) {
        return null;
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        Icon icon = this.getIconForTab(tabIndex);
        Insets insets = this.getTabInsets(tabPlacement, tabIndex);
        int height = 0;
        if (icon != null) {
            Rectangle vr = new Rectangle();
            Rectangle ir = new Rectangle();
            Rectangle tr = new Rectangle();
            FontMetrics fontMetrics = this.getFontMetrics();
            String string = this.tabPane.getTitleAt(tabIndex);
            boolean bl = false;
            if (tabIndex == this.tabPane.getSelectedIndex()) {
                bl = true;
            }
            this.layoutLabel(tabPlacement, fontMetrics, tabIndex, string, icon, vr, ir, tr, bl);
            height = tr.union((Rectangle)ir).height;
        } else {
            height = fontHeight;
        }
        return height += insets.top + insets.bottom;
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        this.maxTabHeight = 0;
        FontMetrics fm = this.getFontMetrics();
        int fontHeight = fm.getHeight();
        int i = 0;
        while (i < this.tabPane.getTabCount()) {
            this.maxTabHeight = Math.max(this.calculateTabHeight(tabPlacement, i, fontHeight), this.maxTabHeight);
            ++i;
        }
        return this.maxTabHeight;
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        Icon icon = this.getIconForTab(tabIndex);
        Insets insets = this.getTabInsets(tabPlacement, tabIndex);
        int width = 0;
        if (icon != null) {
            Rectangle vr = new Rectangle();
            Rectangle ir = new Rectangle();
            Rectangle tr = new Rectangle();
            FontMetrics fontMetrics = this.getFontMetrics();
            String string = this.tabPane.getTitleAt(tabIndex);
            boolean bl = false;
            if (tabIndex == this.tabPane.getSelectedIndex()) {
                bl = true;
            }
            this.layoutLabel(tabPlacement, fontMetrics, tabIndex, string, icon, vr, ir, tr, bl);
            width = tr.union((Rectangle)ir).width;
        } else {
            width = metrics.stringWidth(this.tabPane.getTitleAt(tabIndex));
        }
        return width += insets.left + insets.right;
    }

    protected int calculateMaxTabWidth(int tabPlacement) {
        this.maxTabWidth = 0;
        FontMetrics fm = this.getFontMetrics();
        int i = 0;
        while (i < this.tabPane.getTabCount()) {
            this.maxTabWidth = Math.max(this.calculateTabWidth(tabPlacement, i, fm), this.maxTabWidth);
            ++i;
        }
        return this.maxTabWidth;
    }

    protected int calculateTabAreaHeight(int tabPlacement, int horizRunCount, int maxTabHeight) {
        Insets insets = this.getTabAreaInsets(tabPlacement);
        int tabAreaHeight = horizRunCount * maxTabHeight - (horizRunCount - 1) * this.tabRunOverlay;
        return tabAreaHeight += insets.top + insets.bottom;
    }

    protected int calculateTabAreaWidth(int tabPlacement, int vertRunCount, int maxTabWidth) {
        Insets insets = this.getTabAreaInsets(tabPlacement);
        int tabAreaWidth = vertRunCount * maxTabWidth - (vertRunCount - 1) * this.tabRunOverlay;
        return tabAreaWidth += insets.left + insets.right;
    }

    protected Insets getTabInsets(int tabPlacement, int tabIndex) {
        Insets target = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.tabInsets, target, tabPlacement);
        return target;
    }

    protected Insets getSelectedTabPadInsets(int tabPlacement) {
        Insets target = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.selectedTabPadInsets, target, tabPlacement);
        return target;
    }

    protected Insets getTabAreaInsets(int tabPlacement) {
        Insets target = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.tabAreaInsets, target, tabPlacement);
        return target;
    }

    protected Insets getContentBorderInsets(int tabPlacement) {
        Insets target = new Insets(0, 0, 0, 0);
        BasicTabbedPaneUI.rotateInsets(this.contentBorderInsets, target, tabPlacement);
        return target;
    }

    protected FontMetrics getFontMetrics() {
        FontMetrics fm = this.tabPane.getToolkit().getFontMetrics(this.tabPane.getFont());
        return fm;
    }

    protected void navigateSelectedTab(int direction) {
        int offset;
        int tabPlacement = this.tabPane.getTabPlacement();
        if (tabPlacement == 1 || tabPlacement == 3) {
            if (direction == 7) {
                this.selectPreviousTabInRun(this.tabPane.getSelectedIndex());
            } else if (direction == 3) {
                this.selectNextTabInRun(this.tabPane.getSelectedIndex());
            } else {
                int n = this.tabPane.getTabCount();
                int n2 = this.tabPane.getSelectedIndex();
                boolean bl = false;
                if (tabPlacement == 4) {
                    bl = true;
                }
                offset = this.getTabRunOffset(tabPlacement, n, n2, bl);
                this.selectAdjacentRunTab(tabPlacement, this.tabPane.getSelectedIndex(), offset);
            }
        }
        if (tabPlacement == 2 || tabPlacement == 4) {
            if (direction == 1) {
                this.selectPreviousTabInRun(this.tabPane.getSelectedIndex());
            } else if (direction == 5) {
                this.selectNextTabInRun(this.tabPane.getSelectedIndex());
            } else {
                int n = this.tabPane.getTabCount();
                int n3 = this.tabPane.getSelectedIndex();
                boolean bl = false;
                if (tabPlacement == 4) {
                    bl = true;
                }
                offset = this.getTabRunOffset(tabPlacement, n, n3, bl);
                this.selectAdjacentRunTab(tabPlacement, this.tabPane.getSelectedIndex(), offset);
            }
        }
    }

    protected void selectNextTabInRun(int current) {
        this.tabPane.setSelectedIndex(this.getNextTabIndexInRun(this.tabPane.getTabCount(), current));
    }

    protected void selectPreviousTabInRun(int current) {
        this.tabPane.setSelectedIndex(this.getPreviousTabIndexInRun(this.tabPane.getTabCount(), current));
    }

    protected void selectNextTab(int current) {
        this.tabPane.setSelectedIndex(this.getNextTabIndex(current));
    }

    protected void selectPreviousTab(int current) {
        this.tabPane.setSelectedIndex(this.getPreviousTabIndex(current));
    }

    protected void selectAdjacentRunTab(int tabPlacement, int tabIndex, int offset) {
        int x = this.rects[tabIndex].x + this.rects[tabIndex].width / 2;
        int y = this.rects[tabIndex].y + this.rects[tabIndex].height / 2;
        switch (tabPlacement) {
            case 1: 
            case 3: {
                y += offset;
                break;
            }
            case 2: 
            case 4: {
                x += offset;
                break;
            }
        }
        int index = this.tabForCoordinate(this.tabPane, x, y);
        if (index != -1) {
            this.tabPane.setSelectedIndex(index);
        }
    }

    protected int getTabRunOffset(int tabPlacement, int tabCount, int tabIndex, boolean forward) {
        int currRun = this.getRunForTab(tabCount, tabIndex);
        int nextRun = forward ? this.getNextTabRun(currRun) : this.getPreviousTabRun(currRun);
        int offset = tabPlacement == 1 || tabPlacement == 3 ? this.rects[this.lastTabInRun((int)tabCount, (int)nextRun)].y - this.rects[this.lastTabInRun((int)tabCount, (int)currRun)].y : this.rects[this.lastTabInRun((int)tabCount, (int)nextRun)].x - this.rects[this.lastTabInRun((int)tabCount, (int)currRun)].x;
        return offset;
    }

    protected int getPreviousTabIndex(int base) {
        if (--base < 0) {
            return this.tabPane.getTabCount() - 1;
        }
        return base;
    }

    protected int getNextTabIndex(int base) {
        if (++base == this.tabPane.getTabCount()) {
            return 0;
        }
        return base;
    }

    protected int getNextTabIndexInRun(int tabCount, int base) {
        int run;
        int index = this.getNextTabIndex(base);
        if (index == this.lastTabInRun(tabCount, run = this.getRunForTab(tabCount, base)) + 1) {
            index = this.lastTabInRun(tabCount, this.getPreviousTabRun(run)) + 1;
        }
        return this.getNextTabIndex(base);
    }

    protected int getPreviousTabIndexInRun(int tabCount, int base) {
        int run;
        int index = this.getPreviousTabIndex(base);
        if (index == this.lastTabInRun(tabCount, this.getPreviousTabRun(run = this.getRunForTab(tabCount, base)))) {
            index = this.lastTabInRun(tabCount, run);
        }
        return this.getPreviousTabIndex(base);
    }

    protected int getPreviousTabRun(int baseRun) {
        int prevRun;
        if (this.getTabRunCount(this.tabPane) == 1) {
            return 1;
        }
        if ((prevRun = --baseRun) < 0) {
            prevRun = this.getTabRunCount(this.tabPane) - 1;
        }
        return prevRun;
    }

    protected int getNextTabRun(int baseRun) {
        int nextRun;
        if (this.getTabRunCount(this.tabPane) == 1) {
            return 1;
        }
        if ((nextRun = ++baseRun) == this.getTabRunCount(this.tabPane)) {
            nextRun = 0;
        }
        return nextRun;
    }

    protected static void rotateInsets(Insets topInsets, Insets targetInsets, int targetPlacement) {
        switch (targetPlacement) {
            case 1: {
                targetInsets.top = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.right = topInsets.right;
                targetInsets.bottom = topInsets.bottom;
                break;
            }
            case 2: {
                targetInsets.left = topInsets.top;
                targetInsets.top = topInsets.left;
                targetInsets.right = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                break;
            }
            case 3: {
                targetInsets.top = topInsets.bottom;
                targetInsets.bottom = topInsets.top;
                targetInsets.left = topInsets.left;
                targetInsets.right = topInsets.right;
                break;
            }
            case 4: {
                targetInsets.top = topInsets.left;
                targetInsets.left = topInsets.bottom;
                targetInsets.bottom = topInsets.right;
                targetInsets.right = topInsets.top;
                break;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ScrollingButton
    extends BasicArrowButton
    implements UIResource {
        public ScrollingButton(int dir) {
            super(dir);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TabbedPaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component comp) {
        }

        public void calculateLayoutInfo() {
            this.calculateTabRects(BasicTabbedPaneUI.this.tabPane.getTabPlacement(), BasicTabbedPaneUI.this.tabPane.getTabCount());
            if (BasicTabbedPaneUI.this.tabPane.getSelectedIndex() != -1) {
                Component visible = BasicTabbedPaneUI.this.getVisibleComponent();
                Insets insets = BasicTabbedPaneUI.this.getContentBorderInsets(BasicTabbedPaneUI.this.tabPane.getTabPlacement());
                if (visible != null) {
                    visible.setBounds(BasicTabbedPaneUI.this.contentRect.x + insets.left, BasicTabbedPaneUI.this.contentRect.y + insets.top, BasicTabbedPaneUI.this.contentRect.width - insets.left - insets.right, BasicTabbedPaneUI.this.contentRect.height - insets.top - insets.bottom);
                }
            }
        }

        protected Dimension calculateSize(boolean minimum) {
            int tabPlacement = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            int width = 0;
            int height = 0;
            int componentHeight = 0;
            int componentWidth = 0;
            int i = 0;
            while (i < BasicTabbedPaneUI.this.tabPane.getTabCount()) {
                Component c = BasicTabbedPaneUI.this.tabPane.getComponentAt(i);
                if (c != null) {
                    BasicTabbedPaneUI.this.calcRect = c.getBounds();
                    Dimension dims = c.getPreferredSize();
                    if (dims != null) {
                        componentHeight = Math.max(componentHeight, dims.height);
                        componentWidth = Math.max(componentWidth, dims.width);
                    }
                }
                ++i;
            }
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            if (tabPlacement == 1 || tabPlacement == 3) {
                int min = BasicTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                width = Math.max(min, componentWidth);
                int tabAreaHeight = this.preferredTabAreaHeight(tabPlacement, width);
                height = tabAreaHeight + componentHeight;
            } else {
                int min = BasicTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                height = Math.max(min, componentHeight);
                int tabAreaWidth = this.preferredTabAreaWidth(tabPlacement, height);
                width = tabAreaWidth + componentWidth;
            }
            return new Dimension(width, height);
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            if (tabCount == 0) {
                return;
            }
            BasicTabbedPaneUI.this.assureRectsCreated(tabCount);
            FontMetrics fm = BasicTabbedPaneUI.this.getFontMetrics();
            SwingUtilities.calculateInnerArea(BasicTabbedPaneUI.this.tabPane, BasicTabbedPaneUI.this.calcRect);
            Insets tabAreaInsets = BasicTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int max = 0;
            int runs = 0;
            int start = BasicTabbedPaneUI.this.getTabRunIndent(tabPlacement, 1);
            if (tabPlacement == 1 || tabPlacement == 3) {
                int maxHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                BasicTabbedPaneUI.this.calcRect.width -= tabAreaInsets.left + tabAreaInsets.right;
                max = BasicTabbedPaneUI.this.calcRect.width + tabAreaInsets.left + insets.left;
                int width = 0;
                int runWidth = start += tabAreaInsets.left + insets.left;
                int i = 0;
                while (i < tabCount) {
                    width = BasicTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, fm);
                    if (runWidth + width > max) {
                        runWidth = tabAreaInsets.left + insets.left + BasicTabbedPaneUI.this.getTabRunIndent(tabPlacement, ++runs);
                        BasicTabbedPaneUI.this.rects[i] = new Rectangle(runWidth, insets.top + tabAreaInsets.top, width, maxHeight);
                        runWidth += width;
                        if (runs > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[runs] = i;
                    } else {
                        BasicTabbedPaneUI.this.rects[i] = new Rectangle(runWidth, insets.top + tabAreaInsets.top, width, maxHeight);
                        runWidth += width;
                    }
                    ++i;
                }
                BasicTabbedPaneUI.this.tabAreaRect.width = BasicTabbedPaneUI.this.tabPane.getWidth() - insets.left - insets.right;
                BasicTabbedPaneUI.this.tabAreaRect.height = ++runs * BasicTabbedPaneUI.this.maxTabHeight - (runs - 1) * BasicTabbedPaneUI.this.tabRunOverlay + tabAreaInsets.top + tabAreaInsets.bottom;
                BasicTabbedPaneUI.this.contentRect.width = BasicTabbedPaneUI.this.tabAreaRect.width;
                BasicTabbedPaneUI.this.contentRect.height = BasicTabbedPaneUI.this.tabPane.getHeight() - insets.top - insets.bottom - BasicTabbedPaneUI.this.tabAreaRect.height;
                BasicTabbedPaneUI.this.contentRect.x = insets.left;
                BasicTabbedPaneUI.this.tabAreaRect.x = insets.left;
                if (tabPlacement == 3) {
                    BasicTabbedPaneUI.this.contentRect.y = insets.top;
                    BasicTabbedPaneUI.this.tabAreaRect.y = BasicTabbedPaneUI.this.contentRect.y + BasicTabbedPaneUI.this.contentRect.height;
                } else {
                    BasicTabbedPaneUI.this.tabAreaRect.y = insets.top;
                    BasicTabbedPaneUI.this.contentRect.y = BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height;
                }
            } else {
                int maxWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                BasicTabbedPaneUI.this.calcRect.height -= tabAreaInsets.top + tabAreaInsets.bottom;
                max = BasicTabbedPaneUI.this.calcRect.height + tabAreaInsets.top + insets.top;
                int height = 0;
                int runHeight = start += tabAreaInsets.top + insets.top;
                int fontHeight = fm.getHeight();
                int i = 0;
                while (i < tabCount) {
                    height = BasicTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    if (runHeight + height > max) {
                        runHeight = tabAreaInsets.top + insets.top + BasicTabbedPaneUI.this.getTabRunIndent(tabPlacement, ++runs);
                        BasicTabbedPaneUI.this.rects[i] = new Rectangle(insets.left + tabAreaInsets.left, runHeight, maxWidth, height);
                        runHeight += height;
                        if (runs > BasicTabbedPaneUI.this.tabRuns.length - 1) {
                            BasicTabbedPaneUI.this.expandTabRunsArray();
                        }
                        BasicTabbedPaneUI.this.tabRuns[runs] = i;
                    } else {
                        BasicTabbedPaneUI.this.rects[i] = new Rectangle(insets.left + tabAreaInsets.left, runHeight, maxWidth, height);
                        runHeight += height;
                    }
                    ++i;
                }
                BasicTabbedPaneUI.this.tabAreaRect.width = ++runs * BasicTabbedPaneUI.this.maxTabWidth - (runs - 1) * BasicTabbedPaneUI.this.tabRunOverlay + tabAreaInsets.left + tabAreaInsets.right;
                BasicTabbedPaneUI.this.tabAreaRect.height = BasicTabbedPaneUI.this.tabPane.getHeight() - insets.top - insets.bottom;
                BasicTabbedPaneUI.this.tabAreaRect.y = insets.top;
                BasicTabbedPaneUI.this.contentRect.width = BasicTabbedPaneUI.this.tabPane.getWidth() - insets.left - insets.right - BasicTabbedPaneUI.this.tabAreaRect.width;
                BasicTabbedPaneUI.this.contentRect.height = BasicTabbedPaneUI.this.tabAreaRect.height;
                BasicTabbedPaneUI.this.contentRect.y = insets.top;
                if (tabPlacement == 2) {
                    BasicTabbedPaneUI.this.tabAreaRect.x = insets.left;
                    BasicTabbedPaneUI.this.contentRect.x = BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width;
                } else {
                    BasicTabbedPaneUI.this.contentRect.x = insets.left;
                    BasicTabbedPaneUI.this.tabAreaRect.x = BasicTabbedPaneUI.this.contentRect.x + BasicTabbedPaneUI.this.contentRect.width;
                }
            }
            BasicTabbedPaneUI.this.runCount = runs;
            BasicTabbedPaneUI.this.tabRuns[0] = 0;
            this.normalizeTabRuns(tabPlacement, tabCount, start, max);
            BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.getRunForTab(tabCount, BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
            if (BasicTabbedPaneUI.this.shouldRotateTabRuns(tabPlacement)) {
                this.rotateTabRuns(tabPlacement, BasicTabbedPaneUI.this.selectedRun);
            }
            int i = 0;
            while (i < BasicTabbedPaneUI.this.runCount) {
                int j;
                int adjustment;
                int j2;
                int first = BasicTabbedPaneUI.this.lastTabInRun(tabCount, BasicTabbedPaneUI.this.getPreviousTabRun(i)) + 1;
                if (first == tabCount) {
                    first = 0;
                }
                int last = BasicTabbedPaneUI.this.lastTabInRun(tabCount, i);
                if (BasicTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                    this.padTabRun(tabPlacement, first, last, max);
                }
                if (tabPlacement == 1 && i > 0) {
                    j2 = first;
                    while (j2 <= last) {
                        BasicTabbedPaneUI.this.rects[j2].y += (BasicTabbedPaneUI.this.runCount - i) * BasicTabbedPaneUI.this.maxTabHeight - (BasicTabbedPaneUI.this.runCount - i) * BasicTabbedPaneUI.this.tabRunOverlay;
                        ++j2;
                    }
                }
                if (tabPlacement == 3) {
                    int height = BasicTabbedPaneUI.this.tabPane.getBounds().height - insets.bottom - tabAreaInsets.bottom;
                    adjustment = i == 0 ? height - BasicTabbedPaneUI.this.maxTabHeight : height - (BasicTabbedPaneUI.this.runCount - i + 1) * BasicTabbedPaneUI.this.maxTabHeight - (BasicTabbedPaneUI.this.runCount - i) * BasicTabbedPaneUI.this.tabRunOverlay;
                    j = first;
                    while (j <= last) {
                        BasicTabbedPaneUI.this.rects[j].y = adjustment;
                        ++j;
                    }
                }
                if (tabPlacement == 2 && i > 0) {
                    j2 = first;
                    while (j2 <= last) {
                        BasicTabbedPaneUI.this.rects[j2].x += (BasicTabbedPaneUI.this.runCount - i) * BasicTabbedPaneUI.this.maxTabWidth - (BasicTabbedPaneUI.this.runCount - i) * BasicTabbedPaneUI.this.tabRunOverlay;
                        ++j2;
                    }
                }
                if (tabPlacement == 4) {
                    int width = BasicTabbedPaneUI.this.tabPane.getBounds().width - insets.right - tabAreaInsets.right;
                    adjustment = i == 0 ? width - BasicTabbedPaneUI.this.maxTabWidth : width - (BasicTabbedPaneUI.this.runCount - i + 1) * BasicTabbedPaneUI.this.maxTabWidth + (BasicTabbedPaneUI.this.runCount - i) * BasicTabbedPaneUI.this.tabRunOverlay;
                    j = first;
                    while (j <= last) {
                        BasicTabbedPaneUI.this.rects[j].x = adjustment;
                        ++j;
                    }
                }
                ++i;
            }
            this.padSelectedTab(tabPlacement, BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
        }

        public void layoutContainer(Container parent) {
            this.calculateLayoutInfo();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return this.calculateSize(false);
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            Insets tabAreaInsets = BasicTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            if (tabPlacement == 1 || tabPlacement == 3) {
                int i = 1;
                while (i < BasicTabbedPaneUI.this.runCount) {
                    Rectangle currRun = BasicTabbedPaneUI.this.rects[BasicTabbedPaneUI.this.lastTabInRun(tabCount, i)];
                    Rectangle nextRun = BasicTabbedPaneUI.this.rects[BasicTabbedPaneUI.this.lastTabInRun(tabCount, BasicTabbedPaneUI.this.getNextTabRun(i))];
                    int spaceInCurr = currRun.x + currRun.width;
                    int spaceInNext = nextRun.x + nextRun.width;
                    int diffNow = spaceInCurr - spaceInNext;
                    int diffLater = spaceInCurr - currRun.width - (spaceInNext + currRun.width);
                    while (Math.abs(diffLater) < Math.abs(diffNow) && spaceInNext + currRun.width < max) {
                        int n = i;
                        BasicTabbedPaneUI.this.tabRuns[n] = BasicTabbedPaneUI.this.tabRuns[n] - 1;
                        currRun = BasicTabbedPaneUI.this.rects[BasicTabbedPaneUI.this.lastTabInRun(tabCount, i)];
                        diffNow = (spaceInCurr -= currRun.width) - (spaceInNext += currRun.width);
                        diffLater = spaceInCurr - currRun.width - (spaceInNext + currRun.width);
                    }
                    int first = BasicTabbedPaneUI.this.lastTabInRun(tabCount, i) + 1;
                    int last = BasicTabbedPaneUI.this.lastTabInRun(tabCount, BasicTabbedPaneUI.this.getNextTabRun(i));
                    int currX = tabAreaInsets.left;
                    int j = first;
                    while (j <= last) {
                        BasicTabbedPaneUI.this.rects[j].x = currX;
                        currX += BasicTabbedPaneUI.this.rects[j].width;
                        ++j;
                    }
                    ++i;
                }
            } else {
                int i = 1;
                while (i < BasicTabbedPaneUI.this.runCount) {
                    Rectangle currRun = BasicTabbedPaneUI.this.rects[BasicTabbedPaneUI.this.lastTabInRun(tabCount, i)];
                    Rectangle nextRun = BasicTabbedPaneUI.this.rects[BasicTabbedPaneUI.this.lastTabInRun(tabCount, BasicTabbedPaneUI.this.getNextTabRun(i))];
                    int spaceInCurr = currRun.y + currRun.height;
                    int spaceInNext = nextRun.y + nextRun.height;
                    int diffNow = spaceInCurr - spaceInNext;
                    int diffLater = spaceInCurr - currRun.height - (spaceInNext + currRun.height);
                    while (Math.abs(diffLater) < Math.abs(diffNow) && spaceInNext + currRun.height < max) {
                        int n = i;
                        BasicTabbedPaneUI.this.tabRuns[n] = BasicTabbedPaneUI.this.tabRuns[n] - 1;
                        currRun = BasicTabbedPaneUI.this.rects[BasicTabbedPaneUI.this.lastTabInRun(tabCount, i)];
                        diffNow = (spaceInCurr -= currRun.height) - (spaceInNext += currRun.height);
                        diffLater = spaceInCurr - currRun.height - (spaceInNext + currRun.height);
                    }
                    int first = BasicTabbedPaneUI.this.lastTabInRun(tabCount, i) + 1;
                    int last = BasicTabbedPaneUI.this.lastTabInRun(tabCount, BasicTabbedPaneUI.this.getNextTabRun(i));
                    int currY = tabAreaInsets.top;
                    int j = first;
                    while (j <= last) {
                        BasicTabbedPaneUI.this.rects[j].y = currY;
                        currY += BasicTabbedPaneUI.this.rects[j].height;
                        ++j;
                    }
                    ++i;
                }
            }
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
            Insets insets = BasicTabbedPaneUI.this.getSelectedTabPadInsets(tabPlacement);
            BasicTabbedPaneUI.this.rects[selectedIndex].x -= insets.left;
            BasicTabbedPaneUI.this.rects[selectedIndex].y -= insets.top;
            BasicTabbedPaneUI.this.rects[selectedIndex].width += insets.left + insets.right;
            BasicTabbedPaneUI.this.rects[selectedIndex].height += insets.top + insets.bottom;
        }

        protected void padTabRun(int tabPlacement, int start, int end, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                int runWidth = BasicTabbedPaneUI.this.rects[end].x + BasicTabbedPaneUI.this.rects[end].width;
                int spaceRemaining = max - runWidth;
                int numTabs = end - start + 1;
                int spaceAllocated = spaceRemaining / numTabs;
                int currX = BasicTabbedPaneUI.this.rects[start].x;
                int i = start;
                while (i <= end) {
                    BasicTabbedPaneUI.this.rects[i].x = currX;
                    BasicTabbedPaneUI.this.rects[i].width += spaceAllocated;
                    currX += BasicTabbedPaneUI.this.rects[i].width;
                    if (i == end && BasicTabbedPaneUI.this.rects[i].x + BasicTabbedPaneUI.this.rects[i].width != max) {
                        BasicTabbedPaneUI.this.rects[i].width = max - BasicTabbedPaneUI.this.rects[i].x;
                    }
                    ++i;
                }
            } else {
                int runHeight = BasicTabbedPaneUI.this.rects[end].y + BasicTabbedPaneUI.this.rects[end].height;
                int spaceRemaining = max - runHeight;
                int numTabs = end - start + 1;
                int spaceAllocated = spaceRemaining / numTabs;
                int currY = BasicTabbedPaneUI.this.rects[start].y;
                int i = start;
                while (i <= end) {
                    BasicTabbedPaneUI.this.rects[i].y = currY;
                    BasicTabbedPaneUI.this.rects[i].height += spaceAllocated;
                    currY += BasicTabbedPaneUI.this.rects[i].height;
                    if (i == end && BasicTabbedPaneUI.this.rects[i].y + BasicTabbedPaneUI.this.rects[i].height != max) {
                        BasicTabbedPaneUI.this.rects[i].height = max - BasicTabbedPaneUI.this.rects[i].y;
                    }
                    ++i;
                }
            }
        }

        public Dimension preferredLayoutSize(Container parent) {
            return this.calculateSize(false);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                return BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, 0, 0);
            }
            int runs = 0;
            int runWidth = 0;
            int tabWidth = 0;
            FontMetrics fm = BasicTabbedPaneUI.this.getFontMetrics();
            Insets tabAreaInsets = BasicTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            width -= tabAreaInsets.left + tabAreaInsets.right + insets.left + insets.right;
            int i = 0;
            while (i < BasicTabbedPaneUI.this.tabPane.getTabCount()) {
                tabWidth = BasicTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, fm);
                if (runWidth + tabWidth > width) {
                    runWidth = tabWidth;
                    ++runs;
                } else {
                    runWidth += tabWidth;
                }
                ++i;
            }
            int maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            int tabAreaHeight = BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, ++runs, maxTabHeight);
            return tabAreaHeight;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                return BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, 0, 0);
            }
            int runs = 0;
            int runHeight = 0;
            int tabHeight = 0;
            FontMetrics fm = BasicTabbedPaneUI.this.getFontMetrics();
            Insets tabAreaInsets = BasicTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            height -= tabAreaInsets.top + tabAreaInsets.bottom + insets.top + insets.bottom;
            int fontHeight = fm.getHeight();
            int i = 0;
            while (i < BasicTabbedPaneUI.this.tabPane.getTabCount()) {
                tabHeight = BasicTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                if (runHeight + tabHeight > height) {
                    runHeight = tabHeight;
                    ++runs;
                } else {
                    runHeight += tabHeight;
                }
                ++i;
            }
            int maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
            int tabAreaWidth = BasicTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, ++runs, maxTabWidth);
            return tabAreaWidth;
        }

        protected void rotateTabRuns(int tabPlacement, int selectedRun) {
            if (BasicTabbedPaneUI.this.runCount == 1 || selectedRun == 1 || selectedRun == -1) {
                return;
            }
            int[] newTabRuns = new int[BasicTabbedPaneUI.this.tabRuns.length];
            int currentRun = selectedRun;
            int i = 1;
            do {
                newTabRuns[i] = BasicTabbedPaneUI.this.tabRuns[currentRun];
                currentRun = BasicTabbedPaneUI.this.getNextTabRun(currentRun);
            } while (++i < BasicTabbedPaneUI.this.runCount);
            if (BasicTabbedPaneUI.this.runCount > 1) {
                newTabRuns[0] = BasicTabbedPaneUI.this.tabRuns[currentRun];
            }
            BasicTabbedPaneUI.this.tabRuns = newTabRuns;
            BasicTabbedPaneUI.this.selectedRun = 1;
        }

        public void removeLayoutComponent(Component comp) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ScrollingViewport
    extends JViewport
    implements UIResource {
        private ScrollingViewport() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ScrollingPanel
    extends JPanel {
        public void updateUI() {
            this.setUI(new ScrollingPanelUI());
        }

        private ScrollingPanel() {
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        private class ScrollingPanelUI
        extends BasicPanelUI {
            public void paint(Graphics g, JComponent c) {
                BasicTabbedPaneUI.this.paintTabArea(g, BasicTabbedPaneUI.this.tabPane.getTabPlacement(), BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
            }

            private ScrollingPanelUI() {
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class TabbedPaneScrollLayout
    extends TabbedPaneLayout {
        public Dimension preferredLayoutSize(Container parent) {
            return super.calculateSize(true);
        }

        public Dimension minimumLayoutSize(Container parent) {
            return super.calculateSize(true);
        }

        protected int preferredTabAreaHeight(int tabPlacement, int width) {
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                return BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, 0, 0);
            }
            int runs = 1;
            int maxTabHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
            int tabAreaHeight = BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, runs, maxTabHeight);
            return tabAreaHeight;
        }

        protected int preferredTabAreaWidth(int tabPlacement, int height) {
            if (BasicTabbedPaneUI.this.tabPane.getTabCount() == 0) {
                return BasicTabbedPaneUI.this.calculateTabAreaHeight(tabPlacement, 0, 0);
            }
            int runs = 1;
            int maxTabWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
            int tabAreaWidth = BasicTabbedPaneUI.this.calculateTabAreaWidth(tabPlacement, runs, maxTabWidth);
            return tabAreaWidth;
        }

        protected void calculateTabRects(int tabPlacement, int tabCount) {
            if (tabCount == 0) {
                return;
            }
            BasicTabbedPaneUI.this.assureRectsCreated(tabCount);
            FontMetrics fm = BasicTabbedPaneUI.this.getFontMetrics();
            SwingUtilities.calculateInnerArea(BasicTabbedPaneUI.this.tabPane, BasicTabbedPaneUI.this.calcRect);
            Insets tabAreaInsets = BasicTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            Insets insets = BasicTabbedPaneUI.this.tabPane.getInsets();
            int max = 0;
            int runs = 1;
            int start = 0;
            int top = 0;
            if (tabPlacement == 1 || tabPlacement == 3) {
                int maxHeight = BasicTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                BasicTabbedPaneUI.this.calcRect.width -= tabAreaInsets.left + tabAreaInsets.right;
                max = BasicTabbedPaneUI.this.calcRect.width + tabAreaInsets.left + insets.left;
                start = tabAreaInsets.left + insets.left;
                int width = 0;
                int runWidth = start;
                top = insets.top + tabAreaInsets.top;
                int i = 0;
                while (i < tabCount) {
                    width = BasicTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, fm);
                    BasicTabbedPaneUI.this.rects[i] = new Rectangle(runWidth, top, width, maxHeight);
                    runWidth += width;
                    ++i;
                }
                BasicTabbedPaneUI.this.tabAreaRect.width = BasicTabbedPaneUI.this.tabPane.getWidth() - insets.left - insets.right;
                BasicTabbedPaneUI.this.tabAreaRect.height = runs * BasicTabbedPaneUI.this.maxTabHeight - (runs - 1) * BasicTabbedPaneUI.this.tabRunOverlay + tabAreaInsets.top + tabAreaInsets.bottom;
                BasicTabbedPaneUI.this.contentRect.width = BasicTabbedPaneUI.this.tabAreaRect.width;
                BasicTabbedPaneUI.this.contentRect.height = BasicTabbedPaneUI.this.tabPane.getHeight() - insets.top - insets.bottom - BasicTabbedPaneUI.this.tabAreaRect.height;
                BasicTabbedPaneUI.this.contentRect.x = insets.left;
                BasicTabbedPaneUI.this.tabAreaRect.x = insets.left;
                if (tabPlacement == 3) {
                    BasicTabbedPaneUI.this.contentRect.y = insets.top;
                    BasicTabbedPaneUI.this.tabAreaRect.y = BasicTabbedPaneUI.this.contentRect.y + BasicTabbedPaneUI.this.contentRect.height;
                } else {
                    BasicTabbedPaneUI.this.tabAreaRect.y = insets.top;
                    BasicTabbedPaneUI.this.contentRect.y = BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height;
                }
            } else {
                int maxWidth = BasicTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                BasicTabbedPaneUI.this.calcRect.height -= tabAreaInsets.top + tabAreaInsets.bottom;
                max = BasicTabbedPaneUI.this.calcRect.height + tabAreaInsets.top;
                int height = 0;
                int runHeight = start = tabAreaInsets.top + insets.top;
                int fontHeight = fm.getHeight();
                top = insets.left + tabAreaInsets.left;
                int i = 0;
                while (i < tabCount) {
                    height = BasicTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    BasicTabbedPaneUI.this.rects[i] = new Rectangle(top, runHeight, maxWidth, height);
                    runHeight += height;
                    ++i;
                }
                BasicTabbedPaneUI.this.tabAreaRect.width = runs * BasicTabbedPaneUI.this.maxTabWidth - (runs - 1) * BasicTabbedPaneUI.this.tabRunOverlay + tabAreaInsets.left + tabAreaInsets.right;
                BasicTabbedPaneUI.this.tabAreaRect.height = BasicTabbedPaneUI.this.tabPane.getHeight() - insets.top - insets.bottom;
                BasicTabbedPaneUI.this.tabAreaRect.y = insets.top;
                BasicTabbedPaneUI.this.contentRect.width = BasicTabbedPaneUI.this.tabPane.getWidth() - insets.left - insets.right - BasicTabbedPaneUI.this.tabAreaRect.width;
                BasicTabbedPaneUI.this.contentRect.height = BasicTabbedPaneUI.this.tabAreaRect.height;
                BasicTabbedPaneUI.this.contentRect.y = insets.top;
                if (tabPlacement == 2) {
                    BasicTabbedPaneUI.this.tabAreaRect.x = insets.left;
                    BasicTabbedPaneUI.this.contentRect.x = BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width;
                } else {
                    BasicTabbedPaneUI.this.contentRect.x = insets.left;
                    BasicTabbedPaneUI.this.tabAreaRect.x = BasicTabbedPaneUI.this.contentRect.x + BasicTabbedPaneUI.this.contentRect.width;
                }
            }
            BasicTabbedPaneUI.this.runCount = runs;
            this.padSelectedTab(tabPlacement, BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
        }

        public void layoutContainer(Container pane) {
            Dimension decrDims;
            Dimension incrDims;
            super.layoutContainer(pane);
            int tabCount = BasicTabbedPaneUI.this.tabPane.getTabCount();
            Point p = null;
            if (tabCount == 0) {
                return;
            }
            int tabPlacement = BasicTabbedPaneUI.this.tabPane.getTabPlacement();
            BasicTabbedPaneUI.this.incrButton.hide();
            BasicTabbedPaneUI.this.decrButton.hide();
            if ((tabPlacement == 1 || tabPlacement == 3) && BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width < BasicTabbedPaneUI.this.rects[tabCount - 1].x + BasicTabbedPaneUI.this.rects[tabCount - 1].width) {
                incrDims = BasicTabbedPaneUI.this.incrButton.getPreferredSize();
                decrDims = BasicTabbedPaneUI.this.decrButton.getPreferredSize();
                BasicTabbedPaneUI.this.decrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width - incrDims.width - decrDims.width, BasicTabbedPaneUI.this.tabAreaRect.y, decrDims.width, BasicTabbedPaneUI.this.tabAreaRect.height);
                BasicTabbedPaneUI.this.incrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x + BasicTabbedPaneUI.this.tabAreaRect.width - incrDims.width, BasicTabbedPaneUI.this.tabAreaRect.y, decrDims.width, BasicTabbedPaneUI.this.tabAreaRect.height);
                BasicTabbedPaneUI.this.tabAreaRect.width -= decrDims.width + incrDims.width;
                BasicTabbedPaneUI.this.incrButton.show();
                BasicTabbedPaneUI.this.decrButton.show();
            }
            if ((tabPlacement == 2 || tabPlacement == 4) && BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height < BasicTabbedPaneUI.this.rects[tabCount - 1].y + BasicTabbedPaneUI.this.rects[tabCount - 1].height) {
                incrDims = BasicTabbedPaneUI.this.incrButton.getPreferredSize();
                decrDims = BasicTabbedPaneUI.this.decrButton.getPreferredSize();
                BasicTabbedPaneUI.this.decrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x, BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height - incrDims.height - decrDims.height, BasicTabbedPaneUI.this.tabAreaRect.width, decrDims.height);
                BasicTabbedPaneUI.this.incrButton.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x, BasicTabbedPaneUI.this.tabAreaRect.y + BasicTabbedPaneUI.this.tabAreaRect.height - incrDims.height, BasicTabbedPaneUI.this.tabAreaRect.width, incrDims.height);
                BasicTabbedPaneUI.this.tabAreaRect.height -= decrDims.height + incrDims.height;
                BasicTabbedPaneUI.this.incrButton.show();
                BasicTabbedPaneUI.this.decrButton.show();
            }
            BasicTabbedPaneUI.this.viewport.setBounds(BasicTabbedPaneUI.this.tabAreaRect.x, BasicTabbedPaneUI.this.tabAreaRect.y, BasicTabbedPaneUI.this.tabAreaRect.width, BasicTabbedPaneUI.this.tabAreaRect.height);
            int tabC = BasicTabbedPaneUI.this.tabPane.getTabCount() - 1;
            if (tabCount > 0) {
                int w = Math.max(BasicTabbedPaneUI.this.rects[tabC].width + BasicTabbedPaneUI.this.rects[tabC].x, BasicTabbedPaneUI.this.tabAreaRect.width);
                int h = Math.max(BasicTabbedPaneUI.this.rects[tabC].height, BasicTabbedPaneUI.this.tabAreaRect.height);
                p = BasicTabbedPaneUI.this.findPointForIndex(BasicTabbedPaneUI.this.currentScrollLocation);
                BasicTabbedPaneUI.this.panel.setSize(w + p.x, h + p.y);
            }
            BasicTabbedPaneUI.this.viewport.setViewPosition(p);
            BasicTabbedPaneUI.this.viewport.repaint();
        }

        private TabbedPaneScrollLayout() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent e) {
            int index;
            int x = e.getX();
            int y = e.getY();
            int tabCount = BasicTabbedPaneUI.this.tabPane.getTabCount();
            if (BasicTabbedPaneUI.this.tabPane.getTabLayoutPolicy() == 1) {
                if (e.getSource() == BasicTabbedPaneUI.this.incrButton) {
                    if (++BasicTabbedPaneUI.this.currentScrollLocation >= tabCount) {
                        BasicTabbedPaneUI.this.currentScrollLocation = tabCount - 1;
                    }
                    int width = 0;
                    int i = BasicTabbedPaneUI.this.currentScrollLocation - 1;
                    while (i < tabCount) {
                        width += BasicTabbedPaneUI.this.rects[i].width;
                        ++i;
                    }
                    if (width < BasicTabbedPaneUI.this.viewport.getWidth()) {
                        --BasicTabbedPaneUI.this.currentScrollLocation;
                    } else if (!BasicTabbedPaneUI.this.decrButton.isEnabled()) {
                        BasicTabbedPaneUI.this.decrButton.setEnabled(true);
                    }
                    BasicTabbedPaneUI.this.tabPane.revalidate();
                    BasicTabbedPaneUI.this.tabPane.repaint();
                    return;
                }
                if (e.getSource() == BasicTabbedPaneUI.this.decrButton) {
                    if (--BasicTabbedPaneUI.this.currentScrollLocation < 0) {
                        BasicTabbedPaneUI.this.currentScrollLocation = 0;
                    }
                    if (BasicTabbedPaneUI.this.currentScrollLocation == 0) {
                        BasicTabbedPaneUI.this.decrButton.setEnabled(false);
                    } else if (!BasicTabbedPaneUI.this.incrButton.isEnabled()) {
                        BasicTabbedPaneUI.this.incrButton.setEnabled(true);
                    }
                    BasicTabbedPaneUI.this.tabPane.revalidate();
                    BasicTabbedPaneUI.this.tabPane.repaint();
                    return;
                }
            }
            if ((index = BasicTabbedPaneUI.this.tabForCoordinate(BasicTabbedPaneUI.this.tabPane, x, y)) != -1 && BasicTabbedPaneUI.this.tabPane.isEnabledAt(index)) {
                BasicTabbedPaneUI.this.tabPane.setSelectedIndex(index);
            }
            BasicTabbedPaneUI.this.tabPane.revalidate();
            BasicTabbedPaneUI.this.tabPane.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FocusHandler
    extends FocusAdapter {
        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TabSelectionHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent e) {
            BasicTabbedPaneUI.this.selectedRun = BasicTabbedPaneUI.this.getRunForTab(BasicTabbedPaneUI.this.tabPane.getTabCount(), BasicTabbedPaneUI.this.tabPane.getSelectedIndex());
            BasicTabbedPaneUI.this.tabPane.revalidate();
            BasicTabbedPaneUI.this.tabPane.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("tabLayoutPolicy")) {
                BasicTabbedPaneUI.this.layoutManager = BasicTabbedPaneUI.this.createLayoutManager();
                BasicTabbedPaneUI.this.tabPane.setLayout(BasicTabbedPaneUI.this.layoutManager);
            } else if (e.getPropertyName().equals("tabPlacement") && BasicTabbedPaneUI.this.tabPane.getTabLayoutPolicy() == 1) {
                BasicTabbedPaneUI.this.incrButton = BasicTabbedPaneUI.this.createIncreaseButton();
                BasicTabbedPaneUI.this.decrButton = BasicTabbedPaneUI.this.createDecreaseButton();
            }
            BasicTabbedPaneUI.this.tabPane.layout();
            BasicTabbedPaneUI.this.tabPane.repaint();
        }
    }
}

