/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.java.net.protocol.http.HTTPConnection;
import java.io.IOException;
import java.io.InputStream;

class LimitedLengthInputStream
extends InputStream {
    private long remainingLen;
    private boolean restrictLen;
    private HTTPConnection connection;
    private boolean eof;
    private InputStream in;
    private boolean doClose;

    private final void handleClose() throws IOException {
        this.eof = true;
        if (this.doClose) {
            this.in.close();
        } else {
            this.connection.release();
        }
        this.in = null;
        this.connection = null;
    }

    public synchronized int read() throws IOException {
        int r;
        if (this.eof) {
            return -1;
        }
        if (this.restrictLen) {
            r = this.in.read();
            if (-1 != r) {
                --this.remainingLen;
            }
            if (0L == this.remainingLen) {
                this.handleClose();
            }
        } else {
            r = this.in.read();
            if (r == -1) {
                this.handleClose();
            }
        }
        return r;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        int r;
        if (this.eof) {
            return -1;
        }
        if (this.restrictLen && (long)length > this.remainingLen) {
            length = (int)this.remainingLen;
        }
        if (-1 == (r = this.in.read(buffer, offset, length))) {
            this.handleClose();
        }
        if (this.restrictLen && r > 0) {
            this.remainingLen -= (long)r;
            if (0L == this.remainingLen) {
                this.handleClose();
            }
        }
        return r;
    }

    public synchronized long skip(long n) throws IOException {
        if (this.eof) {
            return 0L;
        }
        if (this.restrictLen && n > this.remainingLen) {
            n = this.remainingLen;
        }
        long r = this.in.skip(n);
        if (this.restrictLen) {
            this.remainingLen -= r;
            if (0L == this.remainingLen) {
                this.handleClose();
            }
        }
        return r;
    }

    public synchronized int available() throws IOException {
        if (this.eof) {
            return 0;
        }
        int a = this.in.available();
        if (this.restrictLen && (long)a > this.remainingLen) {
            a = (int)this.remainingLen;
        }
        return a;
    }

    public synchronized void close() throws IOException {
        if (this.eof) {
            return;
        }
        this.doClose = true;
        this.handleClose();
    }

    LimitedLengthInputStream(InputStream in, long maxLen, boolean restrictLen, HTTPConnection con, boolean doClose) throws IOException {
        this.in = in;
        this.remainingLen = maxLen;
        this.restrictLen = restrictLen;
        this.connection = con;
        this.doClose = doClose;
        if (restrictLen) {
            if (maxLen < 0L) {
                throw new IllegalArgumentException();
            }
            if (maxLen == 0L) {
                this.handleClose();
            }
        }
    }
}

