# math.tcl --
#
#	Main 'package provide' script for the package 'math'.
#
# Copyright (c) 1998-2000 by Ajuba Solutions.
# Copyright (c) 2002 by Kevin B. Kenny.  All rights reserved.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
# 
# RCS: @(#) $Id: math.tcl,v 1.23 2009/12/04 17:37:47 andreas_kupries Exp $

package require Tcl 8.2		;# uses [lindex $l end-$integer]

namespace eval ::math {

    variable version 1.2.5

    # combinatorics.tcl

    namespace export	ln_Gamma	factorial	choose
    namespace export	Beta

    # Set up for auto-loading

    if { ![interp issafe {}]} {
	variable home [file join [pwd] [file dirname [info script]]]
	if {[lsearch -exact $::auto_path $home] == -1} {
	    lappend ::auto_path $home
	}
    } else {
	source [file join [file dirname [info script]] combinatorics.tcl]
    }

    package provide [namespace tail [namespace current]] $version
}
