#ifndef __STK_KEYBOARD
#define __STK_KEYBOARD

#include "../../../config.h"
#include "stk_control.h"
#include "../stk.h"


#define STK_K_ENTER        3

#define STK_K_ESCAPE       5

#define STK_K_BACKSPACE    10
#define STK_K_DELETE       11

#define STK_K_UP       100
#define STK_K_DOWN     101
#define STK_K_RIGHT    102
#define STK_K_LEFT     103
// not managed
#define STK_K_SPACE    104


/** a class to read information about the keyboard. 
 It uses XQueryKeymap to read state of keyboard. So a
 X11 window must be opened before to use it.
 */

class Stk_Keyboard: public Stk_Control,public Stk_PassiveSender
{
public:
        /// constructor 
    Stk_Keyboard(Stk_Looper *);
        /// destructor
    virtual ~Stk_Keyboard();
        /// Is XQueryKeymap present on this sytem ?
    int IsPresent() const;
        /// Read the state of keyboard
    void ReadState();
        /// loop: functions wich generates events
    virtual int Loop();
        /// Print information about keyboard
    void Print() const;

        /// Get the position af axe X
    float getPositionAxeX() const;
        /// Get the position of axe Y
    float getPositionAxeY() const;
        /// Get State of button 1
    float getButton1() const;
        /// Get State of button 2
    float getButton2() const;
        /// Get State of button 3
    float getButton3() const;
        /// Get State of button 4
    float getButton4() const;

public: // it must be private
    int key[256];
    
};




#endif
