/*
* MyGoGrinder - a program to practice Go problems
* Copyright (c) 2004-2006 Tim Kington
*   timkington@users.sourceforge.net
* Portions Copyright (C) Ruediger Klehn (2014)
*   RuediRf@users.sourceforge.net
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

package GoGrinder.ui;

import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import java.net.*;
import java.io.File;

import GoGrinder.*;
import GoGrinder.tests.Test;
import GoGrinder.ui.actions.FakeAction;
import GoGrinder.ui.actions.InsertNodeAction;
import GoGrinder.ui.actions.InsertNodeCopyAction;
import GoGrinder.ui.actions.LocalMoveAction;
import GoGrinder.ui.actions.MoveAction;
import GoGrinder.ui.actions.NewAction;
import GoGrinder.ui.actions.RealAction;
import GoGrinder.ui.actions.WGFOpenAction;
import GoGrinder.ui.actions.WGFSaveAction;
import GoGrinder.ui.actions.WGFSaveAsAction;
import com.Ostermiller.util.Browser;
import GoGrinder.ui.ProbFrame;

/**
 *
 * @author  tkington
 */
public class WGFFrame extends JFrame {
    private WGFController wgfController;
    private GobanPanel goban;
    JEditorPane textPane;
    JSplitPane splitPane;
    JButton stepButton;
    private JToggleButton editButton;
    private JCheckBoxMenuItem editModeMenuItem;
    private static final String WGF_DEMO_FILE = "DEMO.WGF";
    private static final String WGF_DEMO_FILE_PATH = Main.pathToDocs + Main.SLASH + WGF_DEMO_FILE;
    
    // JMenuBar teachMenu; // T.K. worked on some ideas
    // JMenuBar editMenu;  // T.K. worked on some ideas
    JToolBar toolbar;
    
    private Action newAction;
    private Action openAction;
    private Action saveAction;
    private Action saveAsAction;
    
    private Action fakeAction;
    private Action realAction;
    private Action moveAction;
    private Action localMoveAction;

    private Action insertNodeAction;
    private Action insertNodeCopyAction;
   
    private JComboBox toolCombo;
    private DefaultComboBoxModel toolComboModel;
    private ImageIcon grayTri;
    private JComboBox textModeCombo;
    private JButton buttonMove;
    
    /** Creates a new instance of WGFFrame */ 
    public WGFFrame() {
//        super(Messages.getString("gg_title")); //$NON-NLS-1$ // apparently this has no effect or it is overwritten by WGFController
                                                               // (title is set in WGFController)
                                                               // (private void setTitle())
        
        URL iconURL = getClass().getResource("/GoGrinder/images/Icon.png"); //$NON-NLS-1$
        ImageIcon icon = new ImageIcon(iconURL);
        setIconImage(icon.getImage());
        
        Container cp = getContentPane();
        
        textPane = new JEditorPane("text/html",Messages.getString("WGFFrame.OpenAWGFFileToBegin")); //$NON-NLS-1$ //$NON-NLS-2$
        textPane.setEditable(false);
        
        JScrollPane scrollPane = new JScrollPane(textPane);
        
        wgfController = new WGFController(this);
        Test.controller = wgfController;
        textPane.addHyperlinkListener(wgfController);

        createActions();
        createToolBar();
        setJMenuBar(createMenuBar());
        
        enableActions();
        
        wgfController.setControls(textPane, stepButton);
        
        Box toolPanel = new Box(BoxLayout.X_AXIS);
        toolPanel.add(toolbar);
        toolPanel.add(Box.createHorizontalGlue());
        cp.add(toolPanel, BorderLayout.NORTH);
        
        Board board = new Board(9);
        goban = new GobanPanel(board);
        goban.turnOffGhost();
        wgfController.setPanel(goban);
        goban.setController(wgfController);
        
        splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
                                          goban,
                                          scrollPane);
        
        cp.add(splitPane, BorderLayout.CENTER);
        
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
              if(!wgfController.saveChanges())
                return;
                Main.onExit();
            }
        });
        
        setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);
        setBounds(GS.getWGFFrameBounds());
        splitPane.setDividerLocation(GS.getSplitterPos());
    }
    
    private void createActions() {
      newAction = new NewAction(this, wgfController);
      openAction = new WGFOpenAction(this, wgfController);
      saveAction = new WGFSaveAction(this, wgfController);
      saveAsAction = new WGFSaveAsAction(this, wgfController);

      fakeAction = new FakeAction(this, wgfController);
      moveAction = new MoveAction(this, wgfController);
      localMoveAction = new LocalMoveAction(this, wgfController);
      realAction = new RealAction(this, wgfController);

      insertNodeAction = new InsertNodeAction(this, wgfController);
      insertNodeCopyAction = new InsertNodeCopyAction(this, wgfController);
    }
    
    private void createToolBar() {
        toolbar = new JToolBar();
        toolbar.setFloatable(false);
        
        JButton b = new JButton(newAction);
        b.setText(""); //$NON-NLS-1$
        toolbar.add(b);
        
        b = new JButton(openAction); // openAction first lets select a filename and THEN looks for currWGFFile isDirty()
        b.setText(""); //$NON-NLS-1$ // this should be done in a less irritating order
        toolbar.add(b);
        
        b = new JButton(saveAction);
        b.setText(""); //$NON-NLS-1$
        toolbar.add(b);
        
        b = new JButton(saveAsAction);
        b.setText(""); //$NON-NLS-1$
        toolbar.add(b);
        
        toolbar.addSeparator();
        
        b = new JButton(Main.getIcon("Home16.gif", this)); //$NON-NLS-1$
        b.setToolTipText(Messages.getString("WGFFrame.Home")); //$NON-NLS-1$
        b.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                wgfController.home();
            }
        });
        toolbar.add(b);

        ActionListener prevListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                wgfController.prev();
            }
        };
        
        b = new JButton(Main.getIcon("Back16.gif", this)); //$NON-NLS-1$
        b.setToolTipText(Messages.getString("WGFFrame.Back")); //$NON-NLS-1$
        b.addActionListener(prevListener);
        toolbar.add(b);
        
        if (false){ // #### should depend on (boolean edit), as it's no fun to add text with ".", ",", "x", "z" in it ####
          b.registerKeyboardAction(prevListener, 
                                   KeyStroke.getKeyStroke(KeyEvent.VK_Z, 0),
                                   JComponent.WHEN_IN_FOCUSED_WINDOW);
          
          b.registerKeyboardAction(prevListener, 
                                   KeyStroke.getKeyStroke(KeyEvent.VK_COMMA, 0),
                                   JComponent.WHEN_IN_FOCUSED_WINDOW);
        }  
        ActionListener nextListener = new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                wgfController.next();
            }
        };
                
        b = new JButton(Main.getIcon("Forward16.gif", this)); //$NON-NLS-1$
        b.setToolTipText(Messages.getString("WGFFrame.NextPage")); //$NON-NLS-1$
        b.addActionListener(nextListener);
        toolbar.add(b);
        if (false){ // #### should depend on (boolean edit), as it's no fun to add text with ".", ",", "x", "z" in it ####
        b.registerKeyboardAction(nextListener, 
                                 KeyStroke.getKeyStroke(KeyEvent.VK_X, 0),
                                 JComponent.WHEN_IN_FOCUSED_WINDOW);
        
        b.registerKeyboardAction(nextListener, 
                                 KeyStroke.getKeyStroke(KeyEvent.VK_PERIOD, 0),
                                 JComponent.WHEN_IN_FOCUSED_WINDOW);
        }
        stepButton = new JButton(Messages.getString("WGFFrame.Step")); //$NON-NLS-1$
        stepButton.setToolTipText(Messages.getString("WGFFrame.Step")); //$NON-NLS-1$
        stepButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                wgfController.step();
            }
        });
        toolbar.add(stepButton);
                 
        toolbar.addSeparator();

        b = new JButton("info"); //Main.getIcon("About16.gif", this)
        //b.setToolTipText(Messages.getString("about_gg"));
        b.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent paramAnonymousActionEvent) {
            JOptionPane.showMessageDialog(null, 
                    "The file format: \n" 
                  + "WGF files are simply sgf files with reduced standard information and \n"
                  + "another file name extension. The unusual HTML tags in the sgf comments \n"
                  + "allow to format the text just like any HTML code. Java can display this \n" 
                  + "formatted text, but also possible is, to use the files in web pages with \n" 
                  + "a built-in, special crafted Java viewer or with JavaScript (WGF: WebGoFile?). \n" 
                  + "New identifiers for coordinates (e.g. XB[]YB[]) are possibly not displayed \n" 
                  + "by any other program. Branches are (as far as I see) not used or supported. \n" 
                  + "The demo file (DEMO.WGF) gives a small impression of what is possible. \n\n");
          }
        });
        toolbar.add(b);
       
        toolbar.addSeparator();
        
        editButton = new JToggleButton("Edit"); //$NON-NLS-1$
        editButton.setText("Edit"); //$NON-NLS-1$
        editButton.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                 wgfController.setEditMode(editButton.isSelected());
                 enableActions();
                 buttonMove.doClick();
                 editModeMenuItem.setSelected(editButton.isSelected());
            }
        });
        toolbar.add(editButton);

        toolbar.addSeparator();
        
        buttonMove = new JButton(moveAction); //$NON-NLS-1$
        buttonMove.setText(""); //$NON-NLS-1$
        toolbar.add(buttonMove); // I would like this button to be activated when I switch to "allow edit"
                                 // (done with a buttonMove.doClick() in the editButton action)
        b = new JButton(fakeAction); //$NON-NLS-1$
        b.setText(""); //$NON-NLS-1$
        toolbar.add(b);
        
        b = new JButton(realAction); //$NON-NLS-1$
        b.setText(""); //$NON-NLS-1$
        toolbar.add(b);
        
        b = new JButton(localMoveAction);
        b.setText(""); //$NON-NLS-1$
        toolbar.add(b);
        
        
        // ImageIcon tri = Main.getIcon("TriStone.png", this); //$NON-NLS-1$
        // grayTri = new ImageIcon(GrayFilter.createDisabledImage(tri.getImage())); //  --> enableActions() comment
        
        Object [] items = new Object[] {
                            Main.getIcon("TriStone.png", this),// tri, --> enableActions() comment
                            Main.getIcon("CircleStone.png", this), //$NON-NLS-1$
                            Main.getIcon("SquareStone.png", this), //$NON-NLS-1$
                            Main.getIcon("XStone.png", this), //$NON-NLS-1$
                            Main.getIcon("AStone.png", this), //$NON-NLS-1$
                            Main.getIcon("OneStone.png", this), //$NON-NLS-1$
                            Main.getIcon("LabelStone.png", this), //$NON-NLS-1$
                            Main.getIcon("Territory.png", this)}; //$NON-NLS-1$
        toolCombo = new JComboBox(items);
        // toolCombo.setSelectedIndex(0); // no, doesn't work as I wanted (triangle marker active)
        toolComboModel = (DefaultComboBoxModel)toolCombo.getModel();
        Dimension dim = toolCombo.getMinimumSize();
        toolCombo.setMaximumSize(new Dimension(dim.width, 100));
        toolCombo.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
            switch(toolCombo.getSelectedIndex()) {
              case 0: wgfController.setEditTool(WGFController.TOOL_TRI); break; // xx exchanging these two values 
              case 1: wgfController.setEditTool(WGFController.TOOL_CIR); break; // xx doesn't help either
              case 2: wgfController.setEditTool(WGFController.TOOL_SQU); break;
              case 3: wgfController.setEditTool(WGFController.TOOL_X); break;
              case 4: wgfController.setEditTool(WGFController.TOOL_LETTER); break;
              case 5: wgfController.setEditTool(WGFController.TOOL_NUMBER); break;
              case 6: wgfController.setEditTool(WGFController.TOOL_LABEL); break;
              case 7: wgfController.setEditTool(WGFController.TOOL_TERRITORY); break;
            }
          }
        });
        toolbar.add(toolCombo);
        
        String [] modeChoices = {"View HTML", "Edit HTML", "Edit WGF"};   //$NON-NLS-1$//$NON-NLS-2$//$NON-NLS-3$
        textModeCombo = new JComboBox(modeChoices);
//        textModeCombo.setMinimumSize(new Dimension(dim.width, 100));
//        textModeCombo.setMaximumSize(new Dimension(dim.width, 150));
        textModeCombo.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
            int mode = -1;
            switch(textModeCombo.getSelectedIndex()) {
            case 0: mode = WGFController.TEXTMODE_VIEWHTML; break;
            case 1: mode = WGFController.TEXTMODE_EDITHTML; break;
            case 2: mode = WGFController.TEXTMODE_EDITWGF; break;
            } // if you deactivate "edit", one could expect the text pane switching back to view (that was on T.K.'s list)
            if(!wgfController.setTextPaneMode(mode))
              textModeCombo.setSelectedIndex(2);
          }
        });
        toolbar.add(textModeCombo);
        
        b = new JButton(insertNodeAction);
        toolbar.add(b);
        
        b = new JButton(insertNodeCopyAction);
        String NodeCopyToolTip = "<HTML>Find yourself out, how this works: it copies the <BR/>"
                                + "current node (also the root info, if this is the root node),<BR/>"
                                + "to the next node.</HTML>";
        b.setToolTipText(NodeCopyToolTip); // should refuse to copy if node is root node
        toolbar.add(b);
    }
    
    private JMenuBar createMenuBar() {
      JMenuBar menuBar = new JMenuBar();
      
      JMenu fileMenu = new JMenu(Messages.getString("WGFFrame.File")); //$NON-NLS-1$
      
      JMenuItem mi = new JMenuItem(newAction);
      mi.setIcon(null);
      fileMenu.add(mi);
      
      mi = new JMenuItem(openAction);
      mi.setIcon(null);
      fileMenu.add(mi);
      
      mi = new JMenuItem(saveAction);
      mi.setIcon(null);
      fileMenu.add(mi);
      
      mi = new JMenuItem(saveAsAction);
      mi.setIcon(null);
      fileMenu.add(mi);

      mi = new JMenuItem("Exit");
      mi.setIcon(null);
      mi.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            Main.onExit();
        }
      }); 
      fileMenu.add(mi);
      
      menuBar.add(fileMenu);
      
      JMenu editMenu = new JMenu("Edit");
      editModeMenuItem = new JCheckBoxMenuItem(Messages.getString("WGFFrame.EditMode")); //$NON-NLS-1$
      editModeMenuItem.addItemListener(new ItemListener() {
        public void itemStateChanged(ItemEvent e) {
          wgfController.setEditMode(editModeMenuItem.isSelected());
          enableActions();
          buttonMove.doClick();
          editButton.setSelected(editModeMenuItem.isSelected());
        }
      });
      editMenu.add(editModeMenuItem);
              
      mi = new JMenuItem("SGF editor 1"); //$NON-NLS-1$  // a text editor would be the right tool for WGF files
      mi.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          // Main.onEdit(1); // NO! THAT NEEDS TO GET THE WGF-FILE  // use Editor 1
        }
      });
      // editMenu.add(mi);
              
      mi = new JMenuItem("Editor 2"); //$NON-NLS-1$
      mi.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            // use Editor 2
        }
      });
      //editMenu.add(mi);
              
      menuBar.add(editMenu);
      
      JMenu toolsMenu = new JMenu(Messages.getString("WGFFrame.Mode")); //$NON-NLS-1$
      
      mi = new JMenuItem(Messages.getString("WGFFrame.ProblemMode")); //$NON-NLS-1$
      mi.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
            if(!wgfController.saveChanges())
              return;
              Main.switchState();
        }
      });
      toolsMenu.add(mi);
      menuBar.add(toolsMenu);

      JMenu helpMenu = new JMenu(Messages.getString("help")); //$NON-NLS-1$ // 
      
      mi = new JMenuItem(Messages.getString("WGFFrame.HelpWGFEditor")); //$NON-NLS-1$
      mi.setIcon(null);
      mi.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          onHelpWGF();
        }
      }); 
      helpMenu.add(mi);

      mi = new JMenuItem(Messages.getString("WGFFrame.InfoWGF")); //$NON-NLS-1$
      mi.setIcon(null);
      mi.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) { // why is this public?
          Toolkit.getDefaultToolkit().beep(); // for test phase
        }
      }); 
//      helpMenu.add(mi);

      mi = new JMenuItem("View the WGF demo file"); //$NON-NLS-1$
      mi.setIcon(null);
      mi.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) { // why is this public?
          File demoFile = new File(WGF_DEMO_FILE_PATH);
          if (!demoFile.exists()){
            demoFile = new File(Main.thisProgsFolder + Main.SLASH + WGF_DEMO_FILE);
          }
          if (!demoFile.exists()) {
            JOptionPane.showMessageDialog(null, WGF_DEMO_FILE + " not found"
                                              + "\n neither: \n"
                                              + WGF_DEMO_FILE_PATH 
                                              + "\n nor: \n"
                                              + demoFile.getPath());
            return;
          }
          try {
              wgfController.openFile(demoFile);
          }
          catch(Exception e4) {
              JOptionPane.showMessageDialog(null, Messages.getString("WGFFrame.ErrorWhileReadingSeeGrindLog")); //$NON-NLS-1$
              Main.logSilent(e4);
          }

          //Toolkit.getDefaultToolkit().beep(); // for test phase
        }
      }); 
      helpMenu.add(mi);

      mi = new JMenuItem(Messages.getString("about_gg")); //$NON-NLS-1$
      mi.setIcon(null);
      mi.addActionListener(new ActionListener() {
        public void actionPerformed(ActionEvent e) {
                    AboutDialog d = new AboutDialog(WGFFrame.this, true);
                    d.setVisible(true);
        }
      });
      helpMenu.add(mi);

      menuBar.add(helpMenu);
      
      JMenu pseudoMenu = new JMenu("                                                               Testing the WGF editor"); //$NON-NLS-1$
      menuBar.add(pseudoMenu);

      return menuBar;
    }
    
    private void onHelpWGF(){
      File f = new File(Main.pathToDocs + File.separator + "wgf.html"); //$NON-NLS-1$ //$NON-NLS-2$
      if (!f.exists() ){
        d.b.g("Path to help files is apparently wrong: \n" + Main.pathToDocs + "\nCouldn't find help file \"wgf.html\"");
        return;
      }
      String url = null;
      try {
          url = f.toURL().toString(); //toURI().
          Browser.displayURL(url); // ostermiller
      }
      catch(Exception ex) {
          JOptionPane.showMessageDialog(WGFFrame.this, Messages.getString("couldnt_display_url") 
                                                      + " " + url
                                                      + "\n" + Messages.getString("see_grind_log"));
          Main.logSilent(ex);
      }

    }
    
    private void enableActions() {
      boolean edit = wgfController.getMode() == WGFController.EDIT_MODE;
      moveAction.setEnabled(edit);
      fakeAction.setEnabled(edit);
      realAction.setEnabled(edit);
      localMoveAction.setEnabled(edit);
      
      // when you activate "edit", the mark tool is active (better would be the move tool); 
      // it shows a triangle, but sets a circle (irritating)
      // now, with this block deactivated, the move tool is active ( but with "edit" inactive, 
      // the mark tool icon is not grayed out); 
      
//      boolean oldEnabled = toolCombo.isEnabled();
//      if(oldEnabled && !edit) {
//        toolComboModel.insertElementAt(grayTri, 0);
//        toolCombo.setSelectedIndex(0);
//      }
//      else if(edit && !oldEnabled) {
//        toolComboModel.removeElementAt(0);
//      }
      toolCombo.setEnabled(edit);
      
      textModeCombo.setEnabled(edit);
      insertNodeAction.setEnabled(edit);
      insertNodeCopyAction.setEnabled(edit);
      
      stepButton.setEnabled(!edit);
    }
    
    public int getSplitterPos() { return splitPane.getDividerLocation(); }
    public void saveHistory() { wgfController.saveHistory(); }
    public void loadHistory() { wgfController.loadHistory(); }
}
