# PR 54841: time(1) reports garbage user and system times again

from __future__ import print_function

from bracket import *

name = 'user_time_sane'

def test_func(ts):
    logfn = os.path.join(results_dir(ts), name + ".log")
    r = anita_run_1(ts, "boot",
            logfn,
            extra_anita_args = [
                "--run", "cd /usr/tests/fs/vfs && echo -n 'T_VNOPS_TIME ' && time atf-run t_vnops >log; true",
                "--run-timeout", "1500",
                "--no-install"
            ])
    with open(logfn, 'rb') as f:
        for line in f:
            m = re.search(rb'T_VNOPS_TIME.* ([\d\.]+) user', line)
            if m:
                usertime = float(m.group(1))
                print("usertime:", usertime)
                return usertime < 300.0
        raise RuntimeError("could not find user time in output")

def op():
    return TestOp(test_func, [install_op], name = name)
