/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.multi;

import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class MultiLookAndFeel
extends LookAndFeel {
    public String getName() {
        return "Multiplexing Look and Feel";
    }

    public String getID() {
        return "Multiplex";
    }

    public String getDescription() {
        return "Allows multiple UI instances per component instance";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public UIDefaults getDefaults() {
        UIDefaults uIDefaults = new UIDefaults();
        uIDefaults.put("ButtonUI", "javax.swing.plaf.multi.MultiButtonUI");
        uIDefaults.put("CheckBoxUI", "javax.swing.plaf.multi.MultiButtonUI");
        uIDefaults.put("CheckBoxMenuItemUI", "javax.swing.plaf.multi.MultiMenuItemUI");
        uIDefaults.put("ColorChooserUI", "javax.swing.plaf.multi.MultiColorChooserUI");
        uIDefaults.put("ComboBoxUI", "javax.swing.plaf.multi.MultiComboBoxUI");
        uIDefaults.put("DesktopPaneUI", "javax.swing.plaf.multi.MultiDesktopPaneUI");
        uIDefaults.put("DesktopIconUI", "javax.swing.plaf.multi.MultiDesktopIconUI");
        uIDefaults.put("EditorPaneUI", "javax.swing.plaf.multi.MultiTextUI");
        uIDefaults.put("FileChooserUI", "javax.swing.plaf.multi.MultiFileChooserUI");
        uIDefaults.put("FormattedTextFieldUI", "javax.swing.plaf.multi.MultiTextUI");
        uIDefaults.put("InternalFrameUI", "javax.swing.plaf.multi.MultiInternalFrameUI");
        uIDefaults.put("LabelUI", "javax.swing.plaf.multi.MultiLabelUI");
        uIDefaults.put("ListUI", "javax.swing.plaf.multi.MultiListUI");
        uIDefaults.put("MenuItemUI", "javax.swing.plaf.multi.MultiMenuItemUI");
        uIDefaults.put("MenuUI", "javax.swing.plaf.multi.MultiMenuItemUI");
        uIDefaults.put("MenuBarUI", "javax.swing.plaf.multi.MultiMenuBarUI");
        uIDefaults.put("OptionPaneUI", "javax.swing.plaf.multi.MultiOptionPaneUI");
        uIDefaults.put("PanelUI", "javax.swing.plaf.multi.MultiPanelUI");
        uIDefaults.put("PasswordFieldUI", "javax.swing.plaf.multi.MultiTextUI");
        uIDefaults.put("PopupMenuUI", "javax.swing.plaf.multi.MultiPopupMenuUI");
        uIDefaults.put("PopupMenuSeparatorUI", "javax.swing.plaf.multi.MultiSeparatorUI");
        uIDefaults.put("ProgressBarUI", "javax.swing.plaf.multi.MultiProgressBarUI");
        uIDefaults.put("RadioButtonUI", "javax.swing.plaf.multi.MultiButtonUI");
        uIDefaults.put("RadioButtonMenuItemUI", "javax.swing.plaf.multi.MultiMenuItemUI");
        uIDefaults.put("RootPaneUI", "javax.swing.plaf.multi.MultiRootPaneUI");
        uIDefaults.put("ScrollBarUI", "javax.swing.plaf.multi.MultiScrollBarUI");
        uIDefaults.put("ScrollPaneUI", "javax.swing.plaf.multi.MultiScrollPaneUI");
        uIDefaults.put("SeparatorUI", "javax.swing.plaf.multi.MultiSeparatorUI");
        uIDefaults.put("SliderUI", "javax.swing.plaf.multi.MultiSliderUI");
        uIDefaults.put("SpinnerUI", "javax.swing.plaf.multi.MultiSpinnerUI");
        uIDefaults.put("SplitPaneUI", "javax.swing.plaf.multi.MultiSplitPaneUI");
        uIDefaults.put("TabbedPaneUI", "javax.swing.plaf.multi.MultiTabbedPaneUI");
        uIDefaults.put("TableHeaderUI", "javax.swing.plaf.multi.MultiTableHeaderUI");
        uIDefaults.put("TableUI", "javax.swing.plaf.multi.MultiTableUI");
        uIDefaults.put("TextAreaUI", "javax.swing.plaf.multi.MultiTextUI");
        uIDefaults.put("TextFieldUI", "javax.swing.plaf.multi.MultiTextUI");
        uIDefaults.put("TextPaneUI", "javax.swing.plaf.multi.MultiTextUI");
        uIDefaults.put("ToggleButtonUI", "javax.swing.plaf.multi.MultiButtonUI");
        uIDefaults.put("ToolBarSeparatorUI", "javax.swing.plaf.multi.MultiSeparatorUI");
        uIDefaults.put("ToolBarUI", "javax.swing.plaf.multi.MultiToolBarUI");
        uIDefaults.put("ToolTipUI", "javax.swing.plaf.multi.MultiToolTipUI");
        uIDefaults.put("ViewportUI", "javax.swing.plaf.multi.MultiViewportUI");
        return uIDefaults;
    }

    public static ComponentUI createUIs(ComponentUI componentUI, Vector vector, JComponent jComponent) {
        ComponentUI componentUI2 = null;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null) {
            componentUI2 = UIManager.getUI(jComponent);
            vector.add(componentUI2);
        }
        LookAndFeel[] lookAndFeelArray = UIManager.getAuxiliaryLookAndFeels();
        int n = 0;
        while (n < lookAndFeelArray.length) {
            LookAndFeel lookAndFeel2 = lookAndFeelArray[n];
            UIDefaults uIDefaults = lookAndFeel2.getDefaults();
            componentUI2 = uIDefaults.getUI(jComponent);
            if (componentUI2 != null) {
                vector.add(componentUI2);
            }
            ++n;
        }
        if (vector.size() > 1) {
            return componentUI;
        }
        return componentUI2;
    }

    protected static ComponentUI[] uisToArray(Vector vector) {
        if (vector == null) {
            return new ComponentUI[0];
        }
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        Object[] objectArray = new ComponentUI[n];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

