class SushiNet::StoreBrowseFrame < Borges::Component

  sushi_icon_filename = File.join File.dirname(__FILE__), "sushi.ico"
  @@sushi_icon = File.open sushi_icon_filename, "rb" do |f| f.read end

  def actions
    actions = [:home, :browse]

    if session.has_cart? then
      actions << :checkout
    else
      actions
    end
  end

  def browse
    home
    @main.call SushiNet::StoreItemList.new(session.all_items)
  end

  def checkout
    answer
  end

  def home
    @main.clear_delegate 
  end

  def initialize
    @banner = SushiNet::StoreBanner.new self
    @navbar = Borges::NavigationBar.new self
    @main = SushiNet::StoreFront.new
    @cart = SushiNet::StoreCart.new
  end

  def render_head_elements_on(r)
    super r
    
    r.attributes[:rel] = 'shortcut icon'
    r.attributes[:href] = r.url_for_document @@sushi_icon, "image/x-icon"
    r.head_tag :link
  end

  def render_content_on(r)
    r.table do
      r.element_id 'top'

      r.table_row_span 3 do @banner.render_on r end

      r.table_spacer_row

      r.table_row do
        r.element_id 'nav'
        r.table_data do @navbar.render_on r end

        r.element_id 'main'
        r.table_data do @main.render_on r end

        r.element_id 'side'
        r.table_data do @cart.render_on r end
      end
    end
  end

  def search(search_string)
    home
    @main.call SushiNet::StoreSearchTask.new(search_string)
  end

  def style
  return "
    body {margin: 0px; font-family: sans-serif}
    table {width: 100%}
    #top {background-color: lightblue}
    #banner {text-align: right; padding-top: 10px; vertical-align: bottom}
    #search {vertical-align: bottom}
    #main {width: 50%; padding: 10px}
    #side {vertical-align: top; }
    #cart {border-style: dashed; border-width: 1; padding: 5px}
    #nav {background-color: lightgrey; vertical-align: top; border-width: 1; padding: 5px; width: 15%; font-size: 12pt}
    #title {font-size: 18pt; font-weight: bold}
    #subtitle {font-size: 9pt; font-style: italic}
    #batch {font-size: 10pt}
  "
  end

end # class SushiNet::StoreBrowseFrame

