/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.CDR;

import gnu.CORBA.BigDecimalHelper;
import gnu.CORBA.CDR.AbstractDataInput;
import gnu.CORBA.CDR.BigEndianInputStream;
import gnu.CORBA.CDR.BufferredCdrInput;
import gnu.CORBA.CDR.LittleEndianInputStream;
import gnu.CORBA.CDR.gnuRuntime;
import gnu.CORBA.GIOP.CharSets_OSF;
import gnu.CORBA.GIOP.CodeSetServiceContext;
import gnu.CORBA.IOR;
import gnu.CORBA.IorDelegate;
import gnu.CORBA.OrbFunctional;
import gnu.CORBA.StubLocator;
import gnu.CORBA.TypeCodeHelper;
import gnu.CORBA.Unexpected;
import gnu.CORBA.Version;
import gnu.CORBA.gnuAny;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigDecimal;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnySeqHolder;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BooleanSeqHolder;
import org.omg.CORBA.CharSeqHolder;
import org.omg.CORBA.DataInputStream;
import org.omg.CORBA.DoubleSeqHolder;
import org.omg.CORBA.FloatSeqHolder;
import org.omg.CORBA.LongLongSeqHolder;
import org.omg.CORBA.LongSeqHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.ShortSeqHolder;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.ULongLongSeqHolder;
import org.omg.CORBA.ULongSeqHolder;
import org.omg.CORBA.UShortSeqHolder;
import org.omg.CORBA.WCharSeqHolder;
import org.omg.CORBA.portable.ObjectImpl;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractCdrInput
extends org.omg.CORBA_2_3.portable.InputStream
implements DataInputStream {
    protected static final String UNEXP_EOF = "Unexpected end of stream";
    public transient gnuRuntime runtime;
    protected AbstractDataInput b;
    protected InputStream actual_stream;
    protected ORB orb;
    protected Version giop;
    protected CodeSetServiceContext codeset;
    private String narrow_charset;
    private String wide_charset;
    private boolean narrow_native;
    private boolean wide_native;
    private boolean little_endian;

    public void setBigEndian(boolean use_big_endian) {
        this.little_endian = use_big_endian ^ true;
        this.setInputStream(this.actual_stream);
    }

    public boolean isBigEndian() {
        return this.little_endian ^ true;
    }

    public void cloneSettings(AbstractCdrInput stream) {
        stream.setBigEndian(this.isBigEndian());
        stream.setCodeSet(this.getCodeSet());
        stream.setVersion(this.giop);
        stream.setOrb(this.orb);
    }

    public void setInputStream(InputStream readFrom) {
        this.b = this.little_endian ? new LittleEndianInputStream(readFrom) : new BigEndianInputStream(readFrom);
        this.actual_stream = readFrom;
    }

    public abstract void setOffset(int var1);

    public void setOrb(ORB an_orb) {
        this.orb = an_orb;
    }

    public void setVersion(Version giop_version) {
        this.giop = giop_version;
    }

    public abstract void align(int var1);

    /*
     * WARNING - void declaration
     */
    public long gnu_read_ulong() {
        try {
            void ex;
            long l = this.b.readInt();
            l &= 0xFFFFFFFL;
            return (long)ex;
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public int gnu_read_ushort() {
        try {
            this.align(2);
            return this.b.readUnsignedShort();
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public ORB orb() {
        return this.orb;
    }

    public int read() throws IOException {
        try {
            return this.b.read();
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
    }

    public int read(byte[] x, int ofs, int len) throws IOException {
        try {
            return this.b.read(x, ofs, len);
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
    }

    public int read(byte[] x) throws IOException {
        try {
            return this.b.read(x);
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
    }

    public Object read_Object() {
        try {
            OrbFunctional forb;
            Object local;
            IOR ior = new IOR();
            ior._read_no_endian(this);
            if (ior.Id == null) {
                return null;
            }
            if (this.orb instanceof OrbFunctional && (local = (forb = (OrbFunctional)this.orb).find_local_object(ior)) != null) {
                return local;
            }
            ObjectImpl impl = StubLocator.search(this.orb, ior);
            try {
                if (impl._get_delegate() == null) {
                    impl._set_delegate(new IorDelegate(this.orb, ior));
                }
            }
            catch (BAD_OPERATION ex) {
                impl._set_delegate(new IorDelegate(this.orb, ior));
            }
            return impl;
        }
        catch (IOException ex) {
            MARSHAL bad = new MARSHAL();
            bad.minor = 1195573273;
            bad.initCause(ex);
            throw bad;
        }
    }

    public TypeCode read_TypeCode() {
        try {
            return TypeCodeHelper.read(this);
        }
        catch (Bounds ex) {
            throw new Unexpected();
        }
        catch (BadKind ex) {
            throw new Unexpected();
        }
    }

    public Any read_any() {
        TypeCode ty = this.read_TypeCode();
        gnuAny any = new gnuAny();
        any.read_value(this, ty);
        return any;
    }

    public boolean read_boolean() {
        try {
            int n = 0;
            if (this.b.read() == 0) {
                n = 1;
            }
            return 1 - n;
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public void read_boolean_array(boolean[] x, int offs, int len) {
        try {
            int i = offs;
            while (i < offs + len) {
                int n = 0;
                if (this.b.read() == 0) {
                    n = 1;
                }
                x[i] = 1 - n;
                ++i;
            }
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public char read_char() {
        try {
            if (this.narrow_native) {
                return (char)this.b.read();
            }
            return (char)new InputStreamReader((InputStream)((org.omg.CORBA.portable.InputStream)((java.lang.Object)this.b)), this.narrow_charset).read();
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public void read_char_array(char[] x, int offset, int length) {
        try {
            if (this.narrow_native) {
                int i = offset;
                while (i < offset + length) {
                    x[i] = (char)this.b.read();
                    ++i;
                }
            } else {
                InputStreamReader reader = new InputStreamReader((InputStream)((org.omg.CORBA.portable.InputStream)((java.lang.Object)this.b)), this.narrow_charset);
                reader.read(x, offset, length);
            }
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public double read_double() {
        try {
            this.align(8);
            return this.b.readDouble();
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected();
        }
    }

    public void read_double_array(double[] x, int offs, int len) {
        try {
            this.align(8);
            int i = offs;
            while (i < offs + len) {
                x[i] = this.b.readDouble();
                ++i;
            }
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public BufferredCdrInput read_encapsulation() {
        try {
            int l = this.read_long();
            byte[] r = new byte[l];
            int n = 0;
            while (n < r.length) {
                n += this.read(r, n, r.length - n);
            }
            BufferredCdrInput capsule = new BufferredCdrInput(r);
            capsule.setOrb(this.orb);
            byte endian = capsule.read_octet();
            if (endian != 0) {
                capsule.setBigEndian(false);
            }
            return capsule;
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public BigDecimal read_fixed() {
        try {
            return BigDecimalHelper.read(this, 0);
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public float read_float() {
        try {
            this.align(4);
            return this.b.readFloat();
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public void read_float_array(float[] x, int offs, int len) {
        try {
            this.align(4);
            int i = offs;
            while (i < offs + len) {
                x[i] = this.b.readFloat();
                ++i;
            }
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public int read_long() {
        try {
            this.align(4);
            return this.b.readInt();
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public void read_long_array(int[] x, int offs, int len) {
        try {
            this.align(4);
            int i = offs;
            while (i < offs + len) {
                x[i] = this.b.readInt();
                ++i;
            }
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public long read_longlong() {
        try {
            this.align(8);
            return this.b.readLong();
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public void read_longlong_array(long[] x, int offs, int len) {
        try {
            this.align(8);
            int i = offs;
            while (i < offs + len) {
                x[i] = this.b.readLong();
                ++i;
            }
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public byte read_octet() {
        try {
            return this.b.readByte();
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public void read_octet_array(byte[] x, int offs, int len) {
        try {
            this.b.read(x, offs, len);
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public byte[] read_sequence() {
        try {
            int l = this.read_long();
            byte[] buf = new byte[l];
            if (l > 0) {
                this.b.readFully(buf);
            }
            return buf;
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public short read_short() {
        try {
            this.align(2);
            return this.b.readShort();
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public void read_short_array(short[] x, int offs, int len) {
        try {
            this.align(2);
            int i = offs;
            while (i < offs + len) {
                x[i] = this.b.readShort();
                ++i;
            }
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public String read_string() {
        int n = 0;
        try {
            this.align(4);
            n = this.b.readInt();
            byte[] s = new byte[n];
            this.b.read(s);
            if (this.narrow_charset == null) {
                return new String(s, 0, n - 1);
            }
            return new String(s, 0, n - 1, this.narrow_charset);
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected();
        }
        catch (NegativeArraySizeException nex) {
            MARSHAL m = new MARSHAL("Input stream broken, got " + n + "(0x" + Integer.toHexString(n) + ") as a string size");
            m.minor = 1195573260;
            throw m;
        }
    }

    public int read_ulong() {
        return this.read_long();
    }

    public void read_ulong_array(int[] x, int offs, int len) {
        this.read_long_array(x, offs, len);
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public void read_ulonglong_array(long[] x, int offs, int len) {
        this.read_longlong_array(x, offs, len);
    }

    public short read_ushort() {
        return this.read_short();
    }

    public void read_ushort_array(short[] x, int offs, int len) {
        this.read_short_array(x, offs, len);
    }

    /*
     * WARNING - void declaration
     */
    public char read_wchar() {
        try {
            String cs;
            if (this.giop.until_inclusive(1, 1)) {
                this.align(2);
                if (this.wide_native) {
                    return (char)this.b.readShort();
                }
                return (char)new InputStreamReader((InputStream)((org.omg.CORBA.portable.InputStream)((java.lang.Object)this.b)), this.wide_charset).read();
            }
            int l = this.b.read();
            if (l == 2 && this.wide_native) {
                return this.b.readChar();
            }
            if (l <= 0) {
                void bytes;
                MARSHAL m = new MARSHAL("wchar size " + l);
                m.minor = 1195573260;
                throw bytes;
            }
            byte[] bytes = new byte[l];
            this.b.readFully(bytes);
            if (bytes.length > 2 && bytes[0] == 254 && bytes[1] == 255) {
                cs = new String(bytes, 2, bytes.length - 2, this.wide_charset);
            } else if (bytes.length > 2 && bytes[0] == 255 && bytes[1] == 254) {
                int i = 3;
                while (i < bytes.length) {
                    byte t = bytes[i];
                    bytes[i - 1] = bytes[i];
                    bytes[i] = t;
                    i += 2;
                }
                cs = new String(bytes, 2, bytes.length - 2, this.wide_charset);
            } else {
                cs = new String(bytes, this.wide_charset);
            }
            return cs.charAt(0);
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected();
        }
    }

    public void read_wchar_array(char[] x, int offset, int length) {
        try {
            if (this.giop.until_inclusive(1, 1)) {
                this.align(2);
            }
            if (this.wide_native) {
                int i = offset;
                while (i < offset + length) {
                    x[i] = (char)this.b.readShort();
                    ++i;
                }
            } else {
                InputStreamReader reader = new InputStreamReader((InputStream)((org.omg.CORBA.portable.InputStream)((java.lang.Object)this.b)), this.wide_charset);
                reader.read(x, offset, length);
            }
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public String read_wstring() {
        if (this.wide_native || this.giop.until_inclusive(1, 1)) {
            return this.read_wstring_UTF_16();
        }
        try {
            this.align(4);
            int n = this.b.readInt();
            byte[] s = new byte[n];
            this.b.read(s);
            return new String(s, 0, n, this.wide_charset);
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String read_wstring_UTF_16() {
        try {
            int p = 0;
            int n = this.read_long();
            if (n < 0) {
                void nt;
                MARSHAL m = new MARSHAL("Negative string size");
                m.minor = 1195573260;
                throw nt;
            }
            int nt = 1 - this.giop.since_inclusive(1, 2);
            if ((n /= 2) == 0) {
                return "";
            }
            char[] s = new char[n];
            int i = 0;
            while (i < s.length) {
                s[i] = (char)this.b.readShort();
                ++i;
            }
            if (s[0] == '\ufeff') {
                p = 1;
            } else if (s[0] == '\ufffe') {
                i = p = 1;
                while (i < s.length) {
                    s[i] = AbstractCdrInput.swap(s[i]);
                    ++i;
                }
            }
            String r = new String(s, p, n - nt - p);
            return r;
        }
        catch (EOFException ex) {
            MARSHAL t = new MARSHAL(UNEXP_EOF);
            t.minor = 1195573251;
            t.initCause(ex);
            throw t;
        }
        catch (IOException ex) {
            throw new Unexpected(ex);
        }
    }

    public static char swap(char x) {
        int lo = x & 0xFF;
        int hi = x >> 8 & 0xFF;
        return (char)(lo << 8 | hi);
    }

    public void setCodeSet(CodeSetServiceContext a_codeset) {
        this.codeset = a_codeset;
        this.narrow_charset = CharSets_OSF.getName(this.codeset.char_data);
        this.wide_charset = CharSets_OSF.getName(this.codeset.wide_char_data);
        boolean bl = false;
        if (65537 == this.codeset.char_data) {
            bl = true;
        }
        this.narrow_native = bl;
        boolean bl2 = false;
        if (65801 == this.codeset.wide_char_data) {
            bl2 = true;
        }
        this.wide_native = bl2;
    }

    public CodeSetServiceContext getCodeSet() {
        return this.codeset;
    }

    public Object read_Object(Class klass) {
        return this.read_Object();
    }

    public Serializable read_Value() {
        return this.read_value();
    }

    public java.lang.Object read_Abstract() {
        return this.read_abstract_interface();
    }

    public void read_char_array(CharSeqHolder holder, int offset, int length) {
        holder.value = this.ensureArray(holder.value, offset, length);
        this.read_char_array(holder.value, offset, length);
    }

    public void read_wchar_array(WCharSeqHolder holder, int offset, int length) {
        holder.value = this.ensureArray(holder.value, offset, length);
        this.read_wchar_array(holder.value, offset, length);
    }

    private final char[] ensureArray(char[] holder_value, int offset, int length) {
        if (holder_value == null) {
            return new char[offset + length];
        }
        if (holder_value.length < offset + length) {
            char[] value = new char[offset + length];
            System.arraycopy(holder_value, 0, value, 0, holder_value.length);
            return value;
        }
        return holder_value;
    }

    public void read_ulong_array(ULongSeqHolder holder, int offset, int length) {
        holder.value = this.ensureArray(holder.value, offset, length);
        this.read_ulong_array(holder.value, offset, length);
    }

    public void read_long_array(LongSeqHolder holder, int offset, int length) {
        holder.value = this.ensureArray(holder.value, offset, length);
        this.read_ulong_array(holder.value, offset, length);
    }

    private final int[] ensureArray(int[] holder_value, int offset, int length) {
        if (holder_value == null) {
            return new int[offset + length];
        }
        if (holder_value.length < offset + length) {
            int[] value = new int[offset + length];
            System.arraycopy(holder_value, 0, value, 0, holder_value.length);
            return value;
        }
        return holder_value;
    }

    public void read_float_array(FloatSeqHolder holder, int offset, int length) {
        holder.value = this.ensureArray(holder.value, offset, length);
        this.read_float_array(holder.value, offset, length);
    }

    private final float[] ensureArray(float[] holder_value, int offset, int length) {
        if (holder_value == null) {
            return new float[offset + length];
        }
        if (holder_value.length < offset + length) {
            float[] value = new float[offset + length];
            System.arraycopy(holder_value, 0, value, 0, holder_value.length);
            return value;
        }
        return holder_value;
    }

    public void read_double_array(DoubleSeqHolder holder, int offset, int length) {
        holder.value = this.ensureArray(holder.value, offset, length);
        this.read_double_array(holder.value, offset, length);
    }

    private final double[] ensureArray(double[] holder_value, int offset, int length) {
        if (holder_value == null) {
            return new double[offset + length];
        }
        if (holder_value.length < offset + length) {
            double[] value = new double[offset + length];
            System.arraycopy(holder_value, 0, value, 0, holder_value.length);
            return value;
        }
        return holder_value;
    }

    public void read_short_array(ShortSeqHolder holder, int offset, int length) {
        holder.value = this.ensureArray(holder.value, offset, length);
        this.read_short_array(holder.value, offset, length);
    }

    public void read_ushort_array(UShortSeqHolder holder, int offset, int length) {
        holder.value = this.ensureArray(holder.value, offset, length);
        this.read_ushort_array(holder.value, offset, length);
    }

    private final short[] ensureArray(short[] holder_value, int offset, int length) {
        if (holder_value == null) {
            return new short[offset + length];
        }
        if (holder_value.length < offset + length) {
            short[] value = new short[offset + length];
            System.arraycopy(holder_value, 0, value, 0, holder_value.length);
            return value;
        }
        return holder_value;
    }

    public void read_octet_array(OctetSeqHolder holder, int offset, int length) {
        holder.value = this.ensureArray(holder.value, offset, length);
        this.read_octet_array(holder.value, offset, length);
    }

    private final byte[] ensureArray(byte[] holder_value, int offset, int length) {
        if (holder_value == null) {
            return new byte[offset + length];
        }
        if (holder_value.length < offset + length) {
            byte[] value = new byte[offset + length];
            System.arraycopy(holder_value, 0, value, 0, holder_value.length);
            return value;
        }
        return holder_value;
    }

    public void read_longlong_array(LongLongSeqHolder holder, int offset, int length) {
        holder.value = this.ensureArray(holder.value, offset, length);
        this.read_longlong_array(holder.value, offset, length);
    }

    public void read_ulonglong_array(ULongLongSeqHolder holder, int offset, int length) {
        holder.value = this.ensureArray(holder.value, offset, length);
        this.read_ulonglong_array(holder.value, offset, length);
    }

    private final long[] ensureArray(long[] holder_value, int offset, int length) {
        if (holder_value == null) {
            return new long[offset + length];
        }
        if (holder_value.length < offset + length) {
            long[] value = new long[offset + length];
            System.arraycopy(holder_value, 0, value, 0, holder_value.length);
            return value;
        }
        return holder_value;
    }

    public void read_boolean_array(BooleanSeqHolder holder, int offset, int length) {
        holder.value = this.ensureArray(holder.value, offset, length);
        this.read_boolean_array(holder.value, offset, length);
    }

    private final boolean[] ensureArray(boolean[] holder_value, int offset, int length) {
        if (holder_value == null) {
            return new boolean[offset + length];
        }
        if (holder_value.length < offset + length) {
            boolean[] value = new boolean[offset + length];
            System.arraycopy(holder_value, 0, value, 0, holder_value.length);
            return value;
        }
        return holder_value;
    }

    public void read_any_array(AnySeqHolder holder, int offset, int length) {
        holder.value = this.ensureArray(holder.value, offset, length);
        int i = offset;
        while (i < offset + length) {
            holder.value[i] = this.read_any();
            ++i;
        }
    }

    private final Any[] ensureArray(Any[] holder_value, int offset, int length) {
        if (holder_value == null) {
            return new Any[offset + length];
        }
        if (holder_value.length < offset + length) {
            Any[] value = new Any[offset + length];
            System.arraycopy(holder_value, 0, value, 0, holder_value.length);
            return value;
        }
        return holder_value;
    }

    public String[] _truncatable_ids() {
        return new String[]{"IDL:omg.org/CORBA/DataInputStream:1.0"};
    }

    private final /* synthetic */ void this() {
        this.giop = new Version(1, 2);
        this.codeset = CodeSetServiceContext.STANDARD;
        this.narrow_charset = null;
        this.wide_charset = null;
    }

    public AbstractCdrInput(InputStream readFrom) {
        this.this();
        this.setInputStream(readFrom);
        this.setCodeSet(CodeSetServiceContext.STANDARD);
    }

    public AbstractCdrInput() {
        this.this();
        this.setCodeSet(CodeSetServiceContext.STANDARD);
    }
}

