/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.provider;

import gnu.java.security.util.Prime;
import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Random;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DSAParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int size;
    private SecureRandom random;

    public void engineInit(int n, SecureRandom secureRandom) {
        if (n < 512 || n > 1024 || n % 64 != 0) {
            return;
        }
        this.size = n;
        this.random = secureRandom;
    }

    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Must be DSAParameterSpec");
        }
        DSAParameterSpec dSAParameterSpec = (DSAParameterSpec)algorithmParameterSpec;
        int n = dSAParameterSpec.getP().bitLength();
        if (n < 512 || n > 1024 || n % 64 != 0) {
            throw new InvalidAlgorithmParameterException("Invalid Size");
        }
        this.random = secureRandom;
    }

    public AlgorithmParameters engineGenerateParameters() {
        BigInteger bigInteger;
        int n = this.size;
        BigInteger bigInteger2 = Prime.generateRandomPrime(159, 160, BigInteger.valueOf(1L));
        BigInteger bigInteger3 = Prime.generateRandomPrime(bigInteger2, BigInteger.valueOf(1L), n - 1, n, BigInteger.valueOf(1L));
        BigInteger bigInteger4 = bigInteger3.subtract(BigInteger.valueOf(1L));
        bigInteger4 = bigInteger4.divide(bigInteger2);
        Random random = new Random();
        BigInteger bigInteger5 = BigInteger.valueOf(1L);
        while ((bigInteger = (bigInteger5 = bigInteger5.add(BigInteger.valueOf(1L))).modPow(bigInteger4, bigInteger3)).compareTo(BigInteger.valueOf(1L)) == 1) {
        }
        try {
            DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(bigInteger3, bigInteger2, bigInteger);
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DSA");
            algorithmParameters.init(dSAParameterSpec);
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            return null;
        }
    }

    private final /* synthetic */ void this() {
        this.random = null;
    }

    public DSAParameterGenerator() {
        this.this();
        this.size = 1024;
    }
}

