/* eek-0.90.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Eek", gir_namespace = "Eek", gir_version = "0.90", lower_case_cprefix = "eek_")]
namespace Eek {
	[CCode (cheader_filename = "eek/eek.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "eek_bounds_get_type ()")]
	[Compact]
	public class Bounds {
		public double height;
		public double width;
		public double x;
		public double y;
		public Eek.Bounds copy ();
		public void free ();
	}
	[CCode (cheader_filename = "eek/eek.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "eek_color_get_type ()")]
	[Compact]
	public class Color {
		public double alpha;
		public double blue;
		public double green;
		public double red;
		[CCode (has_construct_function = false)]
		public Color (double red, double green, double blue, double alpha);
		public Eek.Color copy ();
		public void free ();
	}
	[CCode (cheader_filename = "eek/eek.h", type_id = "eek_container_get_type ()")]
	public abstract class Container : Eek.Element {
		[CCode (has_construct_function = false)]
		protected Container ();
		public virtual void add_child (Eek.Element element);
		public virtual void foreach_child (Eek.Callback callback);
		[NoWrapper]
		public virtual void remove_child (Eek.Element element);
		public virtual signal void child_added (Eek.Element element);
		public virtual signal void child_removed (Eek.Element element);
	}
	[CCode (cheader_filename = "eek/eek.h", type_id = "eek_element_get_type ()")]
	public abstract class Element : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Element ();
		public void get_absolute_position (double x, double y);
		public void get_bounds (out unowned Eek.Bounds bounds);
		public int get_group ();
		public int get_level ();
		public unowned string get_name ();
		public void get_symbol_index (int group, int level);
		public void set_bounds (Eek.Bounds bounds);
		public void set_group (int group);
		public void set_level (int level);
		public void set_name (string name);
		public void set_parent (Eek.Element? parent);
		public void set_position (double x, double y);
		public void set_size (double width, double height);
		public void set_symbol_index (int group, int level);
		[NoAccessorMethod]
		public Eek.Bounds bounds { owned get; set; }
		public int group { get; set; }
		public int level { get; set; }
		public string name { get; set; }
		public virtual signal void symbol_index_changed (int group, int level);
	}
	[CCode (cheader_filename = "eek/eek.h", type_id = "eek_key_get_type ()")]
	public class Key : Eek.Element {
		[CCode (has_construct_function = false)]
		protected Key ();
		public void get_index (int? column, int? row);
		public uint get_keycode ();
		public uint get_oref ();
		public unowned Eek.Symbol get_symbol ();
		public unowned Eek.Symbol get_symbol_at_index (int group, int level, int fallback_group, int fallback_level);
		public unowned Eek.SymbolMatrix get_symbol_matrix ();
		public unowned Eek.Symbol get_symbol_with_fallback (int fallback_group, int fallback_level);
		public bool is_locked ();
		public bool is_pressed ();
		public void set_index (int column, int row);
		public void set_keycode (uint keycode);
		public void set_oref (uint oref);
		public void set_symbol_matrix (Eek.SymbolMatrix matrix);
		[NoAccessorMethod]
		public int column { get; set; }
		public uint keycode { get; set; }
		public ulong oref { get; set; }
		[NoAccessorMethod]
		public int row { get; set; }
		public Eek.SymbolMatrix symbol_matrix { get; set; }
		public virtual signal void cancelled ();
		public virtual signal void locked ();
		public virtual signal void pressed ();
		public virtual signal void released ();
		public virtual signal void unlocked ();
	}
	[CCode (cheader_filename = "eek/eek.h", type_id = "eek_keyboard_get_type ()")]
	public class Keyboard : Eek.Container {
		[CCode (has_construct_function = false)]
		public Keyboard (Eek.Layout layout, double initial_width, double initial_height);
		public uint add_outline (Eek.Outline outline);
		public virtual unowned Eek.Key find_key_by_keycode (uint keycode);
		public Eek.ModifierType get_alt_gr_mask ();
		public Eek.ModifierBehavior get_modifier_behavior ();
		public Eek.ModifierType get_modifiers ();
		public size_t get_n_outlines ();
		public Eek.ModifierType get_num_lock_mask ();
		public Eek.Outline get_outline (uint oref);
		public GLib.List<weak Eek.Key> get_pressed_keys ();
		public void get_size (double width, double height);
		public void output (GLib.StringBuilder output, int indent);
		public void set_alt_gr_mask (Eek.ModifierType alt_gr_mask);
		public void set_modifier_behavior (Eek.ModifierBehavior modifier_behavior);
		public void set_modifiers (Eek.ModifierType modifiers);
		public void set_num_lock_mask (Eek.ModifierType num_lock_mask);
		public void set_size (double width, double height);
		[NoAccessorMethod]
		public Eek.Layout layout { owned get; construct; }
		public Eek.ModifierBehavior modifier_behavior { get; set; }
		public virtual signal void key_cancelled (Eek.Key key);
		public virtual signal void key_locked (Eek.Key key);
		public virtual signal void key_pressed (Eek.Key key);
		public virtual signal void key_released (Eek.Key key);
		public virtual signal void key_unlocked (Eek.Key key);
	}
	[CCode (cheader_filename = "eek/eek.h", type_id = "eek_keysym_get_type ()")]
	public class Keysym : Eek.Symbol, Eek.Serializable {
		[CCode (has_construct_function = false)]
		public Keysym (uint xkeysym);
		[CCode (has_construct_function = false)]
		public Keysym.from_name (string name);
		public uint get_xkeysym ();
		[CCode (has_construct_function = false)]
		public Keysym.with_modifier (uint xkeysym, Eek.ModifierType modifier_mask);
	}
	[CCode (cheader_filename = "eek/eek.h", type_id = "eek_layout_get_type ()")]
	public abstract class Layout : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Layout ();
	}
	[CCode (cheader_filename = "eek/eek.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "eek_outline_get_type ()")]
	[Compact]
	public class Outline {
		public double corner_radius;
		public int num_points;
		public weak Eek.Point points;
		public Eek.Outline copy ();
		public void free ();
	}
	[CCode (cheader_filename = "eek/eek.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "eek_point_get_type ()")]
	[Compact]
	public class Point {
		public double x;
		public double y;
		public Eek.Point copy ();
		public void free ();
		public void rotate (int angle);
	}
	[CCode (cheader_filename = "eek/eek.h", type_id = "eek_section_get_type ()")]
	public class Section : Eek.Container {
		[CCode (has_construct_function = false)]
		protected Section ();
		public virtual void add_row (int num_columns, Eek.Orientation orientation);
		public int get_angle ();
		public virtual int get_n_rows ();
		public virtual void get_row (int index, int num_columns, Eek.Orientation orientation);
		public void set_angle (int angle);
		public int angle { get; set; }
		public virtual signal void key_cancelled (Eek.Key key);
		public virtual signal void key_locked (Eek.Key key);
		public virtual signal void key_pressed (Eek.Key key);
		public virtual signal void key_released (Eek.Key key);
		public virtual signal void key_unlocked (Eek.Key key);
	}
	[CCode (cheader_filename = "eek/eek.h", type_id = "eek_symbol_get_type ()")]
	public class Symbol : GLib.Object, Eek.Serializable {
		[CCode (has_construct_function = false)]
		public Symbol (string name);
		public Eek.SymbolCategory get_category ();
		public unowned string get_icon_name ();
		public unowned string get_label ();
		public Eek.ModifierType get_modifier_mask ();
		public unowned string get_name ();
		public unowned string get_tooltip ();
		public bool is_modifier ();
		public void set_category (Eek.SymbolCategory category);
		public void set_icon_name (string icon_name);
		public void set_label (string label);
		public void set_modifier_mask (Eek.ModifierType mask);
		public void set_name (string name);
		public void set_tooltip (string tooltip);
		public Eek.SymbolCategory category { get; set construct; }
		public string icon_name { get; set construct; }
		public string label { get; set construct; }
		public Eek.ModifierType modifier_mask { get; set construct; }
		public string name { get; set construct; }
		public string tooltip { get; set construct; }
	}
	[CCode (cheader_filename = "eek/eek.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "eek_symbol_matrix_get_type ()")]
	[Compact]
	public class SymbolMatrix {
		public weak Eek.Symbol data;
		public int num_groups;
		public int num_levels;
		[CCode (has_construct_function = false)]
		public SymbolMatrix (int num_groups, int num_levels);
		public Eek.SymbolMatrix copy ();
		public void free ();
		public unowned Eek.Symbol get_symbol (int group, int level);
		public void set_symbol (int group, int level, Eek.Symbol symbol);
	}
	[CCode (cheader_filename = "eek/eek.h", type_id = "eek_text_get_type ()")]
	public class Text : Eek.Symbol, Eek.Serializable {
		[CCode (has_construct_function = false)]
		public Text (string text);
		public unowned string get_text ();
		public string text { get; construct; }
	}
	[CCode (cheader_filename = "eek/eek.h", type_id = "eek_theme_get_type ()")]
	public class Theme : GLib.Object {
		[CCode (has_construct_function = false)]
		public Theme (string? application_stylesheet, string? theme_stylesheet, string? default_stylesheet);
		public bool load_stylesheet (string path) throws GLib.Error;
		public void unload_stylesheet (string path);
		[NoAccessorMethod]
		public string application_stylesheet { owned get; construct; }
		[NoAccessorMethod]
		public string default_stylesheet { owned get; construct; }
		[NoAccessorMethod]
		public string theme_stylesheet { owned get; construct; }
	}
	[CCode (cheader_filename = "eek/eek.h")]
	[Compact]
	public class ThemeContext {
	}
	[CCode (cheader_filename = "eek/eek.h")]
	[Compact]
	public class ThemeNode {
	}
	[CCode (cheader_filename = "eek/eek.h", type_id = "eek_xml_layout_get_type ()")]
	public class XmlLayout : Eek.Layout, GLib.Initable {
		[CCode (has_construct_function = false, type = "EekLayout*")]
		public XmlLayout (string id) throws GLib.Error;
		[NoAccessorMethod]
		public string id { owned get; construct; }
	}
	[CCode (cheader_filename = "eek/eek.h", type_id = "eek_serializable_get_type ()")]
	public interface Serializable : GLib.Object {
		[NoWrapper]
		public abstract size_t deserialize (GLib.Variant variant, size_t index);
		[NoWrapper]
		public abstract void serialize (GLib.VariantBuilder builder);
	}
	[CCode (cheader_filename = "eek/eek.h", cname = "_EekModifierKey", has_type_id = false)]
	public struct _ModifierKey {
		public Eek.ModifierType modifiers;
		public weak Eek.Key key;
	}
	[CCode (cheader_filename = "eek/eek.h", cname = "_EekXmlKeyboardDesc", has_type_id = false)]
	public struct _XmlKeyboardDesc {
		public weak string id;
		public weak string name;
		public weak string geometry;
		public weak string symbols;
		public weak string language;
		public weak string longname;
	}
	[CCode (cheader_filename = "eek/eek.h", cname = "EekErrorEnum", cprefix = "EEK_ERROR_")]
	[GIR (name = "ErrorEnum")]
	public enum Error {
		LAYOUT_ERROR,
		FAILED;
		public static GLib.Quark quark ();
	}
	[CCode (cheader_filename = "eek/eek.h", cprefix = "EEK_GRADIENT_")]
	public enum GradientType {
		NONE,
		VERTICAL,
		HORIZONTAL,
		RADIAL
	}
	[CCode (cheader_filename = "eek/eek.h", cprefix = "EEK_MODIFIER_BEHAVIOR_")]
	public enum ModifierBehavior {
		NONE,
		LOCK,
		LATCH
	}
	[CCode (cheader_filename = "eek/eek.h", cprefix = "EEK_")]
	[Flags]
	public enum ModifierType {
		SHIFT_MASK,
		LOCK_MASK,
		CONTROL_MASK,
		MOD1_MASK,
		MOD2_MASK,
		MOD3_MASK,
		MOD4_MASK,
		MOD5_MASK,
		BUTTON1_MASK,
		BUTTON2_MASK,
		BUTTON3_MASK,
		BUTTON4_MASK,
		BUTTON5_MASK,
		SUPER_MASK,
		HYPER_MASK,
		META_MASK,
		RELEASE_MASK,
		MODIFIER_MASK
	}
	[CCode (cheader_filename = "eek/eek.h", cprefix = "EEK_ORIENTATION_")]
	public enum Orientation {
		VERTICAL,
		HORIZONTAL,
		INVALID
	}
	[CCode (cheader_filename = "eek/eek.h", cprefix = "EEK_SYMBOL_CATEGORY_")]
	public enum SymbolCategory {
		LETTER,
		FUNCTION,
		KEYNAME,
		USER0,
		USER1,
		USER2,
		USER3,
		USER4,
		UNKNOWN,
		LAST;
		public static Eek.SymbolCategory from_name (string name);
		public static unowned string get_name (Eek.SymbolCategory category);
	}
	[CCode (cheader_filename = "eek/eek.h", instance_pos = 1.9)]
	public delegate void Callback (Eek.Element element);
	[CCode (cheader_filename = "eek/eek.h", instance_pos = 1.9)]
	public delegate int CompareFunc (Eek.Element element);
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_CONTAINER_H")]
	public const int CONTAINER_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_ELEMENT_H")]
	public const int ELEMENT_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_H")]
	public const int H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_INVALID_KEYCODE")]
	public const int INVALID_KEYCODE;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_INVALID_KEYSYM")]
	public const int INVALID_KEYSYM;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_KEYBOARD_H")]
	public const int KEYBOARD_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_KEYSYM_H")]
	public const int KEYSYM_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_KEY_H")]
	public const int KEY_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_LAYOUT_H")]
	public const int LAYOUT_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_SECTION_H")]
	public const int SECTION_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_SERIALIZABLE_H")]
	public const int SERIALIZABLE_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_SYMBOL_H")]
	public const int SYMBOL_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_SYMBOL_MATRIX_H")]
	public const int SYMBOL_MATRIX_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_TEXT_H")]
	public const int TEXT_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_TYPES_H")]
	public const int TYPES_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_XML_H")]
	public const int XML_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_XML_LAYOUT_H")]
	public const int XML_LAYOUT_H;
	[CCode (cheader_filename = "eek/eek.h", cname = "EEK_XML_SCHEMA_VERSION")]
	public const string XML_SCHEMA_VERSION;
	[CCode (cheader_filename = "eek/eek.h")]
	public static void init ();
	[CCode (cheader_filename = "eek/eek.h")]
	public static GLib.List<weak string> xml_list_keyboards ();
}
