/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.InvalidFieldException;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.MethodResult;
import gnu.classpath.jdwp.util.Value;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;

public class ObjectReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeReferenceType(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeGetValues(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeSetValues(byteBuffer, dataOutputStream);
                    break;
                }
                case 5: {
                    this.executeMonitorInfo(byteBuffer, dataOutputStream);
                    break;
                }
                case 6: {
                    this.executeInvokeMethod(byteBuffer, dataOutputStream);
                    break;
                }
                case 7: {
                    this.executeDisableCollection(byteBuffer, dataOutputStream);
                    break;
                }
                case 8: {
                    this.executeEnableCollection(byteBuffer, dataOutputStream);
                    break;
                }
                case 9: {
                    this.executeIsCollected(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in ObjectReference Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private final void executeReferenceType(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        Class clazz = object.getClass();
        ReferenceTypeId referenceTypeId = this.idMan.getReferenceTypeId(clazz);
        referenceTypeId.writeTagged(dataOutputStream);
    }

    private final void executeGetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        int n = byteBuffer.getInt();
        dataOutputStream.writeInt(n);
        int n2 = 0;
        while (n2 < n) {
            Field field = (Field)this.idMan.readObjectId(byteBuffer).getObject();
            try {
                field.setAccessible(true);
                Object object2 = field.get(object);
                Value.writeTaggedValue(dataOutputStream, object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidFieldException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JdwpInternalErrorException(illegalAccessException);
            }
            ++n2;
        }
    }

    private final void executeSetValues(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        int n = byteBuffer.getInt();
        int n2 = 0;
        while (n2 < n) {
            Field field = (Field)this.idMan.readObjectId(byteBuffer).getObject();
            Object object2 = Value.getUntaggedObj(byteBuffer, field.getType());
            try {
                field.setAccessible(true);
                field.set(object, object2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidFieldException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new JdwpInternalErrorException(illegalAccessException);
            }
            ++n2;
        }
    }

    private final void executeMonitorInfo(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command ExecuteMonitorInfo not implemented.");
    }

    private final void executeInvokeMethod(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        boolean bl;
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Object object = objectId.getObject();
        ObjectId objectId2 = this.idMan.readObjectId(byteBuffer);
        Thread thread = (Thread)objectId2.getObject();
        ReferenceTypeId referenceTypeId = this.idMan.readReferenceTypeId(byteBuffer);
        Class clazz = referenceTypeId.getType();
        ObjectId objectId3 = this.idMan.readObjectId(byteBuffer);
        Method method = (Method)objectId3.getObject();
        int n = byteBuffer.getInt();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = Value.getObj(byteBuffer);
            ++n2;
        }
        n2 = byteBuffer.getInt();
        boolean bl2 = false;
        if ((n2 & 1) != 0) {
            bl2 = true;
        }
        if (bl = bl2) {
            VMVirtualMachine.suspendAllThreads();
        }
        boolean bl3 = false;
        if ((n2 & 2) != 0) {
            bl3 = true;
        }
        boolean bl4 = bl3;
        MethodResult methodResult = VMVirtualMachine.executeMethod(object, thread, clazz, method, objectArray, bl4);
        Object object2 = methodResult.getReturnedValue();
        Exception exception = methodResult.getThrownException();
        ObjectId objectId4 = this.idMan.getObjectId(exception);
        Value.writeTaggedValue(dataOutputStream, object2);
        objectId4.writeTagged(dataOutputStream);
    }

    private final void executeDisableCollection(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        objectId.disableCollection();
    }

    private final void executeEnableCollection(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        objectId.enableCollection();
    }

    private final void executeIsCollected(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        boolean bl = false;
        if (objectId.getReference().get() == null) {
            bl = true;
        }
        boolean bl2 = bl;
        dataOutputStream.writeBoolean(bl2);
    }
}

