/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.java.io.ObjectIdentityWrapper;
import gnu.java.lang.reflect.TypeSignature;
import gnu.java.security.action.SetAccessibleAction;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.SerializablePermission;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObjectOutputStream
extends OutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private static final int BUFFER_SIZE = 1024;
    private static int defaultProtocolVersion = 2;
    private static final boolean DEBUG = false;
    private DataOutputStream dataOutput;
    private boolean writeDataAsBlocks;
    private DataOutputStream realOutput;
    private DataOutputStream blockDataOutput;
    private byte[] blockData;
    private int blockDataCount;
    private Object currentObject;
    ObjectStreamClass currentObjectStreamClass;
    private PutField currentPutField;
    private boolean fieldsAlreadyWritten;
    private boolean replacementEnabled;
    private boolean isSerializing;
    private int nextOID;
    private Hashtable OIDLookupTable;
    private int protocolVersion;
    private boolean useSubclassMethod;
    private SetAccessibleAction setAccessible;
    private int depth;
    private boolean dump;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void writeObject(Object var1_1) throws IOException {
        if (this.useSubclassMethod) {
            if (this.dump) {
                this.dumpElementln("WRITE OVERRIDE: " + var1_1);
            }
            this.writeObjectOverride(var1_1);
            return;
        }
        if (this.dump) {
            this.dumpElementln("WRITE: " + var1_1);
        }
        this.depth += 2;
        var2_2 = this.isSerializing;
        var3_3 = this.setBlockDataMode(false);
        try {
            try {
                block40: {
                    block39: {
                        block38: {
                            this.isSerializing = true;
                            var6_4 = false;
                            var7_7 = null;
                            while (true) {
                                block37: {
                                    block36: {
                                        block35: {
                                            block34: {
                                                if (var1_1 != null) break block34;
                                                this.realOutput.writeByte(112);
                                                ** GOTO lbl-1000
                                            }
                                            var8_9 = this.findHandle(var1_1);
                                            if (var8_9 == null) break block35;
                                            this.realOutput.writeByte(113);
                                            this.realOutput.writeInt(var8_9);
                                            ** GOTO lbl-1000
                                        }
                                        if (!(var1_1 instanceof Class)) break block36;
                                        var9_11 = (Class)var1_1;
                                        var10_12 = ObjectStreamClass.lookupForClassObject(var9_11);
                                        this.realOutput.writeByte(118);
                                        if (!var10_12.isProxyClass) {
                                            this.writeObject(var10_12);
                                        } else {
                                            this.realOutput.writeByte(125);
                                            var11_13 = var9_11.getInterfaces();
                                            this.realOutput.writeInt(((Class[])var11_13).length);
                                            var12_14 = false;
                                            while (true) {
                                                if (var12_14 >= ((Class[])var11_13).length) {
                                                    var12_14 = this.setBlockDataMode(true);
                                                    this.annotateProxyClass(var9_11);
                                                    this.setBlockDataMode(var12_14);
                                                    this.realOutput.writeByte(120);
                                                    this.writeObject(var10_12.getSuper());
                                                    break;
                                                }
                                                this.realOutput.writeUTF(var11_13[var12_14].getName());
                                                var12_14 += 1;
                                            }
                                        }
                                        this.assignNewHandle(var1_1);
                                        ** GOTO lbl-1000
                                    }
                                    if (!(var1_1 instanceof ObjectStreamClass)) break block37;
                                    this.writeClassDescriptor((ObjectStreamClass)var1_1);
                                    ** GOTO lbl-1000
                                }
                                var9_11 = var1_1.getClass();
                                var10_12 = ObjectStreamClass.lookupForClassObject(var9_11);
                                if (var10_12 == null) {
                                    throw new NotSerializableException(var9_11.getName());
                                }
                                if (!this.replacementEnabled && !(var1_1 instanceof Serializable) || var6_4) break;
                                var7_7 = var1_1;
                                if (var1_1 instanceof Serializable) {
                                    try {
                                        var11_13 = var10_12.writeReplaceMethod;
                                        if (var11_13 != null) {
                                            var1_1 = var11_13.invoke(var1_1, new Object[0]);
                                        }
                                    }
                                    catch (IllegalAccessException v0) {
                                    }
                                    catch (InvocationTargetException v1) {}
                                }
                                if (this.replacementEnabled) {
                                    var1_1 = this.replaceObject(var1_1);
                                }
                                var6_4 = true;
                            }
                            if (!(var1_1 instanceof String)) break block38;
                            this.realOutput.writeByte(116);
                            this.assignNewHandle(var1_1);
                            this.realOutput.writeUTF((String)var1_1);
                            ** GOTO lbl-1000
                        }
                        if (!var9_11.isArray()) break block39;
                        this.realOutput.writeByte(117);
                        this.writeObject(var10_12);
                        this.assignNewHandle(var1_1);
                        this.writeArraySizeAndElements(var1_1, var9_11.getComponentType());
                        ** GOTO lbl-1000
                    }
                    this.realOutput.writeByte(115);
                    this.writeObject(var10_12);
                    if (var6_4) {
                        this.assignNewHandle(var7_7);
                    } else {
                        this.assignNewHandle(var1_1);
                    }
                    if (!(var1_1 instanceof Externalizable)) break block40;
                    if (this.protocolVersion == 2) {
                        this.setBlockDataMode(true);
                    }
                    ((Externalizable)var1_1).writeExternal(this);
                    if (this.protocolVersion == 2) {
                        this.setBlockDataMode(false);
                        this.realOutput.writeByte(120);
                    }
                    ** GOTO lbl-1000
                }
                if (var1_1 instanceof Serializable == false) throw new NotSerializableException(var9_11.getName() + " in " + var1_1.getClass());
                var11_13 = this.currentObject;
                var12_15 = this.currentObjectStreamClass;
                this.currentObject = var1_1;
                var13_16 = ObjectStreamClass.getObjectStreamClasses(var9_11);
                var14_17 = 0;
                while (true) {
                    block41: {
                        if (var14_17 < var13_16.length) break block41;
                        this.currentObject = var11_13;
                        this.currentObjectStreamClass = var12_15;
                        this.currentPutField = null;
                        break;
                    }
                    this.currentObjectStreamClass = var13_16[var14_17];
                    this.fieldsAlreadyWritten = false;
                    if (this.currentObjectStreamClass.hasWriteMethod()) {
                        if (this.dump) {
                            this.dumpElementln("WRITE METHOD CALLED FOR: " + var1_1);
                        }
                        this.setBlockDataMode(true);
                        this.callWriteMethod(var1_1, this.currentObjectStreamClass);
                        this.setBlockDataMode(false);
                        this.realOutput.writeByte(120);
                        if (this.dump) {
                            this.dumpElementln("WRITE ENDBLOCKDATA FOR: " + var1_1);
                        }
                    } else {
                        if (this.dump) {
                            this.dumpElementln("WRITE FIELDS CALLED FOR: " + var1_1);
                        }
                        this.writeFields(var1_1, this.currentObjectStreamClass);
                    }
                    ++var14_17;
                }
            }
            catch (ObjectStreamException var6_5) {
                throw var6_5;
            }
            catch (IOException var6_6) {
                this.realOutput.writeByte(123);
                this.reset(true);
                this.setBlockDataMode(false);
                try {
                    this.writeObject(var6_6);
                }
                catch (IOException var7_8) {
                    var8_10 = new StreamCorruptedException(var7_8 + " thrown while exception was being written to stream.");
                    throw var8_10;
                }
                this.reset(true);
            }
        }
        catch (Throwable var4_18) {
            var5_19 = null;
            this.isSerializing = var2_2;
            this.setBlockDataMode(var3_3);
            this.depth -= 2;
            if (this.dump == false) throw var4_18;
            this.dumpElementln("END: " + var1_1);
            throw var4_18;
        }
lbl-1000:
        // 9 sources

        {
            var5_20 = null;
            this.isSerializing = var2_2;
        }
        this.setBlockDataMode(var3_3);
        this.depth -= 2;
        if (this.dump == false) return;
        this.dumpElementln("END: " + var1_1);
    }

    protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
        if (objectStreamClass.isProxyClass) {
            this.realOutput.writeByte(125);
            Class[] classArray = objectStreamClass.forClass().getInterfaces();
            this.realOutput.writeInt(classArray.length);
            boolean bl = false;
            while (bl < classArray.length) {
                this.realOutput.writeUTF(classArray[bl].getName());
                bl += 1;
            }
            this.assignNewHandle(objectStreamClass);
            bl = this.setBlockDataMode(true);
            this.annotateProxyClass(objectStreamClass.forClass());
            this.setBlockDataMode(bl);
            this.realOutput.writeByte(120);
        } else {
            this.realOutput.writeByte(114);
            this.realOutput.writeUTF(objectStreamClass.getName());
            this.realOutput.writeLong(objectStreamClass.getSerialVersionUID());
            this.assignNewHandle(objectStreamClass);
            int n = objectStreamClass.getFlags();
            if (this.protocolVersion == 2 && objectStreamClass.isExternalizable()) {
                n |= 8;
            }
            this.realOutput.writeByte(n);
            ObjectStreamField[] objectStreamFieldArray = objectStreamClass.fields;
            if (objectStreamFieldArray == ObjectStreamClass.INVALID_FIELDS) {
                throw new InvalidClassException(objectStreamClass.getName(), "serialPersistentFields is invalid");
            }
            this.realOutput.writeShort(objectStreamFieldArray.length);
            int n2 = 0;
            while (n2 < objectStreamFieldArray.length) {
                ObjectStreamField objectStreamField = objectStreamFieldArray[n2];
                this.realOutput.writeByte(objectStreamField.getTypeCode());
                this.realOutput.writeUTF(objectStreamField.getName());
                if (!objectStreamField.isPrimitive()) {
                    this.writeObject(objectStreamField.getTypeString());
                }
                ++n2;
            }
            n2 = this.setBlockDataMode(true) ? 1 : 0;
            this.annotateClass(objectStreamClass.forClass());
            this.setBlockDataMode(n2 != 0);
            this.realOutput.writeByte(120);
        }
        if (objectStreamClass.isSerializable() || objectStreamClass.isExternalizable()) {
            this.writeObject(objectStreamClass.getSuper());
        } else {
            this.writeObject(null);
        }
    }

    public void defaultWriteObject() throws IOException, NotActiveException {
        this.markFieldsWritten();
        this.writeFields(this.currentObject, this.currentObjectStreamClass);
    }

    private final void markFieldsWritten() throws IOException {
        if (this.currentObject == null || this.currentObjectStreamClass == null) {
            throw new NotActiveException("defaultWriteObject called by non-active class and/or object");
        }
        if (this.fieldsAlreadyWritten) {
            throw new IOException("Only one of writeFields and defaultWriteObject may be called, and it may only be called once");
        }
        this.fieldsAlreadyWritten = true;
    }

    public void reset() throws IOException {
        this.reset(false);
    }

    private final void reset(boolean bl) throws IOException {
        if (!bl) {
            if (this.isSerializing) {
                throw new IOException("Reset called while serialization in progress");
            }
            this.realOutput.writeByte(121);
        }
        this.clearHandles();
    }

    public void useProtocolVersion(int n) throws IOException {
        if (n != 1 && n != 2) {
            throw new IOException("Invalid protocol version requested.");
        }
        this.protocolVersion = n;
    }

    public static void setDefaultProtocolVersion(int n) throws IOException {
        if (n != 1 && n != 2) {
            throw new IOException("Invalid protocol version requested.");
        }
        defaultProtocolVersion = n;
    }

    protected void annotateClass(Class clazz) throws IOException {
    }

    protected void annotateProxyClass(Class clazz) throws IOException {
    }

    protected Object replaceObject(Object object) throws IOException {
        return object;
    }

    protected boolean enableReplaceObject(boolean bl) throws SecurityException {
        SecurityManager securityManager;
        if (bl && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SerializablePermission("enableSubstitution"));
        }
        boolean bl2 = this.replacementEnabled;
        this.replacementEnabled = bl;
        return bl2;
    }

    protected void writeStreamHeader() throws IOException {
        this.realOutput.writeShort(-21267);
        this.realOutput.writeShort(5);
    }

    protected void writeObjectOverride(Object object) throws NotActiveException, IOException {
        throw new NotActiveException("Subclass of ObjectOutputStream must implement writeObjectOverride");
    }

    public void write(int n) throws IOException {
        if (this.writeDataAsBlocks) {
            if (this.blockDataCount == 1024) {
                this.drain();
            }
            this.blockData[this.blockDataCount++] = (byte)n;
        } else {
            this.realOutput.write(n);
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.writeDataAsBlocks) {
            if (n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.blockDataCount + n2 < 1024) {
                System.arraycopy(byArray, n, this.blockData, this.blockDataCount, n2);
                this.blockDataCount += n2;
            } else {
                this.drain();
                this.writeBlockDataHeader(n2);
                this.realOutput.write(byArray, n, n2);
            }
        } else {
            this.realOutput.write(byArray, n, n2);
        }
    }

    public void flush() throws IOException {
        this.drain();
        this.realOutput.flush();
    }

    protected void drain() throws IOException {
        if (this.blockDataCount == 0) {
            return;
        }
        if (this.writeDataAsBlocks) {
            this.writeBlockDataHeader(this.blockDataCount);
        }
        this.realOutput.write(this.blockData, 0, this.blockDataCount);
        this.blockDataCount = 0;
    }

    public void close() throws IOException {
        this.flush();
        this.realOutput.close();
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.blockDataOutput.writeBoolean(bl);
    }

    public void writeByte(int n) throws IOException {
        this.blockDataOutput.writeByte(n);
    }

    public void writeShort(int n) throws IOException {
        this.blockDataOutput.writeShort(n);
    }

    public void writeChar(int n) throws IOException {
        this.blockDataOutput.writeChar(n);
    }

    public void writeInt(int n) throws IOException {
        this.blockDataOutput.writeInt(n);
    }

    public void writeLong(long l) throws IOException {
        this.blockDataOutput.writeLong(l);
    }

    public void writeFloat(float f) throws IOException {
        this.blockDataOutput.writeFloat(f);
    }

    public void writeDouble(double d) throws IOException {
        this.blockDataOutput.writeDouble(d);
    }

    public void writeBytes(String string) throws IOException {
        this.blockDataOutput.writeBytes(string);
    }

    public void writeChars(String string) throws IOException {
        this.dataOutput.writeChars(string);
    }

    public void writeUTF(String string) throws IOException {
        this.dataOutput.writeUTF(string);
    }

    public PutField putFields() throws IOException {
        if (this.currentPutField != null) {
            return this.currentPutField;
        }
        this.currentPutField = new PutField(){
            private byte[] prim_field_data;
            private Object[] objs;

            private final ObjectStreamField getField(String string) {
                ObjectStreamField objectStreamField = ObjectOutputStream.this.currentObjectStreamClass.getField(string);
                if (objectStreamField == null) {
                    throw new IllegalArgumentException("no such serializable field " + string);
                }
                return objectStreamField;
            }

            public final void put(String string, boolean bl) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'Z');
                this.prim_field_data[objectStreamField.getOffset()] = (byte)(bl ? 1 : 0);
            }

            public final void put(String string, byte by) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'B');
                this.prim_field_data[objectStreamField.getOffset()] = by;
            }

            public final void put(String string, char c) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'C');
                int n = objectStreamField.getOffset();
                this.prim_field_data[n++] = (byte)(c >>> 8);
                this.prim_field_data[n] = (byte)c;
            }

            public final void put(String string, double d) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'D');
                int n = objectStreamField.getOffset();
                long l = Double.doubleToLongBits(d);
                this.prim_field_data[n++] = (byte)(l >>> 52);
                this.prim_field_data[n++] = (byte)(l >>> 48);
                this.prim_field_data[n++] = (byte)(l >>> 40);
                this.prim_field_data[n++] = (byte)(l >>> 32);
                this.prim_field_data[n++] = (byte)(l >>> 24);
                this.prim_field_data[n++] = (byte)(l >>> 16);
                this.prim_field_data[n++] = (byte)(l >>> 8);
                this.prim_field_data[n] = (byte)l;
            }

            public final void put(String string, float f) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'F');
                int n = objectStreamField.getOffset();
                int n2 = Float.floatToIntBits(f);
                this.prim_field_data[n++] = (byte)(n2 >>> 24);
                this.prim_field_data[n++] = (byte)(n2 >>> 16);
                this.prim_field_data[n++] = (byte)(n2 >>> 8);
                this.prim_field_data[n] = (byte)n2;
            }

            public final void put(String string, int n) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'I');
                int n2 = objectStreamField.getOffset();
                this.prim_field_data[n2++] = (byte)(n >>> 24);
                this.prim_field_data[n2++] = (byte)(n >>> 16);
                this.prim_field_data[n2++] = (byte)(n >>> 8);
                this.prim_field_data[n2] = (byte)n;
            }

            public final void put(String string, long l) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'J');
                int n = objectStreamField.getOffset();
                this.prim_field_data[n++] = (byte)(l >>> 52);
                this.prim_field_data[n++] = (byte)(l >>> 48);
                this.prim_field_data[n++] = (byte)(l >>> 40);
                this.prim_field_data[n++] = (byte)(l >>> 32);
                this.prim_field_data[n++] = (byte)(l >>> 24);
                this.prim_field_data[n++] = (byte)(l >>> 16);
                this.prim_field_data[n++] = (byte)(l >>> 8);
                this.prim_field_data[n] = (byte)l;
            }

            public final void put(String string, short s) {
                ObjectStreamField objectStreamField = this.getField(string);
                this.checkType(objectStreamField, 'S');
                int n = objectStreamField.getOffset();
                this.prim_field_data[n++] = (byte)(s >>> 8);
                this.prim_field_data[n] = (byte)s;
            }

            public final void put(String string, Object object) {
                ObjectStreamField objectStreamField = this.getField(string);
                if (object != null && !objectStreamField.getType().isAssignableFrom(object.getClass())) {
                    throw new IllegalArgumentException("Class " + object.getClass() + " cannot be cast to " + objectStreamField.getType());
                }
                this.objs[objectStreamField.getOffset()] = object;
            }

            public final void write(ObjectOutput objectOutput) throws IOException {
                boolean bl = ObjectOutputStream.this.setBlockDataMode(false);
                objectOutput.write(this.prim_field_data);
                int n = 0;
                while (n < this.objs.length) {
                    objectOutput.writeObject(this.objs[n]);
                    ++n;
                }
                ObjectOutputStream.this.setBlockDataMode(bl);
            }

            private final void checkType(ObjectStreamField objectStreamField, char c) throws IllegalArgumentException {
                if (TypeSignature.getEncodingOfClass(objectStreamField.getType()).charAt(0) != c) {
                    throw new IllegalArgumentException();
                }
            }

            private final /* synthetic */ void this() {
                this.prim_field_data = new byte[ObjectOutputStream.this.currentObjectStreamClass.primFieldSize];
                this.objs = new Object[ObjectOutputStream.this.currentObjectStreamClass.objectFieldCount];
            }
            {
                this.this();
            }
        };
        return this.currentPutField;
    }

    public void writeFields() throws IOException {
        if (this.currentPutField == null) {
            throw new NotActiveException("writeFields can only be called after putFields has been called");
        }
        this.markFieldsWritten();
        this.currentPutField.write(this);
    }

    private final void writeBlockDataHeader(int n) throws IOException {
        if (n < 256) {
            this.realOutput.writeByte(119);
            this.realOutput.write(n);
        } else {
            this.realOutput.writeByte(122);
            this.realOutput.writeInt(n);
        }
    }

    private final Integer findHandle(Object object) {
        return (Integer)this.OIDLookupTable.get(new ObjectIdentityWrapper(object));
    }

    private final int assignNewHandle(Object object) {
        this.OIDLookupTable.put(new ObjectIdentityWrapper(object), new Integer(this.nextOID));
        return this.nextOID++;
    }

    private final void clearHandles() {
        this.nextOID = 0x7E0000;
        this.OIDLookupTable.clear();
    }

    private final void writeArraySizeAndElements(Object object, Class clazz) throws IOException {
        int n = Array.getLength(object);
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                this.realOutput.writeInt(n);
                int n2 = 0;
                while (n2 < n) {
                    this.realOutput.writeBoolean(blArray[n2]);
                    ++n2;
                }
                return;
            }
            if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                this.realOutput.writeInt(n);
                this.realOutput.write(byArray, 0, n);
                return;
            }
            if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                this.realOutput.writeInt(n);
                int n3 = 0;
                while (n3 < n) {
                    this.realOutput.writeChar(cArray[n3]);
                    ++n3;
                }
                return;
            }
            if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                this.realOutput.writeInt(n);
                int n4 = 0;
                while (n4 < n) {
                    this.realOutput.writeDouble(dArray[n4]);
                    ++n4;
                }
                return;
            }
            if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                this.realOutput.writeInt(n);
                int n5 = 0;
                while (n5 < n) {
                    this.realOutput.writeFloat(fArray[n5]);
                    ++n5;
                }
                return;
            }
            if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                this.realOutput.writeInt(n);
                int n6 = 0;
                while (n6 < n) {
                    this.realOutput.writeInt(nArray[n6]);
                    ++n6;
                }
                return;
            }
            if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                this.realOutput.writeInt(n);
                int n7 = 0;
                while (n7 < n) {
                    this.realOutput.writeLong(lArray[n7]);
                    ++n7;
                }
                return;
            }
            if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                this.realOutput.writeInt(n);
                int n8 = 0;
                while (n8 < n) {
                    this.realOutput.writeShort(sArray[n8]);
                    ++n8;
                }
                return;
            }
        } else {
            Object[] objectArray = (Object[])object;
            this.realOutput.writeInt(n);
            int n9 = 0;
            while (n9 < n) {
                this.writeObject(objectArray[n9]);
                ++n9;
            }
        }
    }

    private final void writeFields(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        ObjectStreamField[] objectStreamFieldArray = objectStreamClass.fields;
        boolean bl = this.setBlockDataMode(false);
        int n = 0;
        while (n < objectStreamFieldArray.length) {
            String string = objectStreamFieldArray[n].getName();
            Class clazz = objectStreamFieldArray[n].getType();
            if (this.dump) {
                this.dumpElementln("WRITE FIELD: " + string + " type=" + clazz);
            }
            if (clazz == Boolean.TYPE) {
                this.realOutput.writeBoolean(this.getBooleanField(object, objectStreamClass.forClass(), string));
            } else if (clazz == Byte.TYPE) {
                this.realOutput.writeByte(this.getByteField(object, objectStreamClass.forClass(), string));
            } else if (clazz == Character.TYPE) {
                this.realOutput.writeChar(this.getCharField(object, objectStreamClass.forClass(), string));
            } else if (clazz == Double.TYPE) {
                this.realOutput.writeDouble(this.getDoubleField(object, objectStreamClass.forClass(), string));
            } else if (clazz == Float.TYPE) {
                this.realOutput.writeFloat(this.getFloatField(object, objectStreamClass.forClass(), string));
            } else if (clazz == Integer.TYPE) {
                this.realOutput.writeInt(this.getIntField(object, objectStreamClass.forClass(), string));
            } else if (clazz == Long.TYPE) {
                this.realOutput.writeLong(this.getLongField(object, objectStreamClass.forClass(), string));
            } else if (clazz == Short.TYPE) {
                this.realOutput.writeShort(this.getShortField(object, objectStreamClass.forClass(), string));
            } else {
                this.writeObject(this.getObjectField(object, objectStreamClass.forClass(), string, objectStreamFieldArray[n].getTypeString()));
            }
            ++n;
        }
        this.setBlockDataMode(bl);
    }

    boolean setBlockDataMode(boolean bl) throws IOException {
        if (bl == this.writeDataAsBlocks) {
            return bl;
        }
        this.drain();
        boolean bl2 = this.writeDataAsBlocks;
        this.writeDataAsBlocks = bl;
        this.dataOutput = bl ? this.blockDataOutput : this.realOutput;
        return bl2;
    }

    private final void callWriteMethod(Object object, ObjectStreamClass objectStreamClass) throws IOException {
        this.currentPutField = null;
        try {
            Object[] objectArray = new Object[]{this};
            objectStreamClass.writeObjectMethod.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            IOException iOException = new IOException("Exception thrown from writeObject() on " + objectStreamClass.forClass().getName() + ": " + throwable.getClass().getName());
            iOException.initCause(throwable);
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException("Failure invoking writeObject() on " + objectStreamClass.forClass().getName() + ": " + exception.getClass().getName());
            iOException.initCause(exception);
            throw iOException;
        }
    }

    private final boolean getBooleanField(Object object, Class clazz, String string) throws IOException {
        try {
            Field field = this.getField(clazz, string);
            boolean bl = field.getBoolean(object);
            return bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassException("invalid requested type for field " + string + " in class " + clazz.getName());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unexpected exception " + exception);
        }
    }

    private final byte getByteField(Object object, Class clazz, String string) throws IOException {
        try {
            Field field = this.getField(clazz, string);
            byte by = field.getByte(object);
            return by;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassException("invalid requested type for field " + string + " in class " + clazz.getName());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unexpected exception " + exception);
        }
    }

    private final char getCharField(Object object, Class clazz, String string) throws IOException {
        try {
            Field field = this.getField(clazz, string);
            char c = field.getChar(object);
            return c;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassException("invalid requested type for field " + string + " in class " + clazz.getName());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unexpected exception " + exception);
        }
    }

    private final double getDoubleField(Object object, Class clazz, String string) throws IOException {
        try {
            Field field = this.getField(clazz, string);
            double d = field.getDouble(object);
            return d;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassException("invalid requested type for field " + string + " in class " + clazz.getName());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unexpected exception " + exception);
        }
    }

    private final float getFloatField(Object object, Class clazz, String string) throws IOException {
        try {
            Field field = this.getField(clazz, string);
            float f = field.getFloat(object);
            return f;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassException("invalid requested type for field " + string + " in class " + clazz.getName());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unexpected exception " + exception);
        }
    }

    private final int getIntField(Object object, Class clazz, String string) throws IOException {
        try {
            Field field = this.getField(clazz, string);
            int n = field.getInt(object);
            return n;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassException("invalid requested type for field " + string + " in class " + clazz.getName());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unexpected exception " + exception);
        }
    }

    private final long getLongField(Object object, Class clazz, String string) throws IOException {
        try {
            Field field = this.getField(clazz, string);
            long l = field.getLong(object);
            return l;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassException("invalid requested type for field " + string + " in class " + clazz.getName());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unexpected exception " + exception);
        }
    }

    private final short getShortField(Object object, Class clazz, String string) throws IOException {
        try {
            Field field = this.getField(clazz, string);
            short s = field.getShort(object);
            return s;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidClassException("invalid requested type for field " + string + " in class " + clazz.getName());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unexpected exception " + exception);
        }
    }

    private final Object getObjectField(Object object, Class clazz, String string, String string2) throws IOException {
        try {
            Field field = this.getField(clazz, string);
            ObjectStreamField objectStreamField = new ObjectStreamField(field.getName(), field.getType());
            if (objectStreamField.isPrimitive()) {
                throw new InvalidClassException("invalid type code for " + string + " in class " + clazz.getName() + " : object stream field is primitive");
            }
            if (!objectStreamField.getTypeString().equals(string2)) {
                throw new InvalidClassException("invalid type code for " + string + " in class " + clazz.getName() + " : object stream field " + objectStreamField + " has type string " + objectStreamField.getTypeString() + " instead of " + string2);
            }
            Object object2 = field.get(object);
            return object2;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    private final Field getField(Class clazz, String string) throws InvalidClassException {
        try {
            Field field = clazz.getDeclaredField(string);
            this.setAccessible.setMember(field);
            AccessController.doPrivileged(this.setAccessible);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new InvalidClassException("no field called " + string + " in class " + clazz.getName());
        }
    }

    private final void dumpElementln(String string) {
        int n = 0;
        while (n < this.depth) {
            System.out.print(" ");
            ++n;
        }
        System.out.print(Thread.currentThread() + ": ");
        System.out.println(string);
    }

    private final /* synthetic */ void this() {
        this.setAccessible = new SetAccessibleAction();
        this.depth = 0;
        this.dump = false;
    }

    public ObjectOutputStream(OutputStream outputStream) throws IOException {
        this.this();
        this.realOutput = new DataOutputStream(outputStream);
        this.blockData = new byte[1024];
        this.blockDataCount = 0;
        this.blockDataOutput = new DataOutputStream(this);
        this.setBlockDataMode(true);
        this.replacementEnabled = false;
        this.isSerializing = false;
        this.nextOID = 0x7E0000;
        this.OIDLookupTable = new Hashtable();
        this.protocolVersion = defaultProtocolVersion;
        this.useSubclassMethod = false;
        this.writeStreamHeader();
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        this.this();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.useSubclassMethod = true;
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, Object var2);

        public abstract void write(ObjectOutput var1) throws IOException;
    }
}

