/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class PKIXParameters
implements CertPathParameters {
    private final Set trustAnchors = new HashSet();
    private final Set initPolicies = new HashSet();
    private final List certStores = new LinkedList();
    private final List pathCheckers = new LinkedList();
    private boolean revocationEnabled = true;
    private boolean exPolicyRequired = false;
    private boolean policyMappingInhibited = false;
    private boolean anyPolicyInhibited = false;
    private boolean policyQualRejected = true;
    private Date date;
    private String sigProvider;
    private CertSelector targetConstraints;

    public Set getTrustAnchors() {
        return Collections.unmodifiableSet(this.trustAnchors);
    }

    public void setTrustAnchors(Set set) throws InvalidAlgorithmParameterException {
        if (set.isEmpty()) {
            throw new InvalidAlgorithmParameterException("no trust anchors");
        }
        this.trustAnchors.clear();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.trustAnchors.add((TrustAnchor)iterator.next());
        }
    }

    public Set getInitialPolicies() {
        return Collections.unmodifiableSet(this.initPolicies);
    }

    public void setInitialPolicies(Set set) {
        this.initPolicies.clear();
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.initPolicies.add((String)iterator.next());
        }
    }

    public void addCertStore(CertStore certStore) {
        if (certStore != null) {
            this.certStores.add(certStore);
        }
    }

    public List getCertStores() {
        return Collections.unmodifiableList(this.certStores);
    }

    public void setCertStores(List list2) {
        this.certStores.clear();
        if (list2 == null) {
            return;
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            this.certStores.add((CertStore)iterator.next());
        }
    }

    public boolean isRevocationEnabled() {
        return this.revocationEnabled;
    }

    public void setRevocationEnabled(boolean bl) {
        this.revocationEnabled = bl;
    }

    public boolean isExplicitPolicyRequired() {
        return this.exPolicyRequired;
    }

    public void setExplicitPolicyRequired(boolean bl) {
        this.exPolicyRequired = bl;
    }

    public boolean isPolicyMappingInhibited() {
        return this.policyMappingInhibited;
    }

    public void setPolicyMappingInhibited(boolean bl) {
        this.policyMappingInhibited = bl;
    }

    public boolean isAnyPolicyInhibited() {
        return this.anyPolicyInhibited;
    }

    public void setAnyPolicyInhibited(boolean bl) {
        this.anyPolicyInhibited = bl;
    }

    public boolean getPolicyQualifiersRejected() {
        return this.policyQualRejected;
    }

    public void setPolicyQualifiersRejected(boolean bl) {
        this.policyQualRejected = bl;
    }

    public Date getDate() {
        return this.date != null ? (Date)this.date.clone() : null;
    }

    public void setDate(Date date) {
        this.date = date != null ? (Date)date.clone() : null;
    }

    public void addCertPathChecker(PKIXCertPathChecker pKIXCertPathChecker) {
        if (pKIXCertPathChecker != null) {
            this.pathCheckers.add(pKIXCertPathChecker);
        }
    }

    public List getCertPathCheckers() {
        return Collections.unmodifiableList(this.pathCheckers);
    }

    public void setCertPathCheckers(List list2) {
        this.pathCheckers.clear();
        if (list2 == null) {
            return;
        }
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            this.pathCheckers.add((PKIXCertPathChecker)iterator.next());
        }
    }

    public String getSigProvider() {
        return this.sigProvider;
    }

    public void setSigProvider(String string) {
        this.sigProvider = string;
    }

    public CertSelector getTargetCertConstraints() {
        return this.targetConstraints != null ? (CertSelector)this.targetConstraints.clone() : null;
    }

    public void setTargetCertConstraints(CertSelector certSelector) {
        this.targetConstraints = certSelector != null ? (CertSelector)certSelector.clone() : null;
    }

    public Object clone() {
        return new PKIXParameters(this);
    }

    public String toString() {
        return "[ Trust Anchors: " + this.trustAnchors + "; Initial Policy OIDs=" + (this.initPolicies != null ? this.initPolicies.toString() : "any") + "; Validity Date=" + this.date + "; Signature Provider=" + this.sigProvider + "; Default Revocation Enabled=" + this.revocationEnabled + "; Explicit Policy Required=" + this.exPolicyRequired + "; Policy Mapping Inhibited=" + this.policyMappingInhibited + "; Any Policy Inhibited=" + this.anyPolicyInhibited + "; Policy Qualifiers Rejected=" + this.policyQualRejected + "; Target Cert Contstraints=" + this.targetConstraints + "; Certification Path Checkers=" + this.pathCheckers + "; CertStores=" + this.certStores + " ]";
    }

    public PKIXParameters(KeyStore keyStore) throws KeyStoreException, InvalidAlgorithmParameterException {
        this();
        Enumeration enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate certificate;
            String string = (String)enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string) || !((certificate = keyStore.getCertificate(string)) instanceof X509Certificate)) continue;
            this.trustAnchors.add(new TrustAnchor((X509Certificate)certificate, null));
        }
        if (this.trustAnchors.isEmpty()) {
            throw new InvalidAlgorithmParameterException("no certs in the key store");
        }
    }

    public PKIXParameters(Set set) throws InvalidAlgorithmParameterException {
        this();
        this.setTrustAnchors(set);
    }

    private PKIXParameters() {
    }

    private PKIXParameters(PKIXParameters pKIXParameters) {
        this();
        this.trustAnchors.addAll(pKIXParameters.trustAnchors);
        this.initPolicies.addAll(pKIXParameters.initPolicies);
        this.certStores.addAll(pKIXParameters.certStores);
        this.pathCheckers.addAll(pKIXParameters.pathCheckers);
        this.revocationEnabled = pKIXParameters.revocationEnabled;
        this.exPolicyRequired = pKIXParameters.exPolicyRequired;
        this.policyMappingInhibited = pKIXParameters.policyMappingInhibited;
        this.anyPolicyInhibited = pKIXParameters.anyPolicyInhibited;
        this.policyQualRejected = pKIXParameters.policyQualRejected;
        this.date = pKIXParameters.date;
        this.sigProvider = pKIXParameters.sigProvider;
        this.targetConstraints = pKIXParameters.targetConstraints != null ? (CertSelector)pKIXParameters.targetConstraints.clone() : null;
    }
}

