/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import org.xbill.DNS.WireParseException;

public class DNSInput {
    private byte[] array;
    private int pos;
    private int end;
    private int saved_pos;
    private int saved_end;

    public int current() {
        return this.pos;
    }

    public int remaining() {
        return this.end - this.pos;
    }

    private final void require(int n) throws WireParseException {
        if (n > this.remaining()) {
            throw new WireParseException("end of input");
        }
    }

    public void setActive(int n) {
        if (n > this.array.length - this.pos) {
            throw new IllegalArgumentException("cannot set active region past end of input");
        }
        this.end = this.pos + n;
    }

    public void clearActive() {
        this.end = this.array.length;
    }

    public void jump(int n) {
        if (n >= this.array.length) {
            throw new IllegalArgumentException("cannot jump past end of input");
        }
        this.pos = n;
        this.end = this.array.length;
    }

    public void save() {
        this.saved_pos = this.pos;
        this.saved_end = this.end;
    }

    public void restore() {
        if (this.saved_pos < 0) {
            throw new IllegalStateException("no previous state");
        }
        this.pos = this.saved_pos;
        this.end = this.saved_end;
        this.saved_pos = -1;
        this.saved_end = -1;
    }

    public int readU8() throws WireParseException {
        this.require(1);
        return this.array[this.pos++] & 0xFF;
    }

    public int readU16() throws WireParseException {
        this.require(2);
        int n = this.array[this.pos++] & 0xFF;
        int n2 = this.array[this.pos++] & 0xFF;
        return (n << 8) + n2;
    }

    public long readU32() throws WireParseException {
        this.require(4);
        int n = this.array[this.pos++] & 0xFF;
        int n2 = this.array[this.pos++] & 0xFF;
        int n3 = this.array[this.pos++] & 0xFF;
        int n4 = this.array[this.pos++] & 0xFF;
        return ((long)n << 24) + (long)(n2 << 16) + (long)(n3 << 8) + (long)n4;
    }

    public void readByteArray(byte[] byArray, int n, int n2) throws WireParseException {
        this.require(n2);
        System.arraycopy(this.array, this.pos, byArray, n, n2);
        this.pos += n2;
    }

    public byte[] readByteArray(int n) throws WireParseException {
        this.require(n);
        byte[] byArray = new byte[n];
        System.arraycopy(this.array, this.pos, byArray, 0, n);
        this.pos += n;
        return byArray;
    }

    public byte[] readByteArray() {
        int n = this.remaining();
        byte[] byArray = new byte[n];
        System.arraycopy(this.array, this.pos, byArray, 0, n);
        this.pos += n;
        return byArray;
    }

    public byte[] readCountedString() throws WireParseException {
        this.require(1);
        int n = this.array[this.pos++] & 0xFF;
        return this.readByteArray(n);
    }

    public DNSInput(byte[] byArray) {
        this.array = byArray;
        this.pos = 0;
        this.end = this.array.length;
        this.saved_pos = -1;
        this.saved_end = -1;
    }
}

