/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import net.claribole.zvtm.glyphs.projection.ProjQdCurve;

public class VQdCurve
extends Glyph {
    long vs;
    long vrad;
    float ang;
    ProjQdCurve[] pc;

    public VQdCurve(long x, long y, int z, long s, Color c, float or, long ctrlDist1, float or1) {
        this.vx = x;
        this.vy = y;
        this.vz = z;
        this.vs = s;
        this.sensit = false;
        this.orient = or;
        this.vrad = ctrlDist1;
        this.ang = or1;
        this.computeSize();
        this.setColor(c);
    }

    public void setCtrlPoint(long d, float o) {
        this.vrad = d;
        this.ang = o;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    public long getCtrlPointRadius() {
        return this.vrad;
    }

    public float getCtrlPointAngle() {
        return this.ang;
    }

    public void initCams(int nbCam) {
        this.pc = new ProjQdCurve[nbCam];
        for (int i = 0; i < nbCam; ++i) {
            this.pc[i] = new ProjQdCurve();
        }
    }

    public void addCamera(int verifIndex) {
        if (this.pc != null) {
            if (verifIndex == this.pc.length) {
                ProjQdCurve[] ta = this.pc;
                this.pc = new ProjQdCurve[ta.length + 1];
                for (int i = 0; i < ta.length; ++i) {
                    this.pc[i] = ta[i];
                }
                this.pc[this.pc.length - 1] = new ProjQdCurve();
            } else {
                System.err.println("VQdCurve:Error while adding camera " + verifIndex);
            }
        } else if (verifIndex == 0) {
            this.pc = new ProjQdCurve[1];
            this.pc[0] = new ProjQdCurve();
        } else {
            System.err.println("VQdCurve:Error while adding camera " + verifIndex);
        }
    }

    public void removeCamera(int index) {
        this.pc[index] = null;
    }

    public void resetMouseIn() {
        for (int i = 0; i < this.pc.length; ++i) {
            this.resetMouseIn(i);
        }
    }

    public void resetMouseIn(int i) {
        if (this.pc[i] != null) {
            this.pc[i].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float angle) {
        this.orient = angle;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.size = this.vs;
    }

    public void sizeTo(float radius) {
        this.vrad = Math.round((float)this.vrad * radius / this.size);
        this.size = radius;
        this.vs = Math.round(this.size);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void reSize(float factor) {
        this.size *= factor;
        this.vs = Math.round(this.size);
        this.vrad = Math.round((float)this.vrad * factor);
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean fillsView(long w, long h, int camIndex) {
        return false;
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return false;
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.pc[camIndex].curve.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    public short mouseInOut(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        return 0;
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].cr = Math.round((float)this.vs * this.coef);
        if (this.pc[i].cr > 1) {
            this.pc[i].start.setLocation((double)this.pc[i].cx + (double)this.pc[i].cr * Math.cos(this.orient), (double)this.pc[i].cy + (double)this.pc[i].cr * Math.sin(this.orient));
            this.pc[i].end.setLocation((double)this.pc[i].cx - (double)this.pc[i].cr * Math.cos(this.orient), (double)this.pc[i].cy - (double)this.pc[i].cr * Math.sin(this.orient));
            this.pc[i].ctrl.setLocation(this.pc[i].cx + (int)Math.round((double)(this.coef * (float)this.vrad) * Math.cos(this.orient - this.ang)), this.pc[i].cy + (int)Math.round((double)(this.coef * (float)this.vrad) * Math.sin(this.orient - this.ang)));
            this.pc[i].curve.setCurve(this.pc[i].start, this.pc[i].ctrl, this.pc[i].end);
        }
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].lcr = Math.round((float)this.vs * this.coef);
        if (this.pc[i].lcr > 1) {
            this.pc[i].lstart.setLocation((double)this.pc[i].lcx + (double)this.pc[i].lcr * Math.cos(this.orient), (double)this.pc[i].lcy + (double)this.pc[i].lcr * Math.sin(this.orient));
            this.pc[i].lend.setLocation((double)this.pc[i].lcx - (double)this.pc[i].lcr * Math.cos(this.orient), (double)this.pc[i].lcy - (double)this.pc[i].lcr * Math.sin(this.orient));
            this.pc[i].lctrl.setLocation(this.pc[i].lcx + (int)Math.round((double)(this.coef * (float)this.vrad) * Math.cos(this.orient - this.ang)), this.pc[i].lcy + (int)Math.round((double)(this.coef * (float)this.vrad) * Math.sin(this.orient - this.ang)));
            this.pc[i].lcurve.setCurve(this.pc[i].lstart, this.pc[i].lctrl, this.pc[i].lend);
        }
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        if (this.pc[i].cr > 1) {
            if (this.stroke != null) {
                g.setStroke(this.stroke);
                g.translate(dx, dy);
                g.draw(this.pc[i].curve);
                g.translate(-dx, -dy);
                g.setStroke(stdS);
            } else {
                g.translate(dx, dy);
                g.draw(this.pc[i].curve);
                g.translate(-dx, -dy);
            }
        } else {
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        g.setColor(this.color);
        if (this.pc[i].lcr > 1) {
            if (this.stroke != null) {
                g.setStroke(this.stroke);
                g.translate(dx, dy);
                g.draw(this.pc[i].lcurve);
                g.translate(-dx, -dy);
                g.setStroke(stdS);
            } else {
                g.translate(dx, dy);
                g.draw(this.pc[i].lcurve);
                g.translate(-dx, -dy);
            }
        } else {
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public Object clone() {
        VQdCurve res = new VQdCurve(this.vx, this.vy, 0, this.vs, this.color, this.orient, this.vrad, this.ang);
        res.mouseInsideColor = this.mouseInsideColor;
        return res;
    }

    public void highlight(boolean b, Color selectedColor) {
    }
}

