/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego.run;

import br.arca.morcego.Config;
import br.arca.morcego.Morcego;
import br.arca.morcego.physics.PunctualBody;
import br.arca.morcego.physics.Vector3D;
import br.arca.morcego.run.ControlledRunnable;
import br.arca.morcego.structure.Graph;
import br.arca.morcego.structure.Link;
import br.arca.morcego.structure.Node;
import java.util.Enumeration;
import java.util.Vector;

public class Balancer
extends ControlledRunnable {
    private boolean balancing = true;
    private boolean balancingLock = false;
    private Graph graph;
    private int balancedCount;

    public Balancer(Graph g) {
        this.graph = g;
        this.balancedCount = 0;
    }

    public void stop() {
        if (!this.balancingLock) {
            this.balancing = false;
        }
    }

    public void lockBalance() {
        this.balancingLock = true;
    }

    public void unlockBalance() {
        this.balancingLock = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awake() {
        this.balancing = true;
        Balancer balancer = this;
        synchronized (balancer) {
            this.notify();
        }
    }

    private void blow(Node node) {
        int levelDifference;
        PunctualBody body = node.getBody();
        try {
            levelDifference = node.getLevel() - this.graph.getCenterNode().getLevel();
        }
        catch (NullPointerException e) {
            return;
        }
        float windIntensity = (float)levelDifference * Config.getFloat(Config.springSize) - this.graph.getOrientation().scalarProduct(body);
        Vector3D wind = this.graph.getOrientation().multiplyByScalar(windIntensity * Config.getFloat(Config.windIntensity));
        node.getBody().getInstantForce().add(wind);
    }

    public void run() {
        Thread.currentThread().setPriority(1);
        try {
            int cycleCount = 0;
            this.running = true;
            while (this.running) {
                this.waitUntilBalancingIsNeeded();
                this.runBalancingEngine();
                this.finishedBalancing();
                if (cycleCount % 20 == 0) {
                    cycleCount = 0;
                    this.checkSystemStability();
                }
                ++cycleCount;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void runBalancingEngine() {
        this.checkAllForces();
        this.balance();
        Morcego.getCamera().adjustPosition(this.graph);
    }

    private void finishedBalancing() throws InterruptedException {
        if (this.balancing) {
            this.balancedCount = 0;
        }
        Morcego.notifyRenderer();
        Thread.sleep(Config.getInteger("morcego.balancingStepInterval"));
    }

    private void balance() {
        Enumeration en = this.getNodes().elements();
        while (en.hasMoreElements()) {
            Node node = (Node)en.nextElement();
            node.move();
        }
    }

    private void checkSystemStability() {
        Enumeration en = this.getNodes().elements();
        boolean stable = true;
        while (stable && en.hasMoreElements()) {
            Node node = (Node)en.nextElement();
            if (!(node.getBody().getSpeed().module() > 1.0f)) continue;
            stable = false;
        }
        if (stable) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllForces() {
        boolean isTree = Config.getBoolean(Config.graphIsTree);
        Graph graph = this.graph;
        synchronized (graph) {
            int j = 0;
            while (j < this.getNodes().size()) {
                Node node1 = (Node)this.getNodes().elementAt(j);
                if (isTree) {
                    this.blow(node1);
                }
                int k = j + 1;
                while (k < this.getNodes().size()) {
                    Node node2 = (Node)this.getNodes().elementAt(k);
                    Vector3D force = node1.getBody().repel(node2.getBody());
                    node1.getBody().getInstantForce().add(force);
                    node2.getBody().getInstantForce().add(force.opposite());
                    ++k;
                }
                ++j;
            }
            j = 0;
            while (j < this.getLinks().size()) {
                Link link = (Link)this.getLinks().elementAt(j);
                Vector3D force = link.getSpring().strech();
                link.getNode1().getBody().getInstantForce().add(force);
                link.getNode2().getBody().getInstantForce().add(force.opposite());
                ++j;
            }
            j = 0;
            while (j < this.getNodes().size()) {
                ((Node)this.getNodes().elementAt(j)).getBody().applyForce();
                ++j;
            }
        }
    }

    private Vector getNodes() {
        return this.graph.getVisibleNodes();
    }

    private Vector getLinks() {
        return this.graph.getVisibleLinks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilBalancingIsNeeded() throws InterruptedException {
        while (!this.balancing) {
            Balancer balancer = this;
            synchronized (balancer) {
                this.wait();
            }
        }
    }

    public void notifyBalanced(Node node) {
        ++this.balancedCount;
        if (this.balancedCount == this.graph.getVisibleNodes().size()) {
            this.stop();
        }
    }
}

