module FileUtils
  SHELL_COMMAND_FILTER = []

  alias sh_original sh
  def sh(*cmd, &block)
    cmd = SHELL_COMMAND_FILTER.inject(cmd){|c,filter| filter.call(c) or c }
    sh_original(*cmd, &block)
  end

  def add_sh_filter(&block)
    SHELL_COMMAND_FILTER << block
  end

  def add_sh_filter_for(pattern, &block)
    add_sh_filter {|cmd|
      if cmd[0] =~ pattern
        block.call(cmd)
      else
        cmd
      end
    }
  end
end
