/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ListPeer;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class List
extends Component
implements ItemSelectable,
Accessible {
    private static final long serialVersionUID = -3304312411574666869L;
    private Vector items;
    private boolean multipleMode;
    private int rows;
    private int[] selected;
    private int visibleIndex;
    private ItemListener item_listeners;
    private ActionListener action_listeners;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.items.size();
    }

    public synchronized String[] getItems() {
        Object[] objectArray = new String[this.getItemCount()];
        this.items.copyInto(objectArray);
        return objectArray;
    }

    public String getItem(int n) {
        return (String)this.items.elementAt(n);
    }

    public int getRows() {
        return this.rows;
    }

    public boolean isMultipleMode() {
        return this.allowsMultipleSelections();
    }

    public boolean allowsMultipleSelections() {
        return this.multipleMode;
    }

    public void setMultipleMode(boolean bl) {
        this.setMultipleSelections(bl);
    }

    public void setMultipleSelections(boolean bl) {
        this.multipleMode = bl;
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            listPeer.setMultipleMode(bl);
        }
    }

    public Dimension getMinimumSize() {
        return this.getMinimumSize(this.getRows());
    }

    public Dimension minimumSize() {
        return this.minimumSize(this.getRows());
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension minimumSize(int n) {
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            return listPeer.minimumSize(n);
        }
        return new Dimension(0, 0);
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getRows());
    }

    public Dimension preferredSize() {
        return this.preferredSize(this.getRows());
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    public Dimension preferredSize(int n) {
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            return listPeer.preferredSize(n);
        }
        return this.getSize();
    }

    public void add(String string) {
        this.add(string, -1);
    }

    public void addItem(String string) {
        this.addItem(string, -1);
    }

    public void add(String string, int n) {
        this.addItem(string, n);
    }

    public void addItem(String string, int n) {
        if (n == -1 || n >= this.items.size()) {
            this.items.addElement(string);
        } else {
            this.items.insertElementAt(string, n);
        }
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            listPeer.add(string, n);
        }
    }

    public void delItem(int n) throws IllegalArgumentException {
        this.items.removeElementAt(n);
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            listPeer.delItems(n, n);
        }
    }

    public void remove(int n) throws IllegalArgumentException {
        this.delItem(n);
    }

    public synchronized void delItems(int n, int n2) throws IllegalArgumentException {
        if (n < 0 || n >= this.items.size()) {
            throw new IllegalArgumentException("Bad list start index value: " + n);
        }
        if (n < 0 || n >= this.items.size()) {
            throw new IllegalArgumentException("Bad list start index value: " + n);
        }
        if (n > n2) {
            throw new IllegalArgumentException("Start is greater than end!");
        }
        int n3 = n2;
        while (n3 >= n) {
            this.items.removeElementAt(n3);
            --n3;
        }
        if (this.peer != null) {
            ListPeer listPeer = (ListPeer)this.peer;
            listPeer.delItems(n, n2);
        }
    }

    public synchronized void remove(String string) throws IllegalArgumentException {
        int n = this.items.indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException("List element to delete not found");
        }
        this.remove(n);
    }

    public synchronized void removeAll() {
        this.clear();
    }

    public void clear() {
        this.items.clear();
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            listPeer.removeAll();
        }
    }

    public synchronized void replaceItem(String string, int n) throws IllegalArgumentException {
        if (n < 0 || n >= this.items.size()) {
            throw new IllegalArgumentException("Bad list index: " + n);
        }
        this.items.insertElementAt(string, n + 1);
        this.items.removeElementAt(n);
        if (this.peer != null) {
            ListPeer listPeer = (ListPeer)this.peer;
            listPeer.add(string, n + 1);
            listPeer.delItems(n, n);
        }
    }

    public synchronized int getSelectedIndex() {
        if (this.peer != null) {
            ListPeer listPeer = (ListPeer)this.peer;
            this.selected = listPeer.getSelectedIndexes();
        }
        if (this.selected == null || this.selected.length != 1) {
            return -1;
        }
        return this.selected[0];
    }

    public synchronized int[] getSelectedIndexes() {
        if (this.peer != null) {
            ListPeer listPeer = (ListPeer)this.peer;
            this.selected = listPeer.getSelectedIndexes();
        }
        return this.selected;
    }

    public synchronized String getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return (String)this.items.elementAt(n);
    }

    public synchronized String[] getSelectedItems() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[nArray.length];
        if (stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = (String)this.items.elementAt(nArray[n]);
                ++n;
            }
        }
        return stringArray;
    }

    public synchronized Object[] getSelectedObjects() {
        int[] nArray = this.getSelectedIndexes();
        if (nArray == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[nArray.length];
        if (objectArray.length > 0) {
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = this.items.elementAt(nArray[n]);
                ++n;
            }
        }
        return objectArray;
    }

    public boolean isIndexSelected(int n) {
        return this.isSelected(n);
    }

    public boolean isSelected(int n) {
        int[] nArray = this.getSelectedIndexes();
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized void makeVisible(int n) throws IllegalArgumentException {
        if (n < 0 || n >= this.items.size()) {
            throw new IllegalArgumentException("Bad list index: " + n);
        }
        this.visibleIndex = n;
        if (this.peer != null) {
            ListPeer listPeer = (ListPeer)this.peer;
            listPeer.makeVisible(n);
        }
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public synchronized void select(int n) {
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            listPeer.select(n);
        }
    }

    public synchronized void deselect(int n) {
        ListPeer listPeer = (ListPeer)this.getPeer();
        if (listPeer != null) {
            listPeer.deselect(n);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createList(this);
        }
        super.addNotify();
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.action_listeners = AWTEventMulticaster.add(this.action_listeners, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.action_listeners = AWTEventMulticaster.remove(this.action_listeners, actionListener);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, itemListener);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        } else if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
        } else {
            super.processEvent(aWTEvent);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.action_listeners != null) {
            this.action_listeners.actionPerformed(actionEvent);
        }
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(itemEvent);
        }
    }

    void dispatchEventImpl(AWTEvent aWTEvent) {
        if (aWTEvent.id <= 701 && aWTEvent.id >= 701 && (this.item_listeners != null || (this.eventMask & 0x200L) != 0L)) {
            this.processEvent(aWTEvent);
        } else if (aWTEvent.id <= 1001 && aWTEvent.id >= 1001 && (this.action_listeners != null || (this.eventMask & 0x80L) != 0L)) {
            this.processEvent(aWTEvent);
        } else {
            super.dispatchEventImpl(aWTEvent);
        }
    }

    protected String paramString() {
        return "multiple=" + this.multipleMode + ",rows=" + this.rows + super.paramString();
    }

    public EventListener[] getListeners(Class clazz) {
        Class clazz2 = class$java$awt$event$ActionListener;
        if (clazz2 == null) {
            clazz2 = class$java$awt$event$ActionListener = List.class("[Ljava.awt.event.ActionListener;", false);
        }
        if (clazz == clazz2) {
            return AWTEventMulticaster.getListeners(this.action_listeners, clazz);
        }
        Class clazz3 = class$java$awt$event$ItemListener;
        if (clazz3 == null) {
            clazz3 = class$java$awt$event$ItemListener = List.class("[Ljava.awt.event.ItemListener;", false);
        }
        if (clazz == clazz3) {
            return AWTEventMulticaster.getListeners(this.item_listeners, clazz);
        }
        return super.getListeners(clazz);
    }

    public ActionListener[] getActionListeners() {
        Class clazz = class$java$awt$event$ActionListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ActionListener = List.class("[Ljava.awt.event.ActionListener;", false);
        }
        return (ActionListener[])this.getListeners(clazz);
    }

    public ItemListener[] getItemListeners() {
        Class clazz = class$java$awt$event$ItemListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ItemListener = List.class("[Ljava.awt.event.ItemListener;", false);
        }
        return (ItemListener[])this.getListeners(clazz);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTList();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.items = new Vector();
    }

    public List() {
        this(4, false);
    }

    public List(int n) {
        this(n, false);
    }

    public List(int n, boolean bl) {
        this.this();
        this.rows = n;
        this.multipleMode = bl;
        this.selected = new int[0];
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTList
    extends Component.AccessibleAWTComponent
    implements AccessibleSelection,
    ItemListener,
    ActionListener {
        private static final long serialVersionUID = 7924617370136012829L;

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            if (List.this.isMultipleMode()) {
                accessibleStateSet.add(AccessibleState.MULTISELECTABLE);
            }
            return accessibleStateSet;
        }

        public int getAccessibleChildrenCount() {
            return List.this.getItemCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n >= List.this.getItemCount()) {
                return null;
            }
            return new AccessibleAWTListChild(List.this, n);
        }

        public int getAccessibleSelectionCount() {
            return List.this.getSelectedIndexes().length;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int n) {
            int[] nArray = List.this.getSelectedIndexes();
            if (n >= nArray.length) {
                return null;
            }
            return new AccessibleAWTListChild(List.this, nArray[n]);
        }

        public boolean isAccessibleChildSelected(int n) {
            return List.this.isIndexSelected(n);
        }

        public void addAccessibleSelection(int n) {
            List.this.select(n);
        }

        public void removeAccessibleSelection(int n) {
            List.this.deselect(n);
        }

        public void clearAccessibleSelection() {
            int n = 0;
            while (n < List.this.getItemCount()) {
                List.this.deselect(n);
                ++n;
            }
        }

        public void selectAllAccessibleSelection() {
            if (List.this.isMultipleMode()) {
                int n = 0;
                while (n < List.this.getItemCount()) {
                    List.this.select(n);
                    ++n;
                }
            }
        }

        public void itemStateChanged(ItemEvent itemEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public AccessibleAWTList() {
            List.this.addItemListener(this);
            List.this.addActionListener(this);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleAWTListChild
        extends Component.AccessibleAWTComponent
        implements Accessible {
            private static final long serialVersionUID = 4412022926028300317L;
            private List parent;
            private int indexInParent;

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LIST_ITEM;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
                if (this.parent.isIndexSelected(this.indexInParent)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                return accessibleStateSet;
            }

            public int getAccessibleIndexInParent() {
                return this.indexInParent;
            }

            public AccessibleAWTListChild(List list2, int n) {
                this.parent = list2;
                this.indexInParent = n;
                if (list2 == null) {
                    this.indexInParent = -1;
                }
            }
        }
    }
}

