/*
 * Decompiled with CFR 0.152.
 */
package beagleutil;

import beagleutil.ThreadSafeIndexer;
import java.util.Arrays;

public final class SampleIds {
    private static final SampleIds sampleIds = new SampleIds();
    private final ThreadSafeIndexer<String> indexer;

    private SampleIds() {
        int n = 5000;
        this.indexer = new ThreadSafeIndexer(n);
    }

    public static SampleIds instance() {
        return sampleIds;
    }

    public int getIndex(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("id.isEmpty()");
        }
        return this.indexer.getIndex(string);
    }

    public int[] getIndices(String[] stringArray) {
        for (String string : stringArray) {
            if (!string.isEmpty()) continue;
            throw new IllegalArgumentException("id.isEmpty()");
        }
        return this.indexer.getIndices((String[])stringArray);
    }

    public int getIndexIfIndexed(String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("id.isEmpty()");
        }
        return this.indexer.getIndexIfIndexed(string);
    }

    public int size() {
        return this.indexer.size();
    }

    public String id(int n) {
        return this.indexer.item(n);
    }

    public String[] ids(int[] nArray) {
        return this.indexer.items(nArray).toArray(new String[0]);
    }

    public String[] ids() {
        return this.indexer.items().toArray(new String[0]);
    }

    public String toString() {
        return Arrays.toString(this.ids());
    }
}

