/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ic.doc.scenebeans.pick;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.util.LinkedList;
import java.util.List;
import uk.ac.ic.doc.scenebeans.CompositeNode;
import uk.ac.ic.doc.scenebeans.Input;
import uk.ac.ic.doc.scenebeans.Primitive;
import uk.ac.ic.doc.scenebeans.SceneGraph;
import uk.ac.ic.doc.scenebeans.SceneGraphProcessor;
import uk.ac.ic.doc.scenebeans.Style;
import uk.ac.ic.doc.scenebeans.Transform;

public class Picker
implements SceneGraphProcessor {
    private Graphics2D _gfx_context;
    private Point2D _point;
    private LinkedList _path = new LinkedList();
    private boolean _pick_successful = false;

    public static List pick(Graphics2D graphics2D, SceneGraph sceneGraph, double d, double d2) throws NoninvertibleTransformException {
        return Picker.pick(graphics2D, sceneGraph, new Point2D.Double(d, d2));
    }

    public static List pick(Graphics2D graphics2D, SceneGraph sceneGraph, Point2D point2D) throws NoninvertibleTransformException {
        try {
            Picker picker = new Picker(graphics2D, point2D);
            sceneGraph.accept(picker);
            return picker.getPath();
        }
        catch (PickFailure pickFailure) {
            throw pickFailure.cause;
        }
    }

    private Picker(Graphics2D graphics2D, Point2D point2D) {
        this._gfx_context = graphics2D;
        this._point = point2D;
    }

    List getPath() {
        return this._path;
    }

    public void process(Primitive primitive) {
        Shape shape = primitive.getShape(this._gfx_context);
        if (shape.contains(this._point)) {
            this._path.addFirst(primitive);
            this._pick_successful = true;
        }
    }

    public void process(CompositeNode compositeNode) {
        int n = 0;
        while (n < compositeNode.getVisibleSubgraphCount()) {
            SceneGraph sceneGraph = compositeNode.getVisibleSubgraph(n);
            sceneGraph.accept(this);
            if (this._pick_successful) {
                this._path.addFirst(sceneGraph);
                return;
            }
            ++n;
        }
    }

    public void process(Transform transform) {
        Point2D point2D = this._point;
        try {
            this._point = transform.getTransform().inverseTransform(this._point, null);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new PickFailure(noninvertibleTransformException);
        }
        SceneGraph sceneGraph = transform.getTransformedGraph();
        sceneGraph.accept(this);
        this._point = point2D;
        if (this._pick_successful) {
            this._path.addFirst(sceneGraph);
            return;
        }
    }

    public void process(Style style) {
        Style.Change change = style.changeStyle(this._gfx_context);
        SceneGraph sceneGraph = style.getStyledGraph();
        sceneGraph.accept(this);
        change.restoreStyle(this._gfx_context);
        if (this._pick_successful) {
            this._path.addFirst(sceneGraph);
            return;
        }
    }

    public void process(Input input) {
        SceneGraph sceneGraph = input.getSensitiveGraph();
        sceneGraph.accept(this);
        if (this._pick_successful) {
            this._path.addFirst(sceneGraph);
            return;
        }
    }

    private class PickFailure
    extends RuntimeException {
        NoninvertibleTransformException cause;

        PickFailure(NoninvertibleTransformException noninvertibleTransformException) {
            this.cause = noninvertibleTransformException;
        }
    }
}

