/*
 * Copyright (C) 1997-2004, R3vis Corporation.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA, or visit http://www.gnu.org/copyleft/lgpl.html.
 *
 * Original Contributor:
 *   Wes Bethel, R3vis Corporation, Marin County, California
 * Additional Contributor(s):
 *
 * The OpenRM project is located at http://openrm.sourceforge.net/.
 */
/*
 * $Id: rmx.h,v 1.4 2004/01/17 04:06:42 wes Exp $
 * Version: $Name: OpenRM-1-5-2-RC3 $
 * $Revision: 1.4 $
 * $Log: rmx.h,v $
 * Revision 1.4  2004/01/17 04:06:42  wes
 * Updated Copyright line for 2004.
 *
 * Revision 1.3  2003/10/03 19:16:17  wes
 * Unified naming changes - use rmPipeSet/GetContext rather than use
 * a platform-specific name.
 *
 * Revision 1.2  2003/02/02 02:07:14  wes
 * Updated copyright to 2003.
 *
 * Revision 1.1.1.1  2003/01/28 02:15:23  wes
 * Manual rebuild of rm150 repository.
 *
 * Revision 1.10  2003/01/27 05:04:27  wes
 * Changes to RMpipe API and initialization sequence to unify GLX, WGL and CR
 * platforms w/o too much disruption to existing apps.
 *
 * Revision 1.9  2003/01/16 22:21:15  wes
 * Updated all source files to reflect new organization of header files:
 * all header files formerly located in include/rmaux, include/rmi, include/rmv
 * are now located in include/rm.
 *
 * Revision 1.8  2002/12/31 00:56:21  wes
 * Cleaned up arch-specific portions of RMpipe to support Chromium.
 *
 * Revision 1.7  2002/04/30 19:42:33  wes
 * Updated copyright dates.
 *
 * Revision 1.6  2001/10/15 00:18:24  wes
 * Function prototype for rmPipeSetOffscreenWindow().
 *
 * Revision 1.5  2000/12/03 23:20:22  wes
 * Thread-safety mods.
 *
 * Revision 1.4  2000/05/14 23:36:12  wes
 * Added attrib to RMpipe to allow control over how the OpenGL
 * matrix stack is initialized during rendering.
 *
 * Revision 1.3  2000/04/20 17:41:46  wes
 * Minor CVS tag changes.
 *
 * Revision 1.2  2000/04/20 16:30:24  wes
 * Added copyright info.
 *
 * Revision 1.1.1.1  2000/02/28 21:29:40  wes
 * OpenRM 1.2 Checkin
 *
 * Revision 1.1.1.1  2000/02/28 17:18:48  wes
 * Initial entry - pre-RM120 release, source base for OpenRM 1.2.
 *
 */

#ifndef _rmx_h
#define _rmx_h

#ifdef __cplusplus
extern "C" {
#endif

#if 0
    /* moved to rmtypes.h */
typedef struct RMpipe
{
    Display     *xdisplay;
    XVisualInfo *xvisual;
    Window       xdrawable;
    GLXContext   glxcontext;
    Colormap     xcolormap;
    
    RMenum       channel_format;
    int          xwindow_width, xwindow_height;
    int          xflags;
    RMenum       opaque3DEnable, transparent3DEnable, opaque2DEnable;
    RMenum       initMatrixStack;	/* RM_TRUE or RM_FALSE */

    /* render function */
    void (*channel_render_func)(RMnode *t, struct RMpipe *p);

    /*
     * optional app callback invoked after rendering, but before
     * the "swapbuffers" call. can be used to perform synchronization
     * between multiple rendering engines.
     */
    void (*postRenderBarrierFunc)(struct RMpipe *p);

    /* color and depth buffer acquisition, swap buffer function */
    void (*postrenderfunc)(const RMimage *, RMenum whichBufferEnum);
    void (*postrender_depthbufferfunc)(const RMimage *, RMenum whichBufferEnum);
    void (*swapbuffunc)(struct RMpipe *);

    char   name[32];		/* temp hack */

    /* the context cache */
    RMcontextCache *cache;
} RMpipe;
#endif


/* rmprivat.h: rasterization of text using X [1] */
int          rmxBitmapFromText (char *string, int font_enum, int size_enum, int bold_enum, int italic_enum, RMbitmap **bitmap_return);

/* rmx.c: pipes, windows, visuals [16] */
RMenum       rmxPipeSetDisplay (RMpipe *p, Display *d);
Display     *rmxPipeGetDisplay (const RMpipe *p);

RMenum       rmxPipeSetColormap (RMpipe *toModify, const Colormap newCmap);
Colormap     rmxPipeGetColormap (const RMpipe *pipe);
Colormap     rmxGetSharableColormap (Display *, XVisualInfo *v);
RMenum       rmxPipeSetVisual (RMpipe *pipe, XVisualInfo *visual);
XVisualInfo *rmxPipeGetVisual (const RMpipe *pipe);

RMenum       rmPipeSetWindow (RMpipe *, Window w, int width, int height);
RMenum       rmPipeSetOffscreenWindow (RMpipe *, GLXPixmap glxp, int width, int height);
Window       rmPipeGetWindow (const RMpipe *);
RMenum       rmPipeSwapBuffersX11 (const RMpipe *);

GLXContext   rmPipeGetContext (const RMpipe *pipe);
RMenum       rmPipeSetContext (RMpipe *pipe, const GLXContext context);

#ifdef __cplusplus
}
#endif

#endif /* _rmx_h */
/* EOF */
