/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.util;

import com.google.common.primitives.Ints;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.util.AbstractSeekingIterator;
import org.iq80.leveldb.util.InternalIterator;
import org.iq80.leveldb.util.Slice;

public final class MergingIterator
extends AbstractSeekingIterator<InternalKey, Slice> {
    private final List<? extends InternalIterator> levels;
    private final PriorityQueue<ComparableIterator> priorityQueue;
    private final Comparator<InternalKey> comparator;

    public MergingIterator(List<? extends InternalIterator> levels, Comparator<InternalKey> comparator) {
        this.levels = levels;
        this.comparator = comparator;
        this.priorityQueue = new PriorityQueue(levels.size() + 1);
        this.resetPriorityQueue(comparator);
    }

    @Override
    protected void seekToFirstInternal() {
        for (InternalIterator internalIterator : this.levels) {
            internalIterator.seekToFirst();
        }
        this.resetPriorityQueue(this.comparator);
    }

    @Override
    protected void seekInternal(InternalKey targetKey) {
        for (InternalIterator internalIterator : this.levels) {
            internalIterator.seek(targetKey);
        }
        this.resetPriorityQueue(this.comparator);
    }

    private void resetPriorityQueue(Comparator<InternalKey> comparator) {
        int i = 1;
        for (InternalIterator internalIterator : this.levels) {
            if (!internalIterator.hasNext()) continue;
            this.priorityQueue.add(new ComparableIterator(internalIterator, comparator, i++, (Map.Entry)internalIterator.next()));
        }
    }

    @Override
    protected Map.Entry<InternalKey, Slice> getNextElement() {
        Object result = null;
        ComparableIterator nextIterator = this.priorityQueue.poll();
        if (nextIterator != null) {
            result = nextIterator.next();
            if (nextIterator.hasNext()) {
                this.priorityQueue.add(nextIterator);
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MergingIterator");
        sb.append("{levels=").append(this.levels);
        sb.append(", comparator=").append(this.comparator);
        sb.append('}');
        return sb.toString();
    }

    private static class ComparableIterator
    implements Iterator<Map.Entry<InternalKey, Slice>>,
    Comparable<ComparableIterator> {
        private final InternalIterator iterator;
        private final Comparator<InternalKey> comparator;
        private final int ordinal;
        private Map.Entry<InternalKey, Slice> nextElement;

        private ComparableIterator(InternalIterator iterator, Comparator<InternalKey> comparator, int ordinal, Map.Entry<InternalKey, Slice> nextElement) {
            this.iterator = iterator;
            this.comparator = comparator;
            this.ordinal = ordinal;
            this.nextElement = nextElement;
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public Map.Entry<InternalKey, Slice> next() {
            if (this.nextElement == null) {
                throw new NoSuchElementException();
            }
            Map.Entry<InternalKey, Slice> result = this.nextElement;
            this.nextElement = this.iterator.hasNext() ? (Map.Entry)this.iterator.next() : null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ComparableIterator comparableIterator = (ComparableIterator)o;
            if (this.ordinal != comparableIterator.ordinal) {
                return false;
            }
            return !(this.nextElement != null ? !((Object)this.nextElement).equals(comparableIterator.nextElement) : comparableIterator.nextElement != null);
        }

        public int hashCode() {
            int result = this.ordinal;
            result = 31 * result + (this.nextElement != null ? ((Object)this.nextElement).hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(ComparableIterator that) {
            int result = this.comparator.compare(this.nextElement.getKey(), that.nextElement.getKey());
            if (result == 0) {
                result = Ints.compare((int)this.ordinal, (int)that.ordinal);
            }
            return result;
        }
    }
}

