searchData={"items":[{"type":"module","title":"eldap","doc":"LDAP Client\n\nThis module provides a client api to the Lightweight Directory Access Protocol\n(LDAP).\n\nReferences:\n\n- RFC 4510 - RFC 4519\n- RFC 2830\n\nThe above publications can be found at [IETF](http://www.ietf.org).\n\nTerminology abbreviations:\n\n- Dn. An LDAPDN is defined to be the representation of a Distinguished Name\n   (DN) after encoding according to the specification in [RFC4514].","ref":"eldap.html"},{"type":"function","title":"eldap.add/3","doc":"Add an entry. The entry must not exist.\n\n```erlang\n  add(Handle,\n      \"cn=Bill Valentine, ou=people, o=Example Org, dc=example, dc=com\",\n       [{\"objectclass\", [\"person\"]},\n        {\"cn\", [\"Bill Valentine\"]},\n        {\"sn\", [\"Valentine\"]},\n        {\"telephoneNumber\", [\"545 555 00\"]}]\n     )\n```","ref":"eldap.html#add/3"},{"type":"function","title":"eldap.and/1","doc":"Creates a filter where all `Filter` must be true.","ref":"eldap.html#and/1"},{"type":"function","title":"eldap.approxMatch/2","doc":"Create a approximation match filter.","ref":"eldap.html#approxMatch/2"},{"type":"function","title":"eldap.baseObject/0","doc":"Search baseobject only.","ref":"eldap.html#baseObject/0"},{"type":"function","title":"eldap.close/1","doc":"Shutdown the connection after sending an unbindRequest to the server.\n\nIf the connection is TLS the connection will be closed with `ssl:close/1`, otherwise\nwith `gen_tcp:close/1`.","ref":"eldap.html#close/1"},{"type":"function","title":"eldap.delete/2","doc":"Delete an entry.\n\n```text\n  delete(Handle, \"cn=Bill Valentine, ou=people, o=Example Org, dc=example, dc=com\")\n```","ref":"eldap.html#delete/2"},{"type":"function","title":"eldap.derefAlways/0","doc":"Always dereference aliases.","ref":"eldap.html#derefAlways/0"},{"type":"function","title":"eldap.derefFindingBaseObj/0","doc":"Dereference aliases only in finding the base.","ref":"eldap.html#derefFindingBaseObj/0"},{"type":"function","title":"eldap.derefInSearching/0","doc":"Dereference aliases only when searching.","ref":"eldap.html#derefInSearching/0"},{"type":"function","title":"eldap.equalityMatch/2","doc":"Create a equality filter.","ref":"eldap.html#equalityMatch/2"},{"type":"function","title":"eldap.extensibleMatch/2","doc":"Creates an extensible match filter. For example,\n\n```erlang\n  eldap:extensibleMatch(\"Bar\", [{type,\"sn\"}, {matchingRule,\"caseExactMatch\"}]))\n```\n\ncreates a filter which performs a `caseExactMatch` on the attribute `sn` and\nmatches with the value `\"Bar\"`. The default value of `dnAttributes` is `false`.","ref":"eldap.html#extensibleMatch/2"},{"type":"function","title":"eldap.greaterOrEqual/2","doc":"Create a greater or equal filter.","ref":"eldap.html#greaterOrEqual/2"},{"type":"function","title":"eldap.info/1","doc":"Currently available information reveals the socket and the transport protocol,\nTCP or TLS (SSL), used by the LDAP connection.","ref":"eldap.html#info/1"},{"type":"function","title":"eldap.lessOrEqual/2","doc":"Create a less or equal filter.","ref":"eldap.html#lessOrEqual/2"},{"type":"function","title":"eldap.mod_add/2","doc":"Create an add modification operation.","ref":"eldap.html#mod_add/2"},{"type":"function","title":"eldap.mod_delete/2","doc":"Create a delete modification operation.","ref":"eldap.html#mod_delete/2"},{"type":"function","title":"eldap.mod_replace/2","doc":"Create a replace modification operation.","ref":"eldap.html#mod_replace/2"},{"type":"function","title":"eldap.modify/3","doc":"Modify an entry.\n\n```erlang\n  modify(Handle, \"cn=Bill Valentine, ou=people, o=Example Org, dc=example, dc=com\",\n         [eldap:mod_replace(\"telephoneNumber\", [\"555 555 00\"]),\n\t  eldap:mod_add(\"description\", [\"LDAP Hacker\"]) ])\n```","ref":"eldap.html#modify/3"},{"type":"function","title":"eldap.modify_dn/5","doc":"Modify the DN of an entry.\n\n`DeleteOldRDN` indicates whether the current RDN\nshould be removed from the attribute list after the operation. `NewSupDN` is the\nnew parent that the RDN shall be moved to. If the old parent should remain as\nparent, `NewSupDN` shall be \"\".\n\n```text\n  modify_dn(Handle, \"cn=Bill Valentine, ou=people, o=Example Org, dc=example, dc=com \",\n            \"cn=Bill Jr Valentine\", true, \"\")\n```","ref":"eldap.html#modify_dn/5"},{"type":"function","title":"eldap.modify_password/3","doc":"Modify the password of a user. See `modify_password/4`.","ref":"eldap.html#modify_password/3"},{"type":"function","title":"eldap.modify_password/4","doc":"Modify the password of a user.\n\n- `Dn`. The user to modify. Should be \"\" if the modify request is for the user\n  of the LDAP session.\n- `NewPasswd`. The new password to set. Should be \"\" if the server is to\n  generate the password. In this case, the result will be `{ok, GenPasswd}`.\n- `OldPasswd`. Sometimes required by server policy for a user to change their\n  password. If not required, use `modify_password/3`.","ref":"eldap.html#modify_password/4"},{"type":"function","title":"eldap.neverDerefAliases/0","doc":"Never dereference aliases, treat aliases as entries.","ref":"eldap.html#neverDerefAliases/0"},{"type":"function","title":"eldap.not/1","doc":"Negate a filter.","ref":"eldap.html#not/1"},{"type":"function","title":"eldap.open/1","doc":"Setup a connection to an LDAP server, the `HOST`'s are tried in order.","ref":"eldap.html#open/1"},{"type":"function","title":"eldap.open/2","doc":"Setup a connection to an LDAP server, the `HOST`'s are tried in order.\n\nThe log function takes three arguments,\n`fun(Level, FormatString, [FormatArg]) end`.\n\nTimeout set the maximum time in milliseconds that each server request may take.\n\nAll TCP socket options are accepted except `active`, `binary`, `deliver`,\n`list`, `mode` and `packet`","ref":"eldap.html#open/2"},{"type":"function","title":"eldap.or/1","doc":"Create a filter where at least one of the `Filter` must be true.","ref":"eldap.html#or/1"},{"type":"function","title":"eldap.paged_result_control/1","doc":"paged_result_control(PageSize) -> {control, \"1.2.840.113556.1.4.319\", true,\nbinary()}\n\nPaged results is an extension to the LDAP protocol specified by RFC2696\n\nThis function creates a control with the specified page size for use in\n`search/3`, for example:\n\n```erlang\nControl = eldap:paged_result_control(50),\n{ok, SearchResults} = search(Handle, [{base, \"dc=example, dc=com\"}], [Control]),\n```","ref":"eldap.html#paged_result_control/1"},{"type":"function","title":"eldap.paged_result_control/2","doc":"paged_result_control(PageSize, Cookie) -> {control, \"1.2.840.113556.1.4.319\",\ntrue, binary()}\n\nPaged results is an extension to the LDAP protocol specified by RFC2696\n\nThis function creates a control with the specified page size and cookie for use\nin `search/3` to retrieve the next results page.\n\nFor example:\n\n```erlang\nPageSize = 50,\nControl1 = eldap:paged_result_control(PageSize),\n{ok, SearchResults1} = search(Handle, [{base, \"dc=example, dc=com\"}], [Control1]),\n%% retrieve the returned cookie from the search results\n{ok, Cookie1} = eldap:paged_result_cookie(SearchResults1),\nControl2 = eldap:paged_result_control(PageSize, Cookie1),\n{ok, SearchResults2} = eldap:search(Handle, [{base, \"dc=example,dc=com\"}], [Control2]),\n%% etc\n```","ref":"eldap.html#paged_result_control/2"},{"type":"function","title":"eldap.paged_result_cookie/1","doc":"paged_result_cookie(SearchResult) -> binary()\n\nPaged results is an extension to the LDAP protocol specified by RFC2696.\n\nThis function extracts the cookie returned from the server as a result of a\npaged search result.\n\nIf the returned cookie is the empty string `\"\"`, then these search results\nrepresent the last in the series.","ref":"eldap.html#paged_result_cookie/1"},{"type":"function","title":"eldap.present/1","doc":"Create a filter which filters on attribute type presence.","ref":"eldap.html#present/1"},{"type":"function","title":"eldap.search/2","doc":"Search the directory with the supplied the SearchOptions.\n\nThe base and filter\noptions must be supplied. Default values: scope is `wholeSubtree/0`, deref is\n`derefAlways/0`, types_only is `false` and timeout is `0` (meaning infinity).\n\n```erlang\n  Filter = eldap:substrings(\"cn\", [{any,\"V\"}]),\n  search(Handle, [{base, \"dc=example, dc=com\"}, {filter, Filter}, {attributes, [\"cn\"]}]),\n```\n\nThe `timeout` option in the `SearchOptions` is for the ldap server, while the\ntimeout in [eldap:open/2](`open/2`) is used for each individual request in the\nsearch operation.","ref":"eldap.html#search/2"},{"type":"function","title":"eldap.simple_bind/3","doc":"Authenticate the connection using simple authentication.","ref":"eldap.html#simple_bind/3"},{"type":"function","title":"eldap.singleLevel/0","doc":"Search the specified level only, i.e. do not recurse.","ref":"eldap.html#singleLevel/0"},{"type":"function","title":"eldap.start_tls/2","doc":"Same as start_tls(Handle, Options, infinity)","ref":"eldap.html#start_tls/2"},{"type":"function","title":"eldap.start_tls/3","doc":"Upgrade the connection associated with `Handle` to a TLS connection if possible.\n\nThe upgrade is done in two phases: first the server is asked for permission to\nupgrade. Second, if the request is acknowledged, the upgrade to TLS is\nperformed.\n\nError responses from phase one will not affect the current encryption state of\nthe connection. Those responses are:\n\n- **`tls_already_started`** - The connection is already encrypted. The\n  connection is not affected.\n\n- **`{response,ResponseFromServer}`** - The upgrade was refused by the LDAP\n  server. The `ResponseFromServer` is an atom delivered byt the LDAP server\n  explained in section 2.3 of rfc 2830. The connection is not affected, so it is\n  still un-encrypted.\n\nErrors in the second phase will however end the connection:\n\n- **`Error`** - Any error responded from ssl:connect/3\n\nThe `Timeout` parameter is for the actual TLS upgrade (phase 2) while the\ntimeout in [eldap:open/2](`open/2`) is used for the initial negotiation about\nupgrade (phase 1).","ref":"eldap.html#start_tls/3"},{"type":"function","title":"eldap.substrings/2","doc":"Create a filter which filters on substrings.","ref":"eldap.html#substrings/2"},{"type":"function","title":"eldap.wholeSubtree/0","doc":"Search the entire subtree.","ref":"eldap.html#wholeSubtree/0"},{"type":"type","title":"eldap.attribute/0","doc":"The attributes of an entry","ref":"eldap.html#t:attribute/0"},{"type":"type","title":"eldap.connection_info/0","doc":"The LDAP socket and the transport protocol, TCP or TLS (SSL), used by the ldap connection","ref":"eldap.html#t:connection_info/0"},{"type":"opaque","title":"eldap.dereference/0","doc":"How to handle aliases during a search.\nSee `neverDerefAliases/0`, `derefInSearching/0`, `derefFindingBaseObj/0`, `derefAlways/0`","ref":"eldap.html#t:dereference/0"},{"type":"type","title":"eldap.filter/0","doc":"An opaque type representing a filter operation.\n\nSee the filter creation functions for more info, including,\n`present/1`, `substrings/2`, `equalityMatch/2`,\n`greaterOrEqual/2`, `lessOrEqual/2`,\n`approxMatch/2`, `extensibleMatch/2`,\n`'and'/1`, `'or'/1`, `'not'/1`","ref":"eldap.html#t:filter/0"},{"type":"type","title":"eldap.handle/0","doc":"An opaque handle unique for the connection","ref":"eldap.html#t:handle/0"},{"type":"type","title":"eldap.modify_op/0","doc":"Entry modification operations.\nSee `mod_add/2`, `mod_delete/2`, `mod_replace/2`","ref":"eldap.html#t:modify_op/0"},{"type":"type","title":"eldap.referrals/0","doc":"The LDAP Server Address.\nThe contents of `Address` is server dependent.","ref":"eldap.html#t:referrals/0"},{"type":"opaque","title":"eldap.scope/0","doc":"Scope of a search.\nSee `baseObject/0`, `singleLevel/0`, `wholeSubtree/0`","ref":"eldap.html#t:scope/0"},{"type":"type","title":"eldap.search_option/0","doc":"A requested set of serach options for seaching the directory","ref":"eldap.html#t:search_option/0"},{"type":"extras","title":"Eldap Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Eldap Release Notes\n\nThis document describes the changes made to the Eldap application.","ref":"notes.html"},{"type":"extras","title":"Eldap 1.2.13 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-13"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.2.12 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- Add missing dependency to asn1 application\n\n  Own Id: OTP-18810","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eldap 1.2.11 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-11"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- Added a new function eldap:info/1 that returns the socket and the transport\n  protocol for the eldap connection.\n\n  Own Id: OTP-18480","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.2.10 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- Fix eldap extensibleMatch dnAttributes option.\n\n  According to the ldap ASN1 the dnAttributes should be a bool, instead it was\n  generated as a string.\n\n  Own Id: OTP-17877 Aux Id: PR-5615","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- Implemented paged searches according to\n  https://www.rfc-editor.org/rfc/rfc2696.txt\n\n  Own Id: OTP-17924 Aux Id: PR-5538","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.2.9 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-9"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- Add ability to specify size limit on ldap requests\n\n  Own Id: OTP-17166 Aux Id: PR-2904","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.2.8 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- Fix dialyzer warnings in eldap when not matching the return value of\n  ssl:close/1.\n\n  Own Id: OTP-15775","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eldap 1.2.7 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-7"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- Back port of bug fix ERL-893 from OTP-22 and document enhancements that will\n  solve dialyzer warnings for users of the ssl application.\n\n  This change also affects public_key, eldap (and inet doc).\n\n  Own Id: OTP-15785 Aux Id: ERL-929, ERL-893, PR-2215","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.2.6 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- A race condition at close could cause the eldap client to exit with a badarg\n  message as cause.\n\n  Own Id: OTP-15342 Aux Id: ERIERL-242","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eldap 1.2.5 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eldap 1.2.4 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-4"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- Update to use the new string api instead of the old.\n\n  Own Id: OTP-15036","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.2.3.1 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- A race condition at close could cause the eldap client to exit with a badarg\n  message as cause.\n\n  Own Id: OTP-15342 Aux Id: ERIERL-242","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eldap 1.2.3 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- Removed all old unused files in the documentation.\n\n  Own Id: OTP-14475 Aux Id: ERL-409, PR-1493","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eldap 1.2.2.1 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- A race condition at close could cause the eldap client to exit with a badarg\n  message as cause.\n\n  Own Id: OTP-15342 Aux Id: ERIERL-242","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eldap 1.2.2 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- If the underlying tcp connection is closed and an LDAP operation returned\n  tcp_error, the client applications tend to close the ldap handle with\n  eldap:close. This will cause a `{nocatch, {gen_tcp_error, ...}}` exception.\n\n  Such errors are now ignored during close, because the socket will be closed\n  anyway.\n\n  Own Id: OTP-13590 Aux Id: PR-1048","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- Modernize test suites\n\n  Own Id: OTP-13566","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.2.1 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- ELDAP did not send an `'unBind'` request before closing the connection.\n\n  Own Id: OTP-13327","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- Handles the `referral` result code from LDAP servers. Adds the return value\n  `{ok, {referral,UrlList}}` to some functions. See the Eldap reference manual\n  for details.\n\n  Own Id: OTP-12272","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.2 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-2"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- Support added for LDAP Password Modify Extended Operation (RFC 3062). Thanks\n  to danielwhite.\n\n  Own Id: OTP-12282","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.1.1 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- Corrects that `eldap:close/1` returned a tuple instead of the specified atom\n  `ok`.\n\n  Own Id: OTP-12349","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- Clarification in the reference manual for `eldap:modify_dn/5`,\n  `eldap:search/2` and `eldap:start_tls/3`.\n\n  Own Id: OTP-12354\n\n- The eldap test suites are extended and re-organized.\n\n  Own Id: OTP-12355","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.1 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- Fixed that eldap:open did not use the Timeout parameter when calling\n  ssl:connect. (Thanks Wiesław Bieniek for reporting)\n\n  Own Id: OTP-12311","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- Added the LDAP filter `extensibleMatch`.\n\n  Own Id: OTP-12174","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.0.4 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-0-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- `eldap:open/2` and `eldap:open/3` gave wrong return values for option errors.\n\n  Own Id: OTP-12182","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- Nearly all TCP options are possible to give in the `eldap:open/2` call.\n\n  Own Id: OTP-12171","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.0.3 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-0-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744\n\n- Add support for IPv6 connections, By including the \\[inet6] option in\n  eldap:open/2. Default value is still \\[inet] (Thanks to Edwin Fine)\n\n  Own Id: OTP-11753\n\n- Fixed bug where eldap:search returned binaries instead of strings. (Thanks\n  Simon MacMullen for the report)\n\n  Own Id: OTP-11768","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eldap 1.0.2 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Eldap Release Notes","doc":"- Removed \\{verify,0\\} from ssl-options because eldap does not support peer\n  verification. Thanks to Florian Waas for reporting.\n\n  Own Id: OTP-11354","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- The ldap client eldap now supports the start_tls operation. This upgrades an\n  existing tcp connection to encryption using tls, if the server supports it.\n  See eldap:start_tls/2 and /3.\n\n  Own Id: OTP-11336","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.0.1 - Eldap Release Notes","doc":"","ref":"notes.html#eldap-1-0-1"},{"type":"extras","title":"Improvements and New Features - Eldap Release Notes","doc":"- Fixed various dialyzer warnings\n\n  Own Id: OTP-10403 Aux Id: kunagi-258 \\[169]\n\n- Configure the SSL options fully in eldap.\n\n  Own Id: OTP-10728","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eldap 1.0 - Eldap Release Notes","doc":"New application.","ref":"notes.html#eldap-1-0"}],"content_type":"text/plain","producer":{"name":"ex_doc","version":[48,46,51,52,46,49]}}