(game-module "ww2s-pac-41"
  (title "WWII (Std), Pacific, Dec 41")
  (blurb "The Pacific, 8 December 1941 (based on standard game)")
  (base-module "standard")
  (variants (see-all true))
  )

(game-module (instructions (
  "The lines are drawn; Axis on one side, Allies on the other, with"
  "only unconditional surrender to end the game."
  ""
  "The types of units, terrain, etc, are exactly those from the"
  "standard game.  So don't expect great historical accuracy!"
  "Instead focus on using your resources to win by whatever means"
  "works."
  )))

;; Preset the sides, which restricts this to post-Dec 1941, when the
;; sides were clearly lined up.

(side 1 (name "Allies") (adjective "Allied") (emblem-name "allies"))

(side 2 (name "Axis") (adjective "Axis") (emblem-name "axis"))

(set sides-min 2)
(set sides-max 2)

;; The terrain of the world will always be known.

(set terrain-seen true)

;; Bases predate the war, no secrets there.

(add base already-seen 100)

;;; Initial setup.

(add u* start-with 0)
(add u* independent-near-start 0)

(set synthesis-methods '(name-units-randomly))

;;; Scoring.

(scorekeeper (do last-side-wins))

;;; Terrain.

(area 140 85 (restrict 360 140 225 40) (latitude 20) (longitude 50))

(include "earth-1deg")

;; We want the rivers.

(include "t-e1-river")

;; Add land underneath USA mainland cities.

(area add 131 49 2 1 terrain plains)
(area add 130 50 2 1 terrain plains)
(area add 129 51 2 1 terrain plains)
(area add 128 52 2 1 terrain plains)

;;; Units.

(define uk 1)
(define fr 1)
(define us 1)
(define de 0)
(define it 0)
(define jp 2)
(define su 1)
(define zh 1)
(define es 0)
(define tr 0)

(define capital city)

(include "u-e1-1938")

;; Indonesia is Dutch.

(unit "Banjarmasin" (s 1))
(unit "Jakarta" (s 1))
(unit "Medan" (s 1))
(unit "Palembang" (s 1))
(unit "Surabaya" (s 1))
(unit "Ujung Pendang" (s 1))

;; Japanese conquests in China and Indochina.

(unit "Amoy" (s 2))
(unit "Canton" (s 2))
(unit "Hankow" (s 2))
(unit "Hanoi" (s 2))
(unit "Kaifeng" (s 2))
(unit "Nanking" (s 2))
(unit "Nanchang" (s 2))
(unit "Ningpo" (s 2))
(unit "Paoting" (s 2))
(unit "Peiping" (s 2))
(unit "Phnom Penh" (s 2))
(unit "Saigon" (s 2))
(unit "Shanghai" (s 2))
(unit "Soochow" (s 2))
(unit "Swatow" (s 2))
(unit "Taiyuan" (s 2))
(unit "Tientsin" (s 2))
(unit "Tsinan" (s 2))
(unit "Tsingtao" (s 2))

(unit-defaults (@ 225 40))

(infantry 16 63 1)
(infantry 17 61 1)
(infantry 24 59 1)
(infantry 19 59 1)
(infantry 23 55 1)
(infantry 24 54 1)
(infantry 27 49 1)
(infantry 18 54 1)
(infantry 20 50 1)
(infantry 20 52 1)
(infantry 22 53 1)
(infantry 15 65 1)
(infantry 16 67 1)
(infantry 23 59 1)
(infantry 22 58 1)
(infantry 30 55 1)
(infantry 30 52 1)
(infantry 38 41 1)
(infantry 86 2 1)
(infantry 116 47 1 (in "Honolulu"))
(infantry 25 29 1)
(infantry 26 28 1)
(fighter 100 48 1 (in "Lexington"))
(fighter 100 48 1 (in "Lexington"))
(fighter 100 48 1 (in "Lexington"))
(fighter 100 48 1 (in "Lexington"))
(fighter 128 50 1 (in "Saratoga"))
(fighter 128 50 1 (in "Saratoga"))
(fighter 128 50 1 (in "Saratoga"))
(fighter 128 50 1 (in "Saratoga"))
(fighter 104 40 1 (in "Enterprise"))
(fighter 104 40 1 (in "Enterprise"))
(fighter 104 40 1 (in "Enterprise"))
(fighter 104 40 1 (in "Enterprise"))
(fighter 93 54 1 (in "Midway"))
(bomber 100 48 1 (in "Lexington"))
(bomber 128 50 1 (in "Saratoga"))
(bomber 104 40 1 (in "Enterprise"))
(bomber 93 54 1 (in "Midway"))
(destroyer 116 47 1 (in "Honolulu"))
(destroyer 116 47 1 (in "Honolulu"))
(destroyer 38 40 1 (in "Manila"))
(destroyer 38 40 1 (in "Manila"))
(destroyer 43 36 1 (in "Cebu"))
(destroyer 43 25 1)
(destroyer 41 29 1)
(submarine 116 47 1 (in "Honolulu"))
(submarine 116 47 1 (in "Honolulu"))
(submarine 38 40 1 (in "Manila"))
(submarine 38 40 1 (in "Manila"))
(submarine 38 40 1 (in "Manila"))
(submarine 38 40 1 (in "Manila"))
(|troop transport| 116 47 1 (in "Honolulu"))
(carrier 104 40 1 (n "Enterprise"))
(carrier 100 48 1 (n "Lexington"))
(carrier 128 50 1 (n "Saratoga"))

;; Note explicit damage to battleships.

(battleship 116 47 1 (n "California") (in "Honolulu") (hp 1))
(battleship 116 47 1 (n "Maryland") (in "Honolulu") (hp 7))
(battleship 116 47 1 (n "Nevada") (in "Honolulu") (hp 4))
(battleship 116 47 1 (n "Pennsylvania") (in "Honolulu") (hp 7))
(battleship 27 27 1 (n "Prince of Wales") (in "Singapore"))
(battleship 116 47 1 (n "Tennessee") (in "Honolulu"))
(battleship 116 47 1 (n "West Virginia") (in "Honolulu") (hp 2))

(base 93 54 1 (n "Midway"))

(city 128 52 1 (n "Seattle"))
(city 129 51 1 (n "San Francisco"))
(city 130 50 1 (n "Los Angeles"))
(city 131 49 1 (n "San Diego"))

;; Japanese forces.

(infantry 26 59 2)
(infantry 27 57 2)
(infantry 26 56 2)
(infantry 25 54 2)
(infantry 29 56 2)
(infantry 30 51 2)
(infantry 26 50 2)
(infantry 20 64 2)
(infantry 21 63 2)
(infantry 22 61 2)
(infantry 24 49 2)
(infantry 36 47 2 (in apj1))
(infantry 36 47 2 (in apj1))
(infantry 36 47 2 (in apj1))
(infantry 39 58 2)
(infantry 39 61 2)
(infantry 41 61 2)
(infantry 43 61 2)
(infantry 45 62 2)
(infantry 47 62 2)
(infantry 46 63 2)
(infantry 46 66 2)
(infantry 45 68 2)
(infantry 33 50 2)
(infantry 32 64 2)
(infantry 26 74 2)
(infantry 30 71 2)
(infantry 33 68 2)
(infantry 20 69 2)
(infantry 21 71 2)
(infantry 36 47 2 (in apj1))
(infantry 58 42 2 (in apj2))
(infantry 22 33 2 (in apj3))
(infantry 24 32 2 (in apj4))
(infantry 24 32 2 (in apj4))
(infantry 26 30 2 (in apj5))
(infantry 26 30 2 (in apj5))
(infantry 22 33 2 (in apj3))
(fighter 105 59 2 (in "Shokaku"))
(fighter 105 59 2 (in "Shokaku"))
(fighter 105 59 2 (in "Shokaku"))
(fighter 107 56 2 (in "Hiryu"))
(fighter 107 56 2 (in "Hiryu"))
(fighter 107 56 2 (in "Hiryu"))
(fighter 107 56 2 (in "Hiryu"))
(fighter 105 58 2 (in "Akagi"))
(fighter 105 58 2 (in "Akagi"))
(fighter 105 58 2 (in "Akagi"))
(fighter 105 58 2 (in "Akagi"))
(fighter 106 57 2 (in "Kaga"))
(fighter 106 57 2 (in "Kaga"))
(fighter 106 57 2 (in "Kaga"))
(fighter 106 57 2 (in "Kaga"))
(fighter 107 57 2 (in "Soryu"))
(fighter 107 57 2 (in "Soryu"))
(fighter 107 57 2 (in "Soryu"))
(fighter 107 57 2 (in "Soryu"))
(fighter 106 58 2 (in "Zuikaku"))
(fighter 106 58 2 (in "Zuikaku"))
(fighter 106 58 2 (in "Zuikaku"))
(fighter 106 58 2 (in "Zuikaku"))
(fighter 105 59 2 (in "Shokaku"))
(fighter 105 59 2 (in "Shokaku"))
(fighter 105 59 2 (in "Shokaku"))
(fighter 106 58 2 (in "Zuikaku"))
(fighter 107 57 2 (in "Soryu"))
(fighter 107 56 2 (in "Hiryu"))
(fighter 106 58 2 (in "Zuikaku"))
(fighter 106 57 2 (in "Kaga"))
(fighter 107 56 2 (in "Hiryu"))
(fighter 106 58 2 (in "Zuikaku"))
(fighter 105 59 2 (in "Shokaku"))
(fighter 105 59 2 (in "Shokaku"))
(fighter 106 58 2 (in "Zuikaku"))
(fighter 107 57 2 (in "Soryu"))
(fighter 107 57 2 (in "Soryu"))
(fighter 107 57 2 (in "Soryu"))
(destroyer 102 62 2)
(destroyer 102 61 2)
(destroyer 104 61 2)
(destroyer 103 59 2)
(destroyer 104 57 2)
(destroyer 106 55 2)
(destroyer 109 53 2)
(destroyer 111 55 2)
(destroyer 90 58 2)
(destroyer 92 58 2)
(destroyer 36 48 2)
(destroyer 37 47 2)
(destroyer 37 46 2)
(destroyer 42 44 2)
(destroyer 44 42 2)
(destroyer 32 44 2)
(destroyer 32 47 2)
(destroyer 34 42 2)
(destroyer 34 46 2)
(destroyer 35 46 2)
(destroyer 57 43 2)
(destroyer 23 33 2)
(destroyer 25 31 2)
(destroyer 27 29 2)
(submarine 106 60 2)
(submarine 107 59 2)
(submarine 108 58 2)
(|troop transport| 36 47 2 (sym apj1))
(|troop transport| 58 42 2 (sym apj2))
(|troop transport| 22 33 2 (sym apj3))
(|troop transport| 24 32 2 (sym apj4))
(|troop transport| 26 30 2 (sym apj5))
(carrier 105 58 2 (n "Akagi"))
(carrier 107 56 2 (n "Hiryu"))
(carrier 106 57 2 (n "Kaga"))
(carrier 105 59 2 (n "Shokaku"))
(carrier 107 57 2 (n "Soryu"))
(carrier 106 58 2 (n "Zuikaku"))
(battleship 32 46 2 (n "Haruna"))
(battleship 108 55 2 (n "Hiei"))
(battleship 108 56 2 (n "Kirishima"))
(battleship 32 45 2 (n "Kongo"))
