/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.typedarrays.client;

import com.google.gwt.core.client.JsArrayInteger;
import com.google.gwt.typedarrays.client.ArrayBufferNative;
import com.google.gwt.typedarrays.client.JsUtils;
import com.google.gwt.typedarrays.client.Uint8ArrayNative;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.Uint8Array;
import com.google.gwt.typedarrays.shared.Uint8ClampedArray;

public class Uint8ClampedArrayNativeEmul
implements Uint8ClampedArray {
    private final Uint8Array real;

    public static Uint8ClampedArray create(ArrayBuffer buffer, int byteOffset, int length) {
        return new Uint8ClampedArrayNativeEmul(buffer, byteOffset, length);
    }

    public static Uint8ClampedArray create(short[] array) {
        int len = array.length;
        Uint8ClampedArray result = Uint8ClampedArrayNativeEmul.create(ArrayBufferNative.create(len), 0, len);
        result.set(array);
        return result;
    }

    public static Uint8ClampedArray create(JsArrayInteger array) {
        int len = array.length();
        Uint8ClampedArray result = Uint8ClampedArrayNativeEmul.create(ArrayBufferNative.create(len), 0, len);
        JsUtils.set(result, array);
        return result;
    }

    private static short clamp(int val) {
        return (short)Math.max(0, Math.min(val, 255));
    }

    protected Uint8ClampedArrayNativeEmul(ArrayBuffer buffer, int byteOffset, int length) {
        this.real = Uint8ArrayNative.create(buffer, byteOffset, length);
    }

    @Override
    public ArrayBuffer buffer() {
        return this.real.buffer();
    }

    @Override
    public int byteLength() {
        return this.real.byteLength();
    }

    @Override
    public int byteOffset() {
        return this.real.byteOffset();
    }

    @Override
    public short get(int index) {
        return this.real.get(index);
    }

    @Override
    public int length() {
        return this.real.length();
    }

    @Override
    public void set(int index, int value) {
        this.real.set(index, (int)Uint8ClampedArrayNativeEmul.clamp(value));
    }

    @Override
    public void set(int[] array) {
        this.set(array, 0);
    }

    @Override
    public void set(int[] array, int offset) {
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            this.real.set(offset++, (int)Uint8ClampedArrayNativeEmul.clamp(array[i]));
        }
    }

    @Override
    public void set(short[] array) {
        this.set(array, 0);
    }

    @Override
    public void set(short[] array, int offset) {
        int len = array.length;
        for (int i = 0; i < len; ++i) {
            this.real.set(offset++, (int)Uint8ClampedArrayNativeEmul.clamp(array[i]));
        }
    }

    @Override
    public void set(Uint8Array array) {
        this.set(array, 0);
    }

    @Override
    public void set(Uint8Array array, int offset) {
        int len = array.length();
        for (int i = 0; i < len; ++i) {
            this.real.set(offset++, (int)Uint8ClampedArrayNativeEmul.clamp(array.get(i)));
        }
    }

    @Override
    public Uint8ClampedArray subarray(int begin) {
        return this.subarray(begin, this.byteLength());
    }

    @Override
    public Uint8ClampedArray subarray(int begin, int end) {
        int len = this.byteLength();
        if (begin < 0) {
            begin += len;
        }
        if (end < 0) {
            end += len;
        }
        if (begin < 0) {
            begin = 0;
        } else if (begin > len) {
            begin = len;
        }
        if (end < begin) {
            end = begin;
        } else if (end > len) {
            end = len;
        }
        return new Uint8ClampedArrayNativeEmul(this.buffer(), this.byteOffset() + begin, end - begin);
    }
}

