/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.srp6;

import gnu.java.security.key.IKeyPairGenerator;
import gnu.java.security.util.PRNG;
import gnu.java.security.util.Prime2;
import gnu.javax.crypto.key.srp6.SRPAlgorithm;
import gnu.javax.crypto.key.srp6.SRPPrivateKey;
import gnu.javax.crypto.key.srp6.SRPPublicKey;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SRPKeyPairGenerator
implements IKeyPairGenerator {
    private static final String NAME = "srp";
    private static final boolean DEBUG = false;
    private static final int debuglevel = 5;
    private static final PrintWriter err = new PrintWriter(System.out, true);
    private static final BigInteger ZERO = BigInteger.ZERO;
    private static final BigInteger ONE = BigInteger.ONE;
    private static final BigInteger TWO = BigInteger.valueOf(2);
    private static final BigInteger THREE = BigInteger.valueOf(3);
    public static final String MODULUS_LENGTH = "gnu.crypto.srp.L";
    public static final String USE_DEFAULTS = "gnu.crypto.srp.use.defaults";
    public static final String SHARED_MODULUS = "gnu.crypto.srp.N";
    public static final String GENERATOR = "gnu.crypto.srp.g";
    public static final String USER_VERIFIER = "gnu.crypto.srp.v";
    public static final String SOURCE_OF_RANDOMNESS = "gnu.crypto.srp.prng";
    private static final int DEFAULT_MODULUS_LENGTH = 1024;
    private SecureRandom rnd;
    private int l;
    private BigInteger N;
    private BigInteger g;
    private BigInteger v;
    private PRNG prng;

    private static final void debug(String string) {
        err.println(">>> srp: " + string);
    }

    public String name() {
        return NAME;
    }

    public void setup(Map map) {
        this.rnd = (SecureRandom)map.get(SOURCE_OF_RANDOMNESS);
        this.N = (BigInteger)map.get(SHARED_MODULUS);
        if (this.N != null) {
            this.l = this.N.bitLength();
            this.g = (BigInteger)map.get(GENERATOR);
            if (this.g == null) {
                this.g = TWO;
            }
            SRPAlgorithm.checkParams(this.N, this.g);
        } else {
            Boolean bl = (Boolean)map.get(USE_DEFAULTS);
            if (bl == null) {
                bl = Boolean.TRUE;
            }
            Integer n = (Integer)map.get(MODULUS_LENGTH);
            this.l = 1024;
            if (bl.equals(Boolean.TRUE)) {
                if (n != null) {
                    this.l = n;
                    switch (this.l) {
                        case 512: {
                            this.N = SRPAlgorithm.N_512;
                            break;
                        }
                        case 640: {
                            this.N = SRPAlgorithm.N_640;
                            break;
                        }
                        case 768: {
                            this.N = SRPAlgorithm.N_768;
                            break;
                        }
                        case 1024: {
                            this.N = SRPAlgorithm.N_1024;
                            break;
                        }
                        case 1280: {
                            this.N = SRPAlgorithm.N_1280;
                            break;
                        }
                        case 1536: {
                            this.N = SRPAlgorithm.N_1536;
                            break;
                        }
                        case 2048: {
                            this.N = SRPAlgorithm.N_2048;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unknown default shared modulus bit length");
                        }
                    }
                    this.g = TWO;
                    this.l = this.N.bitLength();
                }
            } else if (n != null) {
                this.l = n;
                if (this.l % 256 != 0 || this.l < 512 || this.l > 2048) {
                    throw new IllegalArgumentException("invalid shared modulus bit length");
                }
            }
        }
        this.v = (BigInteger)map.get(USER_VERIFIER);
    }

    public KeyPair generate() {
        if (this.N == null) {
            BigInteger[] bigIntegerArray = this.generateParameters();
            BigInteger bigInteger = bigIntegerArray[0];
            this.N = bigIntegerArray[1];
            this.g = bigIntegerArray[2];
        }
        return this.v != null ? this.hostKeyPair() : this.userKeyPair();
    }

    private final synchronized BigInteger[] generateParameters() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        byte[] byArray = new byte[this.l / 8];
        do {
            this.nextRandomBytes(byArray);
            bigInteger2 = new BigInteger(1, byArray);
        } while (!Prime2.isProbablePrime(bigInteger2 = bigInteger2.setBit(0).setBit(this.l - 2).clearBit(this.l - 1)) || (bigInteger = bigInteger2.multiply(TWO).add(ONE)).bitLength() != this.l || !Prime2.isProbablePrime(bigInteger));
        BigInteger bigInteger3 = bigInteger.subtract(ONE);
        BigInteger bigInteger4 = TWO;
        BigInteger bigInteger5 = TWO;
        while (bigInteger5.compareTo(bigInteger3) < 0) {
            bigInteger4 = bigInteger5.modPow(TWO, bigInteger);
            if (!bigInteger4.equals(ONE)) break;
            bigInteger5 = bigInteger5.add(ONE);
        }
        return new BigInteger[]{bigInteger2, bigInteger, bigInteger4};
    }

    private final KeyPair hostKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        byte[] byArray = new byte[(this.l + 7) / 8];
        do {
            this.nextRandomBytes(byArray);
        } while ((bigInteger2 = new BigInteger(1, byArray)).compareTo(ONE) <= 0 || bigInteger2.compareTo(this.N) >= 0 || (bigInteger = THREE.multiply(this.v).add(this.g.modPow(bigInteger2, this.N)).mod(this.N)).compareTo(ZERO) == 0 || bigInteger.compareTo(this.N) >= 0);
        KeyPair keyPair = new KeyPair(new SRPPublicKey(new BigInteger[]{this.N, this.g, bigInteger}), new SRPPrivateKey(new BigInteger[]{this.N, this.g, bigInteger2, this.v}));
        return keyPair;
    }

    private final KeyPair userKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        byte[] byArray = new byte[(this.l + 7) / 8];
        do {
            this.nextRandomBytes(byArray);
        } while ((bigInteger2 = new BigInteger(1, byArray)).compareTo(ONE) <= 0 || bigInteger2.compareTo(this.N) >= 0 || (bigInteger = this.g.modPow(bigInteger2, this.N)).compareTo(ZERO) == 0 || bigInteger.compareTo(this.N) >= 0);
        KeyPair keyPair = new KeyPair(new SRPPublicKey(new BigInteger[]{this.N, this.g, bigInteger}), new SRPPrivateKey(new BigInteger[]{this.N, this.g, bigInteger2}));
        return keyPair;
    }

    private final void nextRandomBytes(byte[] byArray) {
        if (this.rnd != null) {
            this.rnd.nextBytes(byArray);
        } else {
            this.getDefaultPRNG().nextBytes(byArray);
        }
    }

    private final PRNG getDefaultPRNG() {
        if (this.prng == null) {
            this.prng = PRNG.getInstance();
        }
        return this.prng;
    }

    private final /* synthetic */ void this() {
        this.rnd = null;
        this.prng = null;
    }

    public SRPKeyPairGenerator() {
        this.this();
    }
}

